/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen.builders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithTransformRecipe;

public class GemsmithRecipeBuilder {
    private final Ingredient tool;
    private final Ingredient gem;
    private final RecipeCategory category;
    private final Item result;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public GemsmithRecipeBuilder(Ingredient pTool, Ingredient pGem, RecipeCategory pCategory, Item pResult) {
        this.category = pCategory;
        this.tool = pTool;
        this.gem = pGem;
        this.result = pResult;
    }

    public static GemsmithRecipeBuilder smithing(Ingredient pTool, Ingredient pGem, RecipeCategory pCategory, Item pResult) {
        return new GemsmithRecipeBuilder(pTool, pGem, pCategory, pResult);
    }

    public GemsmithRecipeBuilder unlocks(String key, Criterion<?> criterion) {
        this.criteria.put(key, criterion);
        return this;
    }

    public void save(RecipeOutput recipeOutput, String recipeId) {
        this.save(recipeOutput, ResourceLocation.parse((String)recipeId));
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(advancement$builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        GemsmithTransformRecipe recipe = new GemsmithTransformRecipe(this.tool, this.gem, new ItemStack((ItemLike)this.result));
        recipeOutput.accept(recipeId, (Recipe)recipe, advancement$builder.build(recipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation location) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(location));
        }
    }
}

