/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.datagen.loot;

import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    public ModBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        for (Map.Entry<DeferredBlock<?>, ItemLike> entry : VWRegistryHelper.BLOCK_DROPS.entrySet()) {
            if (VWRegistryHelper.BLOCK_MODELS.get((Object)VWRegistryHelper.Models.SLAB) != null && VWRegistryHelper.BLOCK_MODELS.get((Object)VWRegistryHelper.Models.SLAB).contains(entry.getKey())) {
                this.add((Block)entry.getKey().get(), this.createSlabItemTable((Block)entry.getKey().get()));
                continue;
            }
            if (VWRegistryHelper.BLOCK_MODELS.get((Object)VWRegistryHelper.Models.DOOR) != null && VWRegistryHelper.BLOCK_MODELS.get((Object)VWRegistryHelper.Models.DOOR).contains(entry.getKey())) {
                this.add((Block)entry.getKey().get(), this.createDoorTable((Block)entry.getKey().get()));
                continue;
            }
            if (VWRegistryHelper.BLOCK_SILK_DROPS.containsKey(entry.getKey().get())) {
                this.createOreDrop((Block)entry.getKey().get(), entry.getValue().asItem());
                continue;
            }
            this.dropOther((Block)entry.getKey().get(), entry.getValue());
        }
        this.add((Block)VWBlocks.CRYSTALIC_OAK_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)VWBlocks.CRYSTALIC_OAK_SAPLING.get(), new float[]{0.25f}));
        this.add((Block)VWBlocks.BLUE_JACARANDA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)VWBlocks.BLUE_JACARANDA_SAPLING.get(), new float[]{0.25f}));
        this.add((Block)VWBlocks.SODALITE_WART.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)VWItems.SODALITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)VWItems.SODALITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.dropPottedContents((Block)VWBlocks.POTTED_SODALITE_WART.get());
        this.dropPottedContents((Block)VWBlocks.POTTED_CRYSTALIC_OAK_SAPLING.get());
        this.dropPottedContents((Block)VWBlocks.POTTED_BLUE_JACARANDA_SAPLING.get());
        this.add((Block)VWBlocks.BUDDING_SODALITE.get(), ModBlockLootTableProvider.noDrop());
        this.add((Block)VWBlocks.SODALITE_CLUSTER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)VWItems.SODALITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.dropWhenSilkTouch((Block)VWBlocks.MEDIUM_SODALITE_BUD.get());
        this.dropWhenSilkTouch((Block)VWBlocks.SMALL_SODALITE_BUD.get());
        this.add((Block)VWBlocks.RECLAIMITE_CRYSTAL.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(VWItems.RECLAIMITE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem(VWItems.RECLAIMITE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.add((Block)VWBlocks.BLUE_JACARANDA_PETALS.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add((Block)VWBlocks.CRYSTALIC_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)VWBlocks.DIRT_WITH_CRYSTALS.get()));
    }

    protected Iterable<Block> getKnownBlocks() {
        return VWRegistryHelper.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

