/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.mixin.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Shadow
    public abstract SoundEvent getBreakingSound();

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    private void appendDesc(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag, CallbackInfo ci) {
        Item item = (Item)this;
        if (item instanceof TieredItem && ModConfigController.CRYSTALING_CONFIG_VALUES != null && stack.has((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get()) && ((CrystalData)stack.get((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get())).crystalDurability() > 0) {
            List<ModConfigController.GemsmithingSetting> setting = ModConfigController.CRYSTALING_CONFIG_VALUES;
            for (ModConfigController.GemsmithingSetting crystalingSetting : setting) {
                if (!((SupplyCrystalData)((CrystalData)stack.get((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get())).crystalStack().get((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get())).crystalStack().is(crystalingSetting.item().build())) continue;
                tooltipComponents.add(((SupplyCrystalData)((CrystalData)stack.get((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get())).crystalStack().get((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get())).crystalStack().getDisplayName());
            }
        }
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")})
    private void handleAttack(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        CrystalData data = (CrystalData)stack.get((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get());
        if (data != null && data.crystalStack().has((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get()) && !((SupplyCrystalData)data.crystalStack().get((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get())).crystalStack().isEmpty()) {
            if (data.crystalDurability() > 0) {
                stack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(data.crystalStack(), data.crystalDurability() - 1));
            } else {
                attacker.playSound(this.getBreakingSound(), 2.0f, 1.5f);
                OnActionsTrigger.returnDefaultStack(stack, attacker);
            }
        }
    }

    @Inject(method={"mineBlock"}, at={@At(value="HEAD")})
    private void handleMine(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity, CallbackInfoReturnable<Boolean> cir) {
        CrystalData data = (CrystalData)stack.get((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get());
        if (data != null && data.crystalStack().has((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get()) && !((SupplyCrystalData)data.crystalStack().get((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get())).crystalStack().isEmpty()) {
            if (data.crystalDurability() > 0) {
                stack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(data.crystalStack(), data.crystalDurability() - 1));
            } else {
                miningEntity.playSound(this.getBreakingSound());
                OnActionsTrigger.returnDefaultStack(stack, miningEntity);
            }
        }
    }
}

