/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.neoforge;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.config.ModConfigFactory;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.layers.BiomeLayer;
import cc.cassian.immersiveoverlays.layers.ClockLayer;
import cc.cassian.immersiveoverlays.layers.CompassLayer;
import cc.cassian.immersiveoverlays.layers.SpeedLayer;
import cc.cassian.immersiveoverlays.layers.TemperatureLayer;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="immersiveoverlays", dist={Dist.CLIENT})
@EventBusSubscriber(modid="immersiveoverlays")
public class ImmersiveOverlaysNeoForgeClient {
    public ImmersiveOverlaysNeoForgeClient(IEventBus eventBus, ModContainer modContainer) {
        ModClient.init("neoforge");
        ImmersiveOverlaysNeoForgeClient.registerModsPage();
    }

    @SubscribeEvent
    public static void loadComplete(FMLClientSetupEvent event) {
        ModLists.loadLists();
    }

    @SubscribeEvent
    public static void renderGameOverlayEvent(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ModClient.locate("biome"), (GuiLayer)new BiomeLayer());
        event.registerAboveAll(ModClient.locate("clock"), (GuiLayer)new ClockLayer());
        event.registerAboveAll(ModClient.locate("compass"), (GuiLayer)new CompassLayer());
        event.registerAboveAll(ModClient.locate("speed"), (GuiLayer)new SpeedLayer());
        event.registerAboveAll(ModClient.locate("temperature"), (GuiLayer)new TemperatureLayer());
    }

    @SubscribeEvent
    public static void checkInventoryForOverlays(ClientTickEvent.Post event) {
        OverlayHelpers.checkInventoryForOverlays(Minecraft.getInstance());
        OverlayHelpers.checkKeybind();
    }

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(ModClient.overlayToggle);
        event.registerCategory(ModClient.CATEGORY);
    }

    public static void registerModsPage() {
        if (ModCompat.CLOTH_CONFIG) {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, ModConfigFactory::new);
        }
    }
}

