/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.config;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.Platform;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public int version = 2;
    public boolean enabled = true;
    public boolean locator_bar = true;
    public boolean avoid_overlapping = true;
    public boolean moved_by_effects = true;
    public boolean require_item = true;
    public boolean require_item_in_hand = false;
    public boolean search_containers = true;
    public boolean search_containers_for_containers = true;
    public boolean render_background = true;
    public boolean hide_from_debug = true;
    public boolean compass_enable = true;
    public int compass_vertical_position = 140;
    public boolean compass_horizontal_position_left = false;
    public int compass_text_colour = 0xE0E0E0;
    public String compass_x_colour = "Red";
    public String compass_y_colour = "Green";
    public String compass_z_colour = "Blue";
    public List<String> compass_x_items = List.of("minecraft:compass", "minecraft:recovery_compass", "spelunkery:magnetic_compass", "firmaciv:nav_clock", "firmaciv:firmaciv_compass");
    public List<String> compass_y_items = List.of("spelunkery:depth_gauge", "caverns_and_chasms:depth_gauge", "additionaladditions:depth_meter", "supplementaries:altimeter", "depthmeter:depthmeter");
    public List<String> compass_z_items = List.of("firmaciv:sextant");
    public boolean clock_enable = true;
    public boolean clock_current_time = true;
    public boolean clock_day_count = false;
    public boolean clock_24_hour = true;
    public boolean clock_seasons = true;
    public int clock_text_colour = 0xE0E0E0;
    public int clock_vertical_position = 85;
    public boolean clock_horizontal_position_left = false;
    public List<String> clock_items = List.of("minecraft:clock");
    public List<String> clock_weather_items = List.of("caverns_and_chasms:barometer", "firmaciv:barometer");
    public boolean temperature_enable = true;
    public boolean temperature_icons = true;
    public int temperature_hot_colour = 16759694;
    public int temperature_cold_colour = 0x8EFFFF;
    public int temperature_temperate_colour = 0xFFFFFF;
    public int temperature_vertical_position = 112;
    public boolean temperature_horizontal_position_left = true;
    public List<String> temperature_items = List.of("oreganized:thermometer", "toughasnails:thermometer", "legendarysurvivaloverhaul:thermometer", "cold_sweat:thermometer");
    public boolean compat_playerlocatorplus = true;
    public boolean compat_xaeros = true;
    public boolean compat_antique_atlas = true;
    public boolean compat_accessorify = true;
    public boolean compat_tough_as_nails_temperature = true;
    public boolean compat_thermoo_temperature = true;
    public boolean biome_enable = true;
    public boolean biome_icons = true;
    public boolean biome_reduced_info = false;
    public boolean biome_text_tinted = true;
    public int biome_text_colour = 0xE0E0E0;
    public int biome_vertical_position = 112;
    public boolean biome_horizontal_position_left = false;
    public List<String> biome_items = List.of("minecraft:map", "minecraft:empty_map", "map_atlases:atlas", "map_atlases:end_atlas", "map_atlases:nether_atlas", "naturescompass:naturescompass", "antiqueatlas:antique_atlas");
    public List<String> season_items = List.of("sereneseasons:calendar", "seasonsextras:season_calendar", "eclipticseasons:calendar");
    public boolean speed_enable = true;
    public int speed_vertical_position = 140;
    public boolean speed_horizontal_position_left = true;
    public int speed_colour = 13090689;
    public List<String> speed_items = List.of("oreganized:speedometer", "speedometer:speedometer");
    public boolean compat_oreganized_speed = true;
    public boolean compat_jade = false;
    public List<String> compat_waila_items = List.of("minecraft:spyglass", "create:goggles");
    public boolean compat_map_atlases = false;
    public boolean compat_serene_seasons = true;
    public boolean compat_fabric_seasons = true;
    public boolean compat_simple_seasons = true;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try {
            String s = Files.readString(ModConfig.configPath(), Charset.defaultCharset());
            if (!s.contains("version")) {
                ModConfig.save();
                return;
            }
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Upgrading config file to version: 2");
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
            if (ModConfig.INSTANCE.version != 2) {
                INSTANCE = new ModConfig();
                ModConfig.save();
            }
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to save config file!");
        }
        ModLists.loadLists();
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    static Path configPath() {
        return Platform.INSTANCE.configPath().resolve("immersiveoverlays.json");
    }
}

