/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.block;

import net.mcreator.nosysnaturalexpansion.procedures.WallMushroomBlockValidPlacementConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallMushroomBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public WallMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(0.02f, 0.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)WallMushroomBlock.box((double)9.0, (double)5.75, (double)-4.0, (double)18.0, (double)7.25, (double)3.0), (VoxelShape[])new VoxelShape[]{WallMushroomBlock.box((double)10.0, (double)5.0, (double)-3.15, (double)17.0, (double)5.75, (double)1.85), WallMushroomBlock.box((double)-3.0, (double)8.0, (double)-6.0, (double)6.0, (double)10.0, (double)3.0), WallMushroomBlock.box((double)-1.5, (double)7.0, (double)-4.5, (double)4.5, (double)8.0, (double)1.5), WallMushroomBlock.box((double)3.0, (double)3.0, (double)0.0, (double)9.0, (double)4.0, (double)2.0), WallMushroomBlock.box((double)3.75, (double)2.5, (double)0.0, (double)8.25, (double)3.0, (double)1.25)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WallMushroomBlock.box((double)-2.0, (double)5.75, (double)13.0, (double)7.0, (double)7.25, (double)20.0), (VoxelShape[])new VoxelShape[]{WallMushroomBlock.box((double)-1.0, (double)5.0, (double)14.15, (double)6.0, (double)5.75, (double)19.15), WallMushroomBlock.box((double)10.0, (double)8.0, (double)13.0, (double)19.0, (double)10.0, (double)22.0), WallMushroomBlock.box((double)11.5, (double)7.0, (double)14.5, (double)17.5, (double)8.0, (double)20.5), WallMushroomBlock.box((double)7.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)16.0), WallMushroomBlock.box((double)7.75, (double)2.5, (double)14.75, (double)12.25, (double)3.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)WallMushroomBlock.box((double)-4.0, (double)5.75, (double)-2.0, (double)3.0, (double)7.25, (double)7.0), (VoxelShape[])new VoxelShape[]{WallMushroomBlock.box((double)-3.15, (double)5.0, (double)-1.0, (double)1.85, (double)5.75, (double)6.0), WallMushroomBlock.box((double)-6.0, (double)8.0, (double)10.0, (double)3.0, (double)10.0, (double)19.0), WallMushroomBlock.box((double)-4.5, (double)7.0, (double)11.5, (double)1.5, (double)8.0, (double)17.5), WallMushroomBlock.box((double)0.0, (double)3.0, (double)7.0, (double)2.0, (double)4.0, (double)13.0), WallMushroomBlock.box((double)0.0, (double)2.5, (double)7.75, (double)1.25, (double)3.0, (double)12.25)});
            case Direction.WEST -> Shapes.or((VoxelShape)WallMushroomBlock.box((double)13.0, (double)5.75, (double)9.0, (double)20.0, (double)7.25, (double)18.0), (VoxelShape[])new VoxelShape[]{WallMushroomBlock.box((double)14.15, (double)5.0, (double)10.0, (double)19.15, (double)5.75, (double)17.0), WallMushroomBlock.box((double)13.0, (double)8.0, (double)-3.0, (double)22.0, (double)10.0, (double)6.0), WallMushroomBlock.box((double)14.5, (double)7.0, (double)-1.5, (double)20.5, (double)8.0, (double)4.5), WallMushroomBlock.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)4.0, (double)9.0), WallMushroomBlock.box((double)14.75, (double)2.5, (double)3.75, (double)16.0, (double)3.0, (double)8.25)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag;
        boolean bl = flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WallMushroomBlockValidPlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return !state.canSurvive(world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

