/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.nosysnaturalexpansion.client.model.ModelDragonfly;
import net.mcreator.nosysnaturalexpansion.client.model.animations.DragonflyAnimation;
import net.mcreator.nosysnaturalexpansion.entity.DragonflyEntity;
import net.mcreator.nosysnaturalexpansion.procedures.DragonflyDisplayCondition2Procedure;
import net.mcreator.nosysnaturalexpansion.procedures.DragonflyDisplayCondition3Procedure;
import net.mcreator.nosysnaturalexpansion.procedures.DragonflyDisplayConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class DragonflyRenderer
extends MobRenderer<DragonflyEntity, LivingEntityRenderState, ModelDragonfly> {
    private DragonflyEntity entity = null;

    public DragonflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelDragonfly.LAYER_LOCATION)), 0.8f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelDragonfly>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/dragonflytexturegreen.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DragonflyRenderer.this.entity.level();
                double x = DragonflyRenderer.this.entity.getX();
                double y = DragonflyRenderer.this.entity.getY();
                double z = DragonflyRenderer.this.entity.getZ();
                if (DragonflyDisplayConditionProcedure.execute((Entity)DragonflyRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelDragonfly)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelDragonfly>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/dragonflytexturepurple.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DragonflyRenderer.this.entity.level();
                double x = DragonflyRenderer.this.entity.getX();
                double y = DragonflyRenderer.this.entity.getY();
                double z = DragonflyRenderer.this.entity.getZ();
                if (DragonflyDisplayCondition2Procedure.execute((Entity)DragonflyRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelDragonfly)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelDragonfly>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/dragonflytexturered.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DragonflyRenderer.this.entity.level();
                double x = DragonflyRenderer.this.entity.getX();
                double y = DragonflyRenderer.this.entity.getY();
                double z = DragonflyRenderer.this.entity.getZ();
                if (DragonflyDisplayCondition3Procedure.execute((Entity)DragonflyRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelDragonfly)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(DragonflyEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/dragonflytexturered.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelDragonfly {
        private DragonflyEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = DragonflyAnimation.FLY_ANIMATION.bake(root);
            this.keyframeAnimation1 = DragonflyAnimation.FLY_ANIMATION.bake(root);
        }

        public void setEntity(DragonflyEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            super.setupAnim(state);
        }
    }
}

