/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.nosysnaturalexpansion.client.model.ModelFennecFox;
import net.mcreator.nosysnaturalexpansion.client.model.animations.FennecFoxAnimation;
import net.mcreator.nosysnaturalexpansion.entity.FennecFoxEntity;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxPlaybackConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FennecFoxRenderer
extends MobRenderer<FennecFoxEntity, LivingEntityRenderState, ModelFennecFox> {
    private FennecFoxEntity entity = null;

    public FennecFoxRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelFennecFox.LAYER_LOCATION)), 0.4f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelFennecFox>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/fennecfoxtexturesleeping.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = FennecFoxRenderer.this.entity.level();
                double x = FennecFoxRenderer.this.entity.getX();
                double y = FennecFoxRenderer.this.entity.getY();
                double z = FennecFoxRenderer.this.entity.getZ();
                if (FennecFoxPlaybackConditionProcedure.execute((Entity)FennecFoxRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelFennecFox)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(FennecFoxEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/fennecfoxtexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelFennecFox {
        private FennecFoxEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;
        private final KeyframeAnimation keyframeAnimation4;
        private final KeyframeAnimation keyframeAnimation5;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = FennecFoxAnimation.WALK_ANIMATION.bake(root);
            this.keyframeAnimation1 = FennecFoxAnimation.ALERT_ANIMATION.bake(root);
            this.keyframeAnimation2 = FennecFoxAnimation.SITTING_ANIMATION.bake(root);
            this.keyframeAnimation3 = FennecFoxAnimation.ATTACK_ANIMATION.bake(root);
            this.keyframeAnimation4 = FennecFoxAnimation.PLAYFUL_ANIMATION.bake(root);
            this.keyframeAnimation5 = FennecFoxAnimation.IDLE_ANIMATION.bake(root);
        }

        public void setEntity(FennecFoxEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            this.keyframeAnimation4.apply(this.entity.animationState4, state.ageInTicks, 1.0f);
            this.keyframeAnimation5.apply(this.entity.animationState5, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

