/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.nosysnaturalexpansion.client.model.ModelHedgehog;
import net.mcreator.nosysnaturalexpansion.client.model.animations.HedgehogAnimation;
import net.mcreator.nosysnaturalexpansion.entity.HedgehogEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HedgehogRenderer
extends MobRenderer<HedgehogEntity, LivingEntityRenderState, ModelHedgehog> {
    private HedgehogEntity entity = null;

    public HedgehogRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelHedgehog.LAYER_LOCATION)), 0.8f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(HedgehogEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/hedgehogtexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelHedgehog {
        private HedgehogEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = HedgehogAnimation.WALK_ANIMATION.bake(root);
            this.keyframeAnimation1 = HedgehogAnimation.IDLE_ANIMATION.bake(root);
            this.keyframeAnimation2 = HedgehogAnimation.EAT_ANIMATION.bake(root);
            this.keyframeAnimation3 = HedgehogAnimation.SITTING_ANIMATION.bake(root);
        }

        public void setEntity(HedgehogEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 3.0f, 10.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

