/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.nosysnaturalexpansion.client.model.ModelLadybug;
import net.mcreator.nosysnaturalexpansion.client.model.animations.LadybugAnimation;
import net.mcreator.nosysnaturalexpansion.entity.LadybugEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class LadybugRenderer
extends MobRenderer<LadybugEntity, LivingEntityRenderState, ModelLadybug> {
    private LadybugEntity entity = null;

    public LadybugRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelLadybug.LAYER_LOCATION)), 0.4f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(LadybugEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/ladybug_new_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelLadybug {
        private LadybugEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = LadybugAnimation.WALKING_ANIMATION.bake(root);
            this.keyframeAnimation1 = LadybugAnimation.IDLE_ANIMATION.bake(root);
            this.keyframeAnimation2 = LadybugAnimation.FLYING_ANIMATION.bake(root);
        }

        public void setEntity(LadybugEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 3.0f, 10.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

