/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.nosysnaturalexpansion.client.model.ModelQueenFirefly;
import net.mcreator.nosysnaturalexpansion.client.model.animations.QueenFireflyAnimation;
import net.mcreator.nosysnaturalexpansion.entity.QueenFireflyEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class QueenFireflyRenderer
extends MobRenderer<QueenFireflyEntity, LivingEntityRenderState, ModelQueenFirefly> {
    private QueenFireflyEntity entity = null;

    public QueenFireflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelQueenFirefly.LAYER_LOCATION)), 0.8f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(QueenFireflyEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"nosys_natural_expansion:textures/entities/queenfireflytexture2.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelQueenFirefly {
        private QueenFireflyEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = QueenFireflyAnimation.FLYING_ANIMATION.bake(root);
            this.keyframeAnimation1 = QueenFireflyAnimation.FLYING_ANIMATION.bake(root);
        }

        public void setEntity(QueenFireflyEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            super.setupAnim(state);
        }
    }
}

