/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.nosysnaturalexpansion.entity.HedgehogEntity;
import net.mcreator.nosysnaturalexpansion.init.NosysNaturalExpansionModEntities;
import net.mcreator.nosysnaturalexpansion.procedures.FennecAttackConditionProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFollowOwnerConditionProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxOnEntityTickUpdateProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxOnInitialEntitySpawnProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxPlaybackCondition2Procedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxPlaybackCondition3Procedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxPlaybackCondition4Procedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxPlaybackConditionProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecFoxRightClickedOnEntityProcedure;
import net.mcreator.nosysnaturalexpansion.procedures.FennecPanicProcedure;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FennecFoxEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Boolean> DATA_Sit = SynchedEntityData.defineId(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsAttacking = SynchedEntityData.defineId(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsAlert = SynchedEntityData.defineId(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsPlayful = SynchedEntityData.defineId(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_cooldown = SynchedEntityData.defineId(FennecFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public FennecFoxEntity(EntityType<FennecFoxEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Sit, (Object)false);
        builder.define(DATA_IsAttacking, (Object)false);
        builder.define(DATA_IsAlert, (Object)false);
        builder.define(DATA_IsPlayful, (Object)false);
        builder.define(DATA_cooldown, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Bogged.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, CaveSpider.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true, true){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canContinueToUse() && FennecAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new PanicGoal((PathfinderMob)this, 2.0){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecPanicProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.RABBIT), false));
        this.goalSelector.addGoal(13, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.RABBIT_FOOT), false));
        this.goalSelector.addGoal(14, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.RABBIT_HIDE), false));
        this.goalSelector.addGoal(15, (Goal)new LookAtPlayerGoal((Mob)this, Fox.class, 6.0f));
        this.goalSelector.addGoal(16, (Goal)new LookAtPlayerGoal((Mob)this, Wolf.class, 6.0f));
        this.goalSelector.addGoal(17, (Goal)new LookAtPlayerGoal((Mob)this, Cat.class, 6.0f));
        this.goalSelector.addGoal(18, (Goal)new LookAtPlayerGoal((Mob)this, HedgehogEntity.class, 6.0f));
        this.goalSelector.addGoal(19, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = FennecFoxEntity.this.getX();
                double y = FennecFoxEntity.this.getY();
                double z = FennecFoxEntity.this.getZ();
                FennecFoxEntity entity = FennecFoxEntity.this;
                Level world = FennecFoxEntity.this.level();
                return super.canUse() && FennecFollowOwnerConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(20, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(21, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(22, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(23, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(24, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.fox.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.fox.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.fox.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        FennecFoxOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("DataSit", ((Boolean)this.entityData.get(DATA_Sit)).booleanValue());
        valueOutput.putBoolean("DataIsAttacking", ((Boolean)this.entityData.get(DATA_IsAttacking)).booleanValue());
        valueOutput.putBoolean("DataIsAlert", ((Boolean)this.entityData.get(DATA_IsAlert)).booleanValue());
        valueOutput.putBoolean("DataIsPlayful", ((Boolean)this.entityData.get(DATA_IsPlayful)).booleanValue());
        valueOutput.putBoolean("Datacooldown", ((Boolean)this.entityData.get(DATA_cooldown)).booleanValue());
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.entityData.set(DATA_Sit, (Object)valueInput.getBooleanOr("DataSit", false));
        this.entityData.set(DATA_IsAttacking, (Object)valueInput.getBooleanOr("DataIsAttacking", false));
        this.entityData.set(DATA_IsAlert, (Object)valueInput.getBooleanOr("DataIsAlert", false));
        this.entityData.set(DATA_IsPlayful, (Object)valueInput.getBooleanOr("DataIsPlayful", false));
        this.entityData.set(DATA_cooldown, (Object)valueInput.getBooleanOr("Datacooldown", false));
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        FennecFoxEntity entity = this;
        Level world = this.level();
        FennecFoxRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(FennecFoxPlaybackCondition2Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(FennecFoxPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(FennecFoxPlaybackCondition3Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(FennecFoxPlaybackCondition4Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        FennecFoxOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        FennecFoxEntity retval = (FennecFoxEntity)((EntityType)NosysNaturalExpansionModEntities.FENNEC_FOX.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT, Items.RABBIT_FOOT, Items.RABBIT_HIDE}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)NosysNaturalExpansionModEntities.FENNEC_FOX.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

