/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nosysnaturalexpansion.init;

import net.mcreator.nosysnaturalexpansion.entity.BeetleEntity;
import net.mcreator.nosysnaturalexpansion.entity.CarnivorousPlantEntity;
import net.mcreator.nosysnaturalexpansion.entity.DragonflyEntity;
import net.mcreator.nosysnaturalexpansion.entity.FennecFoxEntity;
import net.mcreator.nosysnaturalexpansion.entity.HedgehogEntity;
import net.mcreator.nosysnaturalexpansion.entity.HermitCrabEntity;
import net.mcreator.nosysnaturalexpansion.entity.HummingBirdEntity;
import net.mcreator.nosysnaturalexpansion.entity.LadybugEntity;
import net.mcreator.nosysnaturalexpansion.entity.QueenFireflyEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class NosysNaturalExpansionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"nosys_natural_expansion");
    public static final DeferredHolder<EntityType<?>, EntityType<LadybugEntity>> LADYBUG = NosysNaturalExpansionModEntities.register("ladybug", EntityType.Builder.of(LadybugEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<HummingBirdEntity>> HUMMING_BIRD = NosysNaturalExpansionModEntities.register("humming_bird", EntityType.Builder.of(HummingBirdEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CarnivorousPlantEntity>> CARNIVOROUS_PLANT = NosysNaturalExpansionModEntities.register("carnivorous_plant", EntityType.Builder.of(CarnivorousPlantEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<BeetleEntity>> BEETLE = NosysNaturalExpansionModEntities.register("beetle", EntityType.Builder.of(BeetleEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.7f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<DragonflyEntity>> DRAGONFLY = NosysNaturalExpansionModEntities.register("dragonfly", EntityType.Builder.of(DragonflyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<QueenFireflyEntity>> QUEEN_FIREFLY = NosysNaturalExpansionModEntities.register("queen_firefly", EntityType.Builder.of(QueenFireflyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HedgehogEntity>> HEDGEHOG = NosysNaturalExpansionModEntities.register("hedgehog", EntityType.Builder.of(HedgehogEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HermitCrabEntity>> HERMIT_CRAB = NosysNaturalExpansionModEntities.register("hermit_crab", EntityType.Builder.of(HermitCrabEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<FennecFoxEntity>> FENNEC_FOX = NosysNaturalExpansionModEntities.register("fennec_fox", EntityType.Builder.of(FennecFoxEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nosys_natural_expansion", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        LadybugEntity.init(event);
        HummingBirdEntity.init(event);
        CarnivorousPlantEntity.init(event);
        BeetleEntity.init(event);
        DragonflyEntity.init(event);
        QueenFireflyEntity.init(event);
        HedgehogEntity.init(event);
        HermitCrabEntity.init(event);
        FennecFoxEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)LADYBUG.get(), LadybugEntity.createAttributes().build());
        event.put((EntityType)HUMMING_BIRD.get(), HummingBirdEntity.createAttributes().build());
        event.put((EntityType)CARNIVOROUS_PLANT.get(), CarnivorousPlantEntity.createAttributes().build());
        event.put((EntityType)BEETLE.get(), BeetleEntity.createAttributes().build());
        event.put((EntityType)DRAGONFLY.get(), DragonflyEntity.createAttributes().build());
        event.put((EntityType)QUEEN_FIREFLY.get(), QueenFireflyEntity.createAttributes().build());
        event.put((EntityType)HEDGEHOG.get(), HedgehogEntity.createAttributes().build());
        event.put((EntityType)HERMIT_CRAB.get(), HermitCrabEntity.createAttributes().build());
        event.put((EntityType)FENNEC_FOX.get(), FennecFoxEntity.createAttributes().build());
    }
}

