/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.events;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import de.cadentem.quality_food.client.ClientProxy;
import de.cadentem.quality_food.config.ClientConfig;
import de.cadentem.quality_food.core.EffectComponent;
import de.cadentem.quality_food.util.QualityUtils;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeEvents {
    private static final DecimalFormat FORMAT = new DecimalFormat("###.##");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleFishing(ItemFishedEvent event) {
        if (event.getHookEntity() != null && event.getHookEntity().m_9236_().m_5776_()) {
            return;
        }
        event.getDrops().forEach(drop -> QualityUtils.applyQuality(drop, event.getEntity()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLoot(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        event.getDrops().forEach(drop -> {
            Player player;
            Entity patt2011$temp;
            QualityUtils.applyQuality(drop.m_32055_(), (patt2011$temp = event.getSource().m_7639_()) instanceof Player ? (player = (Player)patt2011$temp) : null);
        });
    }

    @SubscribeEvent
    public static void addTooltip(ItemTooltipEvent event) {
        if (ClientConfig.SPEC.isLoaded() && !((Boolean)ClientConfig.EFFECT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (event.getItemStack().m_41619_() || event.getItemStack().getFoodProperties((LivingEntity)ClientProxy.getLocalPlayer()) == null) {
            return;
        }
        for (Component component : event.getToolTip()) {
            TranslatableContents contents;
            MutableComponent mutable;
            ComponentContents componentContents;
            if (!(component instanceof MutableComponent) || !((componentContents = (mutable = (MutableComponent)component).m_214077_()) instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).m_237508_().equals("potion.withDuration")) continue;
            event.getToolTip().remove(component);
            return;
        }
    }

    @SubscribeEvent
    public static void addEffectTooltip(RenderTooltipEvent.GatherComponents event) {
        if (ClientConfig.SPEC.isLoaded() && !((Boolean)ClientConfig.EFFECT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        FoodProperties properties = stack.getFoodProperties((LivingEntity)ClientProxy.getLocalPlayer());
        if (properties == null) {
            return;
        }
        for (Pair possibleEffect : properties.m_38749_()) {
            event.getTooltipElements().add(Either.right((Object)new EffectComponent((Pair<MobEffectInstance, Float>)possibleEffect)));
        }
    }
}

