/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import de.cadentem.quality_food.capability.BlockDataProvider;
import de.cadentem.quality_food.capability.LevelData;
import de.cadentem.quality_food.capability.LevelDataProvider;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.data.QFBlockTags;
import de.cadentem.quality_food.data.QFItemTags;
import de.cadentem.quality_food.network.NetworkHandler;
import de.cadentem.quality_food.network.SyncCookingParticle;
import de.cadentem.quality_food.util.QualityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final ThreadLocal<ItemStack> LAST_STACK = new ThreadLocal();

    public static boolean isValidItem(ItemStack stack) {
        return Utils.isValidItem(stack, true);
    }

    public static boolean isValidItem(ItemStack stack, boolean checkBlock) {
        BlockItem blockItem;
        Item item;
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(QFItemTags.BLACKLIST)) {
            return false;
        }
        FoodProperties properties = stack.getFoodProperties(null);
        if (properties != null && (properties.m_38744_() > 0 || properties.m_38745_() > 0.0f)) {
            return true;
        }
        if (checkBlock && (item = stack.m_41720_()) instanceof BlockItem && Utils.isValidBlock((blockItem = (BlockItem)item).m_40614_())) {
            return true;
        }
        return stack.m_204117_(QFItemTags.MATERIAL_WHITELIST);
    }

    public static boolean isValidBlock(BlockState state) {
        return Utils.isValidBlock(state, true);
    }

    public static boolean isValidBlock(BlockState state, boolean checkItem) {
        if (state.m_204336_(QFBlockTags.QUALITY_BLOCKS)) {
            return true;
        }
        if (checkItem) {
            return Utils.isValidItem(state.m_60734_().m_5456_().m_7968_(), false);
        }
        return false;
    }

    public static boolean isValidBlock(Block block) {
        return Utils.isValidBlock(block, true);
    }

    public static boolean isValidBlock(Block block, boolean checkItem) {
        if (block.m_204297_().m_203656_(QFBlockTags.QUALITY_BLOCKS)) {
            return true;
        }
        if (checkItem) {
            return Utils.isValidItem(block.m_5456_().m_7968_(), false);
        }
        return false;
    }

    public static void sendParticles(ServerLevel serverLevel, BlockEntity blockEntity, BlockPos position) {
        int tickOffset = serverLevel.m_213780_().m_216339_(-3, 3);
        if (serverLevel.m_46467_() % (long)(10 + tickOffset) == 0L) {
            BlockDataProvider.getCapability(blockEntity).ifPresent(data -> {
                double qualityBonus = data.getQuality();
                if (qualityBonus >= 0.1) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (double)64.0, (ResourceKey)serverLevel.m_46472_())), (Object)new SyncCookingParticle(position, qualityBonus));
                }
            });
        }
    }

    public static void incrementQuality(BlockEntity blockEntity, ItemStack stack) {
        Utils.incrementQuality(blockEntity, stack, 1);
    }

    public static void incrementQuality(BlockEntity blockEntity, ItemStack stack, int ingredientCount) {
        if (blockEntity.m_58904_() == null || blockEntity.m_58904_().m_5776_() || ingredientCount < 1) {
            return;
        }
        if (!Utils.isValidItem(stack)) {
            return;
        }
        BlockDataProvider.getCapability(blockEntity).ifPresent(data -> {
            Quality quality = QualityUtils.getQuality(stack);
            data.addQualityType(quality);
            if (quality.level() > 0) {
                data.incrementQuality(QualityUtils.getCookingBonus(stack) / (float)ingredientCount);
            }
        });
        blockEntity.m_6596_();
    }

    public static void storeQuality(BlockState grown, LevelAccessor accessor, BlockPos position, Direction direction) {
        Utils.storeQuality(grown, accessor, position, position.m_121945_(direction), 1.0);
    }

    public static void storeQuality(BlockState grown, LevelAccessor accessor, BlockPos position, BlockPos grownPosition) {
        Utils.storeQuality(grown, accessor, position, grownPosition, 1.0);
    }

    public static void storeQuality(BlockState grown, LevelAccessor accessor, BlockPos position, BlockPos grownPosition, double chance) {
        if (Utils.isValidBlock(grown.m_60734_())) {
            LevelData data = LevelDataProvider.getOrNull(accessor);
            if (data == null) {
                return;
            }
            Quality quality = data.get(position);
            if (Math.random() > chance) {
                quality = Quality.get(quality.ordinal() - 1);
            }
            if (quality.level() > 0) {
                data.set(grownPosition, quality);
            }
        }
    }

    public static void useQuality(BlockEntity block, ItemStack stack, @Nullable Player player) {
        BlockDataProvider.getCapability(block).ifPresent(data -> data.useQuality(stack, player));
        block.m_6596_();
    }
}

