/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.blocks;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xox.labvorty.weaversparadise.blocks.entities.ClothcraftingStationBlockEntity;
import xox.labvorty.weaversparadise.gui.menu.ClothcraftingMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;

public class ClothcraftingStation
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public ClothcraftingStation() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.NORMAL).sound(SoundType.WOOD).strength(1.0f, 10.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ClothcraftingStationBlockEntity) {
            ClothcraftingStationBlockEntity clothcraftingStationBlockEntity = (ClothcraftingStationBlockEntity)blockEntity;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Clothcrafting Station");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new ClothcraftingMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ClothcraftingStationBlockEntity) {
            ClothcraftingStationBlockEntity clothEntity = (ClothcraftingStationBlockEntity)blockEntity;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            clothEntity.setItems(items);
            clothEntity.setGameOn(false);
            clothEntity.setClothType("");
        }
        world.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ClothcraftingStationBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ClothcraftingStationBlockEntity) {
            BlockEntity below;
            ClothcraftingStationBlockEntity clothEntity = (ClothcraftingStationBlockEntity)blockEntity;
            if (clothEntity.getGameOn()) {
                if (clothEntity.getGameTime() > 0) {
                    clothEntity.setGameTime(clothEntity.getGameTime() - 1);
                } else {
                    List<ItemStack> itemStackList = clothEntity.getItemsList();
                    String clothType = clothEntity.getClothType();
                    ItemStack spoolStack = ItemStack.EMPTY;
                    ItemStack stack = ItemStack.EMPTY;
                    int quality = Mth.clamp((int)(clothEntity.getGameScore() / 2), (int)0, (int)10);
                    if (clothType.equals("WOOL")) {
                        spoolStack = new ItemStack((ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get());
                        spoolStack.setCount(6);
                        stack = new ItemStack((ItemLike)WeaversParadiseItems.WOOL_CLOTH.get());
                        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt("quality", quality));
                    } else if (clothType.equals("SILK")) {
                        spoolStack = new ItemStack((ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get());
                        spoolStack.setCount(6);
                        stack = new ItemStack((ItemLike)WeaversParadiseItems.SILK_CLOTH.get());
                        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt("quality", quality));
                    } else if (clothType.equals("COTTON")) {
                        spoolStack = new ItemStack((ItemLike)WeaversParadiseItems.EMPTY_SPOOL.get());
                        spoolStack.setCount(6);
                        stack = new ItemStack((ItemLike)WeaversParadiseItems.COTTON_CLOTH.get());
                        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt("quality", quality));
                    }
                    boolean spoolInjected = false;
                    boolean injected = false;
                    for (ItemStack itemStack : itemStackList) {
                        if (itemStack.getItem().equals(spoolStack.getItem()) && !spoolInjected && itemStack.getCount() <= 58) {
                            itemStack.grow(6);
                            spoolInjected = true;
                        }
                        if (itemStack.getItem().equals(stack.getItem()) && !injected && quality == ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("quality")) {
                            itemStack.grow(1);
                            injected = true;
                        }
                        if (!spoolInjected || !injected) continue;
                        break;
                    }
                    if (!injected) {
                        itemStackList.add(stack);
                    }
                    if (!spoolInjected) {
                        itemStackList.add(spoolStack);
                    }
                    clothEntity.setItems(itemStackList);
                    clothEntity.setGameScore(0);
                    clothEntity.setGameOn(false);
                }
            } else {
                clothEntity.setGameScore(0);
                clothEntity.setGameTime(0);
            }
            if (!world.isClientSide && (below = world.getBlockEntity(pos.below())) instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)below;
                for (int i = 0; i < hopperBlockEntity.getContainerSize(); ++i) {
                    if (!hopperBlockEntity.getItem(i).isEmpty() || hopperBlockEntity.isOnCustomCooldown()) continue;
                    List<ItemStack> items = clothEntity.getItemsList();
                    ItemStack extractStack = ItemStack.EMPTY;
                    for (ItemStack entryStack : items) {
                        if (entryStack.isEmpty()) continue;
                        extractStack = entryStack.copy();
                        extractStack.setCount(1);
                        entryStack.shrink(1);
                        break;
                    }
                    hopperBlockEntity.setItem(i, extractStack);
                    clothEntity.setItems(items);
                }
            }
        }
        world.scheduleTick(pos, (Block)this, 1);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ClothcraftingStationBlockEntity) {
                ClothcraftingStationBlockEntity be = (ClothcraftingStationBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                List<ItemStack> itemStackList = be.getItemsList();
                for (ItemStack stack : itemStackList) {
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                    world.addFreshEntity((Entity)itemEntity);
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof ClothcraftingStationBlockEntity) {
            ClothcraftingStationBlockEntity be = (ClothcraftingStationBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> ClothcraftingStation.box((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
            case Direction.NORTH -> ClothcraftingStation.box((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
            case Direction.EAST -> ClothcraftingStation.box((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
            case Direction.WEST -> ClothcraftingStation.box((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

