/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.blocks.entities;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import xox.labvorty.weaversparadise.gui.menu.ClothcraftingMenu;
import xox.labvorty.weaversparadise.init.WeaversParadiseBlockEntities;

public class ClothcraftingStationBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private int gameTime;
    private int gameScore;
    private boolean isGameOn;
    private List<ItemStack> items;
    private String clothType;

    public ClothcraftingStationBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)WeaversParadiseBlockEntities.CLOTHCRAFTING_STATION_BE.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        if (compound != null) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            int amount = compound.getInt("amountOfItems");
            for (int i = 0; i < amount; ++i) {
                Tag tag = compound.get("item" + i);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)tag;
                    ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)compoundTag).ifPresentOrElse(itemStacks::add, () -> itemStacks.add(ItemStack.EMPTY));
                    continue;
                }
                itemStacks.add(ItemStack.EMPTY);
            }
            this.items = itemStacks;
            this.gameTime = compound.getInt("gameTime");
            this.gameScore = compound.getInt("gameScore");
            this.isGameOn = compound.getBoolean("isGameOn");
            this.clothType = compound.getString("clothType");
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        int amount = 0;
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack item = this.items.get(i);
                if (item.isEmpty()) continue;
                CompoundTag tag = new CompoundTag();
                item.save(lookupProvider, (Tag)tag);
                compound.put("item" + amount, (Tag)tag);
                ++amount;
            }
        }
        compound.putInt("amountOfItems", amount);
        compound.putInt("gameTime", this.gameTime);
        compound.putInt("gameScore", this.gameScore);
        compound.putBoolean("isGameOn", this.isGameOn);
        if (this.clothType != null) {
            compound.putString("clothType", this.clothType);
        }
    }

    public void setGameTime(int time) {
        this.gameTime = time;
        this.setChanged();
    }

    public void setGameScore(int score) {
        this.gameScore = score;
        this.setChanged();
    }

    public void setGameOn(boolean ison) {
        this.isGameOn = ison;
        this.setChanged();
    }

    public void setItems(List<ItemStack> item) {
        this.items = item;
        this.setChanged();
    }

    public void setClothType(String type) {
        this.clothType = type;
        this.setChanged();
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public int getGameScore() {
        return this.gameScore;
    }

    public boolean getGameOn() {
        return this.isGameOn;
    }

    public List<ItemStack> getItemsList() {
        return this.items;
    }

    public String getClothType() {
        return this.clothType;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"clothcrafting_station");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new ClothcraftingMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Clothcrafting Station");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }
}

