/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import xox.labvorty.weaversparadise.curios.WeaversParadiseMobLayers;
import xox.labvorty.weaversparadise.data.WeaversParadiseShirtTextureHandler;
import xox.labvorty.weaversparadise.items.ShirtCotton;
import xox.labvorty.weaversparadise.items.ShirtSilk;
import xox.labvorty.weaversparadise.items.SweaterWool;
import xox.labvorty.weaversparadise.model.ModelUpperWear;
import xox.labvorty.weaversparadise.renderers.WeaversParadiseGlobalRendererDataHolder;
import xox.labvorty.weaversparadise.renderers.WeaversParadiseRenderTypes;

public class ShirtRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ModelUpperWear model;

    public ShirtRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModels) {
        super(dispatcher, entityModels);
        this.model = new ModelUpperWear(entityModels.bakeLayer(WeaversParadiseMobLayers.UPPER_WEAR));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (item instanceof ShirtCotton) {
            ShirtCotton i1 = (ShirtCotton)item;
        } else {
            Item item2 = stack.getItem();
            if (item2 instanceof ShirtSilk) {
                ShirtSilk i2 = (ShirtSilk)item2;
            } else {
                Item item3 = stack.getItem();
                if (item3 instanceof SweaterWool) {
                    SweaterWool i3 = (SweaterWool)item3;
                } else {
                    return;
                }
            }
        }
        float scale = 1.0f;
        double ytranslation = -0.85;
        float additionalXrot = 0.0f;
        float additionalYrot = 0.0f;
        float additionalZrot = 0.0f;
        switch (transformType) {
            case GUI: {
                scale = 0.9f;
                ytranslation = -0.8;
                additionalYrot = 45.0f;
                additionalXrot = 22.5f;
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                scale = 0.5f;
                ytranslation = -0.9;
                break;
            }
            case FIXED: {
                additionalYrot = 180.0f;
                break;
            }
            case GROUND: {
                ytranslation = -0.75;
                scale = 0.5f;
            }
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer entity = mc.player;
        Item item4 = stack.getItem();
        if (item4 instanceof ShirtCotton) {
            int finalBlue;
            int finalRed;
            int bluePulse;
            int finalColor;
            int finalBlue2;
            int finalGreen;
            int finalRed2;
            int blueTwo;
            int greenTwo;
            int redTwo;
            int blueOne;
            int greenOne;
            int redOne;
            int colorTwos;
            int colorOnes;
            int finalColor2;
            int finalBlue3;
            int finalGreen2;
            int finalRed3;
            int blueTwo2;
            int greenTwo2;
            int redTwo2;
            int blueOne2;
            int greenOne2;
            int redOne2;
            int colorTwos2;
            int colorOnes2;
            int height;
            int finalColor3;
            int finalBlue4;
            int finalGreen3;
            int finalRed4;
            int blueTwo3;
            int greenTwo3;
            int redTwo3;
            int blueOne3;
            int greenOne3;
            int redOne3;
            int colorTwos3;
            int colorOnes3;
            Vec3 vec3;
            int color;
            BlockPos bpos;
            ShirtCotton shirtCotton = (ShirtCotton)item4;
            int ticks = (int)mc.level.getGameTime();
            int primaryColorOne = shirtCotton.getItemMainColor(stack, 1);
            int secondaryColorOne = shirtCotton.getItemSecondaryColor(stack, 1);
            int primaryColorTwo = shirtCotton.getItemMainColor(stack, 2);
            int secondaryColorTwo = shirtCotton.getItemSecondaryColor(stack, 2);
            String dyeTypeOne = shirtCotton.getItemDyeType(stack, 1);
            String dyeTypeTwo = shirtCotton.getItemDyeType(stack, 2);
            String stensilType = shirtCotton.getStensilType(stack);
            int lightValueOne = shirtCotton.getItemLightValue(stack, 1);
            int lightValueTwo = shirtCotton.getItemLightValue(stack, 2);
            String renderType = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "cotton").getRenderType();
            ResourceLocation tex1 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "cotton").getTextureOne();
            ResourceLocation tex2 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "cotton").getTextureTwo();
            int redPrimaryOne = primaryColorOne >> 16 & 0xFF;
            int greenPrimaryOne = primaryColorOne >> 8 & 0xFF;
            int bluePrimaryOne = primaryColorOne & 0xFF;
            int redSecondaryOne = secondaryColorOne >> 16 & 0xFF;
            int greenSecondaryOne = secondaryColorOne >> 8 & 0xFF;
            int blueSecondaryOne = secondaryColorOne & 0xFF;
            int redPrimaryTwo = primaryColorTwo >> 16 & 0xFF;
            int greenPrimaryTwo = primaryColorTwo >> 8 & 0xFF;
            int bluePrimaryTwo = primaryColorTwo & 0xFF;
            int redSecondaryTwo = secondaryColorTwo >> 16 & 0xFF;
            int greenSecondaryTwo = secondaryColorTwo >> 8 & 0xFF;
            int blueSecondaryTwo = secondaryColorTwo & 0xFF;
            int finalRedOne = redPrimaryOne;
            int finalGreenOne = greenPrimaryOne;
            int finalBlueOne = bluePrimaryOne;
            int finalRedTwo = redPrimaryTwo;
            int finalGreenTwo = greenPrimaryTwo;
            int finalBlueTwo = bluePrimaryTwo;
            int colorOne = 0xFF000000 | finalRedOne << 16 | finalGreenOne << 8 | finalBlueOne;
            int colorTwo = 0xFF000000 | finalRedTwo << 16 | finalGreenTwo << 8 | finalBlueTwo;
            int lightOne = packedLight;
            int lightTwo = packedLight;
            if (dyeTypeOne.equals("rainbow")) {
                colorOne = this.getRainbowColor(ticks);
            }
            if (dyeTypeTwo.equals("rainbow")) {
                colorTwo = this.getRainbowColor(ticks);
            }
            if (dyeTypeOne.equals("ender")) {
                lightOne = 0;
            }
            if (dyeTypeTwo.equals("ender")) {
                lightTwo = 0;
            }
            if (dyeTypeOne.equals("glowstone")) {
                lightOne = 0xF000F0;
            }
            if (dyeTypeTwo.equals("glowstone")) {
                lightTwo = 0xF000F0;
            }
            if (dyeTypeOne.equals("biome")) {
                bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                colorOne = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
            }
            if (dyeTypeTwo.equals("biome")) {
                bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                colorTwo = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
            }
            if (dyeTypeOne.equals("speed")) {
                vec3 = entity.getDeltaMovement();
                double velocity = vec3.lengthSqr();
                colorOnes3 = primaryColorOne;
                colorTwos3 = secondaryColorOne;
                redOne3 = colorOnes3 >> 16 & 0xFF;
                greenOne3 = colorOnes3 >> 8 & 0xFF;
                blueOne3 = colorOnes3 & 0xFF;
                redTwo3 = colorTwos3 >> 16 & 0xFF;
                greenTwo3 = colorTwos3 >> 8 & 0xFF;
                blueTwo3 = colorTwos3 & 0xFF;
                finalRed4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne3, (int)redTwo3);
                finalGreen3 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne3, (int)greenTwo3);
                finalBlue4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne3, (int)blueTwo3);
                colorOne = finalColor3 = 0xFF000000 | finalRed4 << 16 | finalGreen3 << 8 | finalBlue4;
            }
            if (dyeTypeTwo.equals("speed")) {
                vec3 = entity.getDeltaMovement();
                double velocity = vec3.lengthSqr();
                colorOnes3 = primaryColorTwo;
                colorTwos3 = secondaryColorTwo;
                redOne3 = colorOnes3 >> 16 & 0xFF;
                greenOne3 = colorOnes3 >> 8 & 0xFF;
                blueOne3 = colorOnes3 & 0xFF;
                redTwo3 = colorTwos3 >> 16 & 0xFF;
                greenTwo3 = colorTwos3 >> 8 & 0xFF;
                blueTwo3 = colorTwos3 & 0xFF;
                finalRed4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne3, (int)redTwo3);
                finalGreen3 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne3, (int)greenTwo3);
                finalBlue4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne3, (int)blueTwo3);
                colorTwo = finalColor3 = 0xFF000000 | finalRed4 << 16 | finalGreen3 << 8 | finalBlue4;
            }
            if (dyeTypeOne.equals("height_bedrock")) {
                int absoluteMinimum = mc.level.getMinBuildHeight();
                int absoluteMaximum = mc.level.getMaxBuildHeight();
                height = (int)entity.getY();
                float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                colorOnes2 = primaryColorOne;
                colorTwos2 = secondaryColorOne;
                redOne2 = colorOnes2 >> 16 & 0xFF;
                greenOne2 = colorOnes2 >> 8 & 0xFF;
                blueOne2 = colorOnes2 & 0xFF;
                redTwo2 = colorTwos2 >> 16 & 0xFF;
                greenTwo2 = colorTwos2 >> 8 & 0xFF;
                blueTwo2 = colorTwos2 & 0xFF;
                finalRed3 = Mth.lerpInt((float)value, (int)redOne2, (int)redTwo2);
                finalGreen2 = Mth.lerpInt((float)value, (int)greenOne2, (int)greenTwo2);
                finalBlue3 = Mth.lerpInt((float)value, (int)blueOne2, (int)blueTwo2);
                colorOne = finalColor2 = 0xFF000000 | finalRed3 << 16 | finalGreen2 << 8 | finalBlue3;
            }
            if (dyeTypeTwo.equals("height_bedrock")) {
                int absoluteMinimum = mc.level.getMinBuildHeight();
                int absoluteMaximum = mc.level.getMaxBuildHeight();
                height = (int)entity.getY();
                float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                colorOnes2 = primaryColorTwo;
                colorTwos2 = secondaryColorTwo;
                redOne2 = colorOnes2 >> 16 & 0xFF;
                greenOne2 = colorOnes2 >> 8 & 0xFF;
                blueOne2 = colorOnes2 & 0xFF;
                redTwo2 = colorTwos2 >> 16 & 0xFF;
                greenTwo2 = colorTwos2 >> 8 & 0xFF;
                blueTwo2 = colorTwos2 & 0xFF;
                finalRed3 = Mth.lerpInt((float)value, (int)redOne2, (int)redTwo2);
                finalGreen2 = Mth.lerpInt((float)value, (int)greenOne2, (int)greenTwo2);
                finalBlue3 = Mth.lerpInt((float)value, (int)blueOne2, (int)blueTwo2);
                colorTwo = finalColor2 = 0xFF000000 | finalRed3 << 16 | finalGreen2 << 8 | finalBlue3;
            }
            if (dyeTypeOne.equals("height_sea")) {
                double minY = mc.level.getMinBuildHeight();
                double maxY = mc.level.getMaxBuildHeight();
                double seaY = mc.level.getSeaLevel();
                double playerY = entity.getY();
                double distanceAbove = maxY - seaY;
                double distanceBelow = seaY - minY;
                double maxDistance = Math.max(distanceAbove, distanceBelow);
                float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                colorOnes = primaryColorOne;
                colorTwos = secondaryColorOne;
                redOne = colorOnes >> 16 & 0xFF;
                greenOne = colorOnes >> 8 & 0xFF;
                blueOne = colorOnes & 0xFF;
                redTwo = colorTwos >> 16 & 0xFF;
                greenTwo = colorTwos >> 8 & 0xFF;
                blueTwo = colorTwos & 0xFF;
                finalRed2 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                finalBlue2 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                colorOne = finalColor = 0xFF000000 | finalRed2 << 16 | finalGreen << 8 | finalBlue2;
            }
            if (dyeTypeTwo.equals("height_sea")) {
                double minY = mc.level.getMinBuildHeight();
                double maxY = mc.level.getMaxBuildHeight();
                double seaY = mc.level.getSeaLevel();
                double playerY = entity.getY();
                double distanceAbove = maxY - seaY;
                double distanceBelow = seaY - minY;
                double maxDistance = Math.max(distanceAbove, distanceBelow);
                float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                colorOnes = primaryColorTwo;
                colorTwos = secondaryColorTwo;
                redOne = colorOnes >> 16 & 0xFF;
                greenOne = colorOnes >> 8 & 0xFF;
                blueOne = colorOnes & 0xFF;
                redTwo = colorTwos >> 16 & 0xFF;
                greenTwo = colorTwos >> 8 & 0xFF;
                blueTwo = colorTwos & 0xFF;
                finalRed2 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                finalBlue2 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                colorTwo = finalColor = 0xFF000000 | finalRed2 << 16 | finalGreen << 8 | finalBlue2;
            }
            if (dyeTypeOne.equals("sculk")) {
                int redMain = 5;
                int greenMain = 38;
                int blueMain = 43;
                int redPulse = 0;
                int greenPulse = 255;
                bluePulse = 255;
                int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                int finalGreen4 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                colorOne = 0xFF000000 | finalRed << 16 | finalGreen4 << 8 | finalBlue;
            }
            if (dyeTypeTwo.equals("sculk")) {
                int redMain = 5;
                int greenMain = 38;
                int blueMain = 43;
                int redPulse = 0;
                int greenPulse = 255;
                bluePulse = 255;
                int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                int finalGreen5 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                colorTwo = 0xFF000000 | finalRed << 16 | finalGreen5 << 8 | finalBlue;
            }
            if (dyeTypeOne.equals("lamp")) {
                lightOne = lightValueOne << 20 | lightValueOne << 4;
            }
            if (dyeTypeTwo.equals("lamp")) {
                lightTwo = lightValueTwo << 20 | lightValueTwo << 4;
            }
            poseStack.pushPose();
            poseStack.scale(scale, -scale, scale);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.5 / (double)scale, ytranslation / (double)scale, -0.5 / (double)scale);
            poseStack.mulPose(Axis.XP.rotationDegrees(additionalXrot));
            poseStack.mulPose(Axis.YP.rotationDegrees(additionalYrot));
            poseStack.mulPose(Axis.ZP.rotationDegrees(additionalZrot));
            VertexConsumer vertexConsumerOne = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex1));
            if (dyeTypeOne.equals("ender")) {
                vertexConsumerOne = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex1, TheEndPortalRenderer.END_PORTAL_LOCATION));
            }
            this.model.renderToBuffer(poseStack, vertexConsumerOne, lightOne, OverlayTexture.NO_OVERLAY, colorOne);
            if (renderType.equals("double")) {
                VertexConsumer vertexConsumerTwo = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex2));
                if (dyeTypeTwo.equals("ender")) {
                    vertexConsumerTwo = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex2, TheEndPortalRenderer.END_PORTAL_LOCATION));
                }
                this.model.renderToBuffer(poseStack, vertexConsumerTwo, lightTwo, OverlayTexture.NO_OVERLAY, colorTwo);
            }
            poseStack.popPose();
        } else {
            Item ticks = stack.getItem();
            if (ticks instanceof ShirtSilk) {
                int finalBlue;
                int finalRed;
                int bluePulse;
                int finalColor;
                int finalBlue5;
                int finalGreen;
                int finalRed5;
                int blueTwo;
                int greenTwo;
                int redTwo;
                int blueOne;
                int greenOne;
                int redOne;
                int colorTwos;
                int colorOnes;
                int finalColor4;
                int finalBlue6;
                int finalGreen6;
                int finalRed6;
                int blueTwo4;
                int greenTwo4;
                int redTwo4;
                int blueOne4;
                int greenOne4;
                int redOne4;
                int colorTwos4;
                int colorOnes4;
                int height;
                int finalColor5;
                int finalBlue7;
                int finalGreen7;
                int finalRed7;
                int blueTwo5;
                int greenTwo5;
                int redTwo5;
                int blueOne5;
                int greenOne5;
                int redOne5;
                int colorTwos5;
                int colorOnes5;
                Vec3 vec3;
                int color;
                BlockPos bpos;
                ShirtSilk shirtSilk = (ShirtSilk)ticks;
                int ticks2 = (int)mc.level.getGameTime();
                int primaryColorOne = shirtSilk.getItemMainColor(stack, 1);
                int secondaryColorOne = shirtSilk.getItemSecondaryColor(stack, 1);
                int primaryColorTwo = shirtSilk.getItemMainColor(stack, 2);
                int secondaryColorTwo = shirtSilk.getItemSecondaryColor(stack, 2);
                String dyeTypeOne = shirtSilk.getItemDyeType(stack, 1);
                String dyeTypeTwo = shirtSilk.getItemDyeType(stack, 2);
                String stensilType = shirtSilk.getStensilType(stack);
                int lightValueOne = shirtSilk.getItemLightValue(stack, 1);
                int lightValueTwo = shirtSilk.getItemLightValue(stack, 2);
                String renderType = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getRenderType();
                ResourceLocation tex1 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getTextureOne();
                ResourceLocation tex2 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getTextureTwo();
                int redPrimaryOne = primaryColorOne >> 16 & 0xFF;
                int greenPrimaryOne = primaryColorOne >> 8 & 0xFF;
                int bluePrimaryOne = primaryColorOne & 0xFF;
                int redSecondaryOne = secondaryColorOne >> 16 & 0xFF;
                int greenSecondaryOne = secondaryColorOne >> 8 & 0xFF;
                int blueSecondaryOne = secondaryColorOne & 0xFF;
                int redPrimaryTwo = primaryColorTwo >> 16 & 0xFF;
                int greenPrimaryTwo = primaryColorTwo >> 8 & 0xFF;
                int bluePrimaryTwo = primaryColorTwo & 0xFF;
                int redSecondaryTwo = secondaryColorTwo >> 16 & 0xFF;
                int greenSecondaryTwo = secondaryColorTwo >> 8 & 0xFF;
                int blueSecondaryTwo = secondaryColorTwo & 0xFF;
                int finalRedOne = redPrimaryOne;
                int finalGreenOne = greenPrimaryOne;
                int finalBlueOne = bluePrimaryOne;
                int finalRedTwo = redPrimaryTwo;
                int finalGreenTwo = greenPrimaryTwo;
                int finalBlueTwo = bluePrimaryTwo;
                int colorOne = 0xFF000000 | finalRedOne << 16 | finalGreenOne << 8 | finalBlueOne;
                int colorTwo = 0xFF000000 | finalRedTwo << 16 | finalGreenTwo << 8 | finalBlueTwo;
                int lightOne = packedLight;
                int lightTwo = packedLight;
                if (dyeTypeOne.equals("rainbow")) {
                    colorOne = this.getRainbowColor(ticks2);
                }
                if (dyeTypeTwo.equals("rainbow")) {
                    colorTwo = this.getRainbowColor(ticks2);
                }
                if (dyeTypeOne.equals("ender")) {
                    lightOne = 0;
                }
                if (dyeTypeTwo.equals("ender")) {
                    lightTwo = 0;
                }
                if (dyeTypeOne.equals("glowstone")) {
                    lightOne = 0xF000F0;
                }
                if (dyeTypeTwo.equals("glowstone")) {
                    lightTwo = 0xF000F0;
                }
                if (dyeTypeOne.equals("biome")) {
                    bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                    color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                    colorOne = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                }
                if (dyeTypeTwo.equals("biome")) {
                    bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                    color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                    colorTwo = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                }
                if (dyeTypeOne.equals("speed")) {
                    vec3 = entity.getDeltaMovement();
                    double velocity = vec3.lengthSqr();
                    colorOnes5 = primaryColorOne;
                    colorTwos5 = secondaryColorOne;
                    redOne5 = colorOnes5 >> 16 & 0xFF;
                    greenOne5 = colorOnes5 >> 8 & 0xFF;
                    blueOne5 = colorOnes5 & 0xFF;
                    redTwo5 = colorTwos5 >> 16 & 0xFF;
                    greenTwo5 = colorTwos5 >> 8 & 0xFF;
                    blueTwo5 = colorTwos5 & 0xFF;
                    finalRed7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne5, (int)redTwo5);
                    finalGreen7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne5, (int)greenTwo5);
                    finalBlue7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne5, (int)blueTwo5);
                    colorOne = finalColor5 = 0xFF000000 | finalRed7 << 16 | finalGreen7 << 8 | finalBlue7;
                }
                if (dyeTypeTwo.equals("speed")) {
                    vec3 = entity.getDeltaMovement();
                    double velocity = vec3.lengthSqr();
                    colorOnes5 = primaryColorTwo;
                    colorTwos5 = secondaryColorTwo;
                    redOne5 = colorOnes5 >> 16 & 0xFF;
                    greenOne5 = colorOnes5 >> 8 & 0xFF;
                    blueOne5 = colorOnes5 & 0xFF;
                    redTwo5 = colorTwos5 >> 16 & 0xFF;
                    greenTwo5 = colorTwos5 >> 8 & 0xFF;
                    blueTwo5 = colorTwos5 & 0xFF;
                    finalRed7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne5, (int)redTwo5);
                    finalGreen7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne5, (int)greenTwo5);
                    finalBlue7 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne5, (int)blueTwo5);
                    colorTwo = finalColor5 = 0xFF000000 | finalRed7 << 16 | finalGreen7 << 8 | finalBlue7;
                }
                if (dyeTypeOne.equals("height_bedrock")) {
                    int absoluteMinimum = mc.level.getMinBuildHeight();
                    int absoluteMaximum = mc.level.getMaxBuildHeight();
                    height = (int)entity.getY();
                    float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                    colorOnes4 = primaryColorOne;
                    colorTwos4 = secondaryColorOne;
                    redOne4 = colorOnes4 >> 16 & 0xFF;
                    greenOne4 = colorOnes4 >> 8 & 0xFF;
                    blueOne4 = colorOnes4 & 0xFF;
                    redTwo4 = colorTwos4 >> 16 & 0xFF;
                    greenTwo4 = colorTwos4 >> 8 & 0xFF;
                    blueTwo4 = colorTwos4 & 0xFF;
                    finalRed6 = Mth.lerpInt((float)value, (int)redOne4, (int)redTwo4);
                    finalGreen6 = Mth.lerpInt((float)value, (int)greenOne4, (int)greenTwo4);
                    finalBlue6 = Mth.lerpInt((float)value, (int)blueOne4, (int)blueTwo4);
                    colorOne = finalColor4 = 0xFF000000 | finalRed6 << 16 | finalGreen6 << 8 | finalBlue6;
                }
                if (dyeTypeTwo.equals("height_bedrock")) {
                    int absoluteMinimum = mc.level.getMinBuildHeight();
                    int absoluteMaximum = mc.level.getMaxBuildHeight();
                    height = (int)entity.getY();
                    float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                    colorOnes4 = primaryColorTwo;
                    colorTwos4 = secondaryColorTwo;
                    redOne4 = colorOnes4 >> 16 & 0xFF;
                    greenOne4 = colorOnes4 >> 8 & 0xFF;
                    blueOne4 = colorOnes4 & 0xFF;
                    redTwo4 = colorTwos4 >> 16 & 0xFF;
                    greenTwo4 = colorTwos4 >> 8 & 0xFF;
                    blueTwo4 = colorTwos4 & 0xFF;
                    finalRed6 = Mth.lerpInt((float)value, (int)redOne4, (int)redTwo4);
                    finalGreen6 = Mth.lerpInt((float)value, (int)greenOne4, (int)greenTwo4);
                    finalBlue6 = Mth.lerpInt((float)value, (int)blueOne4, (int)blueTwo4);
                    colorTwo = finalColor4 = 0xFF000000 | finalRed6 << 16 | finalGreen6 << 8 | finalBlue6;
                }
                if (dyeTypeOne.equals("height_sea")) {
                    double minY = mc.level.getMinBuildHeight();
                    double maxY = mc.level.getMaxBuildHeight();
                    double seaY = mc.level.getSeaLevel();
                    double playerY = entity.getY();
                    double distanceAbove = maxY - seaY;
                    double distanceBelow = seaY - minY;
                    double maxDistance = Math.max(distanceAbove, distanceBelow);
                    float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                    colorOnes = primaryColorOne;
                    colorTwos = secondaryColorOne;
                    redOne = colorOnes >> 16 & 0xFF;
                    greenOne = colorOnes >> 8 & 0xFF;
                    blueOne = colorOnes & 0xFF;
                    redTwo = colorTwos >> 16 & 0xFF;
                    greenTwo = colorTwos >> 8 & 0xFF;
                    blueTwo = colorTwos & 0xFF;
                    finalRed5 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    finalBlue5 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    colorOne = finalColor = 0xFF000000 | finalRed5 << 16 | finalGreen << 8 | finalBlue5;
                }
                if (dyeTypeTwo.equals("height_sea")) {
                    double minY = mc.level.getMinBuildHeight();
                    double maxY = mc.level.getMaxBuildHeight();
                    double seaY = mc.level.getSeaLevel();
                    double playerY = entity.getY();
                    double distanceAbove = maxY - seaY;
                    double distanceBelow = seaY - minY;
                    double maxDistance = Math.max(distanceAbove, distanceBelow);
                    float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                    colorOnes = primaryColorTwo;
                    colorTwos = secondaryColorTwo;
                    redOne = colorOnes >> 16 & 0xFF;
                    greenOne = colorOnes >> 8 & 0xFF;
                    blueOne = colorOnes & 0xFF;
                    redTwo = colorTwos >> 16 & 0xFF;
                    greenTwo = colorTwos >> 8 & 0xFF;
                    blueTwo = colorTwos & 0xFF;
                    finalRed5 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    finalBlue5 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    colorTwo = finalColor = 0xFF000000 | finalRed5 << 16 | finalGreen << 8 | finalBlue5;
                }
                if (dyeTypeOne.equals("sculk")) {
                    int redMain = 5;
                    int greenMain = 38;
                    int blueMain = 43;
                    int redPulse = 0;
                    int greenPulse = 255;
                    bluePulse = 255;
                    int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                    finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                    int finalGreen8 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                    finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                    colorOne = 0xFF000000 | finalRed << 16 | finalGreen8 << 8 | finalBlue;
                }
                if (dyeTypeTwo.equals("sculk")) {
                    int redMain = 5;
                    int greenMain = 38;
                    int blueMain = 43;
                    int redPulse = 0;
                    int greenPulse = 255;
                    bluePulse = 255;
                    int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                    finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                    int finalGreen9 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                    finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                    colorTwo = 0xFF000000 | finalRed << 16 | finalGreen9 << 8 | finalBlue;
                }
                if (dyeTypeOne.equals("lamp")) {
                    lightOne = lightValueOne << 20 | lightValueOne << 4;
                }
                if (dyeTypeTwo.equals("lamp")) {
                    lightTwo = lightValueTwo << 20 | lightValueTwo << 4;
                }
                poseStack.pushPose();
                poseStack.scale(scale, -scale, scale);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.translate(-0.5 / (double)scale, ytranslation / (double)scale, -0.5 / (double)scale);
                poseStack.mulPose(Axis.XP.rotationDegrees(additionalXrot));
                poseStack.mulPose(Axis.YP.rotationDegrees(additionalYrot));
                poseStack.mulPose(Axis.ZP.rotationDegrees(additionalZrot));
                VertexConsumer vertexConsumerOne = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex1));
                if (dyeTypeOne.equals("ender")) {
                    vertexConsumerOne = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex1, TheEndPortalRenderer.END_PORTAL_LOCATION));
                }
                this.model.renderToBuffer(poseStack, vertexConsumerOne, lightOne, OverlayTexture.NO_OVERLAY, colorOne);
                if (renderType.equals("double")) {
                    VertexConsumer vertexConsumerTwo = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex2));
                    if (dyeTypeTwo.equals("ender")) {
                        vertexConsumerTwo = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex2, TheEndPortalRenderer.END_PORTAL_LOCATION));
                    }
                    this.model.renderToBuffer(poseStack, vertexConsumerTwo, lightTwo, OverlayTexture.NO_OVERLAY, colorTwo);
                }
                poseStack.popPose();
            } else {
                ticks = stack.getItem();
                if (ticks instanceof SweaterWool) {
                    int finalBlue;
                    int finalRed;
                    int bluePulse;
                    int finalColor;
                    int finalBlue8;
                    int finalGreen;
                    int finalRed8;
                    int blueTwo;
                    int greenTwo;
                    int redTwo;
                    int blueOne;
                    int greenOne;
                    int redOne;
                    int colorTwos;
                    int colorOnes;
                    int finalColor6;
                    int finalBlue9;
                    int finalGreen10;
                    int finalRed9;
                    int blueTwo6;
                    int greenTwo6;
                    int redTwo6;
                    int blueOne6;
                    int greenOne6;
                    int redOne6;
                    int colorTwos6;
                    int colorOnes6;
                    int height;
                    int finalColor7;
                    int finalBlue10;
                    int finalGreen11;
                    int finalRed10;
                    int blueTwo7;
                    int greenTwo7;
                    int redTwo7;
                    int blueOne7;
                    int greenOne7;
                    int redOne7;
                    int colorTwos7;
                    int colorOnes7;
                    Vec3 vec3;
                    int color;
                    BlockPos bpos;
                    SweaterWool sweaterWool = (SweaterWool)ticks;
                    int ticks3 = (int)mc.level.getGameTime();
                    int primaryColorOne = sweaterWool.getItemMainColor(stack, 1);
                    int secondaryColorOne = sweaterWool.getItemSecondaryColor(stack, 1);
                    int primaryColorTwo = sweaterWool.getItemMainColor(stack, 2);
                    int secondaryColorTwo = sweaterWool.getItemSecondaryColor(stack, 2);
                    String dyeTypeOne = sweaterWool.getItemDyeType(stack, 1);
                    String dyeTypeTwo = sweaterWool.getItemDyeType(stack, 2);
                    String stensilType = sweaterWool.getStensilType(stack);
                    int lightValueOne = sweaterWool.getItemLightValue(stack, 1);
                    int lightValueTwo = sweaterWool.getItemLightValue(stack, 2);
                    String renderType = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "wool").getRenderType();
                    ResourceLocation tex1 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "wool").getTextureOne();
                    ResourceLocation tex2 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "wool").getTextureTwo();
                    int redPrimaryOne = primaryColorOne >> 16 & 0xFF;
                    int greenPrimaryOne = primaryColorOne >> 8 & 0xFF;
                    int bluePrimaryOne = primaryColorOne & 0xFF;
                    int redSecondaryOne = secondaryColorOne >> 16 & 0xFF;
                    int greenSecondaryOne = secondaryColorOne >> 8 & 0xFF;
                    int blueSecondaryOne = secondaryColorOne & 0xFF;
                    int redPrimaryTwo = primaryColorTwo >> 16 & 0xFF;
                    int greenPrimaryTwo = primaryColorTwo >> 8 & 0xFF;
                    int bluePrimaryTwo = primaryColorTwo & 0xFF;
                    int redSecondaryTwo = secondaryColorTwo >> 16 & 0xFF;
                    int greenSecondaryTwo = secondaryColorTwo >> 8 & 0xFF;
                    int blueSecondaryTwo = secondaryColorTwo & 0xFF;
                    int finalRedOne = redPrimaryOne;
                    int finalGreenOne = greenPrimaryOne;
                    int finalBlueOne = bluePrimaryOne;
                    int finalRedTwo = redPrimaryTwo;
                    int finalGreenTwo = greenPrimaryTwo;
                    int finalBlueTwo = bluePrimaryTwo;
                    int colorOne = 0xFF000000 | finalRedOne << 16 | finalGreenOne << 8 | finalBlueOne;
                    int colorTwo = 0xFF000000 | finalRedTwo << 16 | finalGreenTwo << 8 | finalBlueTwo;
                    int lightOne = packedLight;
                    int lightTwo = packedLight;
                    if (dyeTypeOne.equals("rainbow")) {
                        colorOne = this.getRainbowColor(ticks3);
                    }
                    if (dyeTypeTwo.equals("rainbow")) {
                        colorTwo = this.getRainbowColor(ticks3);
                    }
                    if (dyeTypeOne.equals("ender")) {
                        lightOne = 0;
                    }
                    if (dyeTypeTwo.equals("ender")) {
                        lightTwo = 0;
                    }
                    if (dyeTypeOne.equals("glowstone")) {
                        lightOne = 0xF000F0;
                    }
                    if (dyeTypeTwo.equals("glowstone")) {
                        lightTwo = 0xF000F0;
                    }
                    if (dyeTypeOne.equals("biome")) {
                        bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                        color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                        colorOne = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                    }
                    if (dyeTypeTwo.equals("biome")) {
                        bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                        color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                        colorTwo = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                    }
                    if (dyeTypeOne.equals("speed")) {
                        vec3 = entity.getDeltaMovement();
                        double velocity = vec3.lengthSqr();
                        colorOnes7 = primaryColorOne;
                        colorTwos7 = secondaryColorOne;
                        redOne7 = colorOnes7 >> 16 & 0xFF;
                        greenOne7 = colorOnes7 >> 8 & 0xFF;
                        blueOne7 = colorOnes7 & 0xFF;
                        redTwo7 = colorTwos7 >> 16 & 0xFF;
                        greenTwo7 = colorTwos7 >> 8 & 0xFF;
                        blueTwo7 = colorTwos7 & 0xFF;
                        finalRed10 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne7, (int)redTwo7);
                        finalGreen11 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne7, (int)greenTwo7);
                        finalBlue10 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne7, (int)blueTwo7);
                        colorOne = finalColor7 = 0xFF000000 | finalRed10 << 16 | finalGreen11 << 8 | finalBlue10;
                    }
                    if (dyeTypeTwo.equals("speed")) {
                        vec3 = entity.getDeltaMovement();
                        double velocity = vec3.lengthSqr();
                        colorOnes7 = primaryColorTwo;
                        colorTwos7 = secondaryColorTwo;
                        redOne7 = colorOnes7 >> 16 & 0xFF;
                        greenOne7 = colorOnes7 >> 8 & 0xFF;
                        blueOne7 = colorOnes7 & 0xFF;
                        redTwo7 = colorTwos7 >> 16 & 0xFF;
                        greenTwo7 = colorTwos7 >> 8 & 0xFF;
                        blueTwo7 = colorTwos7 & 0xFF;
                        finalRed10 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne7, (int)redTwo7);
                        finalGreen11 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne7, (int)greenTwo7);
                        finalBlue10 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne7, (int)blueTwo7);
                        colorTwo = finalColor7 = 0xFF000000 | finalRed10 << 16 | finalGreen11 << 8 | finalBlue10;
                    }
                    if (dyeTypeOne.equals("height_bedrock")) {
                        int absoluteMinimum = mc.level.getMinBuildHeight();
                        int absoluteMaximum = mc.level.getMaxBuildHeight();
                        height = (int)entity.getY();
                        float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                        colorOnes6 = primaryColorOne;
                        colorTwos6 = secondaryColorOne;
                        redOne6 = colorOnes6 >> 16 & 0xFF;
                        greenOne6 = colorOnes6 >> 8 & 0xFF;
                        blueOne6 = colorOnes6 & 0xFF;
                        redTwo6 = colorTwos6 >> 16 & 0xFF;
                        greenTwo6 = colorTwos6 >> 8 & 0xFF;
                        blueTwo6 = colorTwos6 & 0xFF;
                        finalRed9 = Mth.lerpInt((float)value, (int)redOne6, (int)redTwo6);
                        finalGreen10 = Mth.lerpInt((float)value, (int)greenOne6, (int)greenTwo6);
                        finalBlue9 = Mth.lerpInt((float)value, (int)blueOne6, (int)blueTwo6);
                        colorOne = finalColor6 = 0xFF000000 | finalRed9 << 16 | finalGreen10 << 8 | finalBlue9;
                    }
                    if (dyeTypeTwo.equals("height_bedrock")) {
                        int absoluteMinimum = mc.level.getMinBuildHeight();
                        int absoluteMaximum = mc.level.getMaxBuildHeight();
                        height = (int)entity.getY();
                        float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                        colorOnes6 = primaryColorTwo;
                        colorTwos6 = secondaryColorTwo;
                        redOne6 = colorOnes6 >> 16 & 0xFF;
                        greenOne6 = colorOnes6 >> 8 & 0xFF;
                        blueOne6 = colorOnes6 & 0xFF;
                        redTwo6 = colorTwos6 >> 16 & 0xFF;
                        greenTwo6 = colorTwos6 >> 8 & 0xFF;
                        blueTwo6 = colorTwos6 & 0xFF;
                        finalRed9 = Mth.lerpInt((float)value, (int)redOne6, (int)redTwo6);
                        finalGreen10 = Mth.lerpInt((float)value, (int)greenOne6, (int)greenTwo6);
                        finalBlue9 = Mth.lerpInt((float)value, (int)blueOne6, (int)blueTwo6);
                        colorTwo = finalColor6 = 0xFF000000 | finalRed9 << 16 | finalGreen10 << 8 | finalBlue9;
                    }
                    if (dyeTypeOne.equals("height_sea")) {
                        double minY = mc.level.getMinBuildHeight();
                        double maxY = mc.level.getMaxBuildHeight();
                        double seaY = mc.level.getSeaLevel();
                        double playerY = entity.getY();
                        double distanceAbove = maxY - seaY;
                        double distanceBelow = seaY - minY;
                        double maxDistance = Math.max(distanceAbove, distanceBelow);
                        float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                        colorOnes = primaryColorOne;
                        colorTwos = secondaryColorOne;
                        redOne = colorOnes >> 16 & 0xFF;
                        greenOne = colorOnes >> 8 & 0xFF;
                        blueOne = colorOnes & 0xFF;
                        redTwo = colorTwos >> 16 & 0xFF;
                        greenTwo = colorTwos >> 8 & 0xFF;
                        blueTwo = colorTwos & 0xFF;
                        finalRed8 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                        finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                        finalBlue8 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                        colorOne = finalColor = 0xFF000000 | finalRed8 << 16 | finalGreen << 8 | finalBlue8;
                    }
                    if (dyeTypeTwo.equals("height_sea")) {
                        double minY = mc.level.getMinBuildHeight();
                        double maxY = mc.level.getMaxBuildHeight();
                        double seaY = mc.level.getSeaLevel();
                        double playerY = entity.getY();
                        double distanceAbove = maxY - seaY;
                        double distanceBelow = seaY - minY;
                        double maxDistance = Math.max(distanceAbove, distanceBelow);
                        float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                        colorOnes = primaryColorTwo;
                        colorTwos = secondaryColorTwo;
                        redOne = colorOnes >> 16 & 0xFF;
                        greenOne = colorOnes >> 8 & 0xFF;
                        blueOne = colorOnes & 0xFF;
                        redTwo = colorTwos >> 16 & 0xFF;
                        greenTwo = colorTwos >> 8 & 0xFF;
                        blueTwo = colorTwos & 0xFF;
                        finalRed8 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                        finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                        finalBlue8 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                        colorTwo = finalColor = 0xFF000000 | finalRed8 << 16 | finalGreen << 8 | finalBlue8;
                    }
                    if (dyeTypeOne.equals("sculk")) {
                        int redMain = 5;
                        int greenMain = 38;
                        int blueMain = 43;
                        int redPulse = 0;
                        int greenPulse = 255;
                        bluePulse = 255;
                        int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                        finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                        int finalGreen12 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                        finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                        colorOne = 0xFF000000 | finalRed << 16 | finalGreen12 << 8 | finalBlue;
                    }
                    if (dyeTypeTwo.equals("sculk")) {
                        int redMain = 5;
                        int greenMain = 38;
                        int blueMain = 43;
                        int redPulse = 0;
                        int greenPulse = 255;
                        bluePulse = 255;
                        int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                        finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                        int finalGreen13 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                        finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                        colorTwo = 0xFF000000 | finalRed << 16 | finalGreen13 << 8 | finalBlue;
                    }
                    if (dyeTypeOne.equals("lamp")) {
                        lightOne = lightValueOne << 20 | lightValueOne << 4;
                    }
                    if (dyeTypeTwo.equals("lamp")) {
                        lightTwo = lightValueTwo << 20 | lightValueTwo << 4;
                    }
                    poseStack.pushPose();
                    poseStack.scale(scale, -scale, scale);
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    poseStack.translate(-0.5 / (double)scale, ytranslation / (double)scale, -0.5 / (double)scale);
                    poseStack.mulPose(Axis.XP.rotationDegrees(additionalXrot));
                    poseStack.mulPose(Axis.YP.rotationDegrees(additionalYrot));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(additionalZrot));
                    VertexConsumer vertexConsumerOne = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex1));
                    if (dyeTypeOne.equals("ender")) {
                        vertexConsumerOne = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex1, TheEndPortalRenderer.END_PORTAL_LOCATION));
                    }
                    this.model.renderToBuffer(poseStack, vertexConsumerOne, lightOne, OverlayTexture.NO_OVERLAY, colorOne);
                    if (renderType.equals("double")) {
                        VertexConsumer vertexConsumerTwo = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex2));
                        if (dyeTypeTwo.equals("ender")) {
                            vertexConsumerTwo = buffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex2, TheEndPortalRenderer.END_PORTAL_LOCATION));
                        }
                        this.model.renderToBuffer(poseStack, vertexConsumerTwo, lightTwo, OverlayTexture.NO_OVERLAY, colorTwo);
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    public int getRainbowColor(int ticks) {
        float speed = 0.05f;
        float red = Mth.clamp((float)((float)(Math.sin((float)ticks * speed) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float green = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 2.0943951023931953) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float blue = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 4.1887902047863905) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        int truered = (int)(red * 255.0f);
        int truegreen = (int)(green * 255.0f);
        int trueblue = (int)(blue * 255.0f);
        return 0xFF000000 | truered << 16 | truegreen << 8 | trueblue;
    }
}

