/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import xox.labvorty.weaversparadise.data.HandWarmersRenderer;
import xox.labvorty.weaversparadise.data.WeaversParadiseDyeIconHandler;
import xox.labvorty.weaversparadise.data.WeaversParadiseStatHandler;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.tooltips.ImageTooltipComponent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class HandWarmersSilk
extends Item
implements ICurioItem {
    public HandWarmersSilk() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON).durability(1).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag(){
            {
                this.putInt("quality", 0);
                this.putString("dyeTypeLeftOne", "default");
                this.putString("dyeTypeRightOne", "default");
                this.putString("dyeTypeLeftTwo", "default");
                this.putString("dyeTypeRightTwo", "default");
                this.putString("stensilTypeLeft", "default");
                this.putString("stensilTypeRight", "default");
                this.putInt("colorPriRedLeftOne", 255);
                this.putInt("colorPriGreenLeftOne", 255);
                this.putInt("colorPriBlueLeftOne", 255);
                this.putInt("colorPriRedLeftTwo", 255);
                this.putInt("colorPriGreenLeftTwo", 255);
                this.putInt("colorPriBlueLeftTwo", 255);
                this.putInt("colorSecRedLeftOne", 255);
                this.putInt("colorSecGreenLeftOne", 255);
                this.putInt("colorSecBlueLeftOne", 255);
                this.putInt("colorSecRedLeftTwo", 255);
                this.putInt("colorSecGreenLeftTwo", 255);
                this.putInt("colorSecBlueLeftTwo", 255);
                this.putInt("colorPriRedRightOne", 255);
                this.putInt("colorPriGreenRightOne", 255);
                this.putInt("colorPriBlueRightOne", 255);
                this.putInt("colorPriRedRightTwo", 255);
                this.putInt("colorPriGreenRightTwo", 255);
                this.putInt("colorPriBlueRightTwo", 255);
                this.putInt("colorSecRedRightOne", 255);
                this.putInt("colorSecGreenRightOne", 255);
                this.putInt("colorSecBlueRightOne", 255);
                this.putInt("colorSecRedRightTwo", 255);
                this.putInt("colorSecGreenRightTwo", 255);
                this.putInt("colorSecBlueRightTwo", 255);
                this.putInt("lightValueLeftOne", 15);
                this.putInt("lightValueLeftTwo", 15);
                this.putInt("lightValueRightOne", 15);
                this.putInt("lightValueRightTwo", 15);
            }
        })));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        LivingEntity entity = slotContext.entity();
        Pair<String, Double> stat = WeaversParadiseStatHandler.calculateStaticType(entity);
        if (((String)stat.getFirst()).equals("silk")) {
            modifiers.put((Object)Attributes.SUBMERGED_MINING_SPEED, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"hand_warmers_silk"), (Double)stat.getSecond() * 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        return modifiers;
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new HandWarmersRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
            }
        }, new Item[]{(Item)WeaversParadiseItems.HAND_WARMERS_SILK.get()});
    }

    public int getMaxDamage(ItemStack stack) {
        int quality = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("quality");
        int maxdamage = 100 + 20 * quality;
        return maxdamage;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        CompoundTag data = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (data.getInt("quality") >= 2) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 1) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 4) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 3) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 6) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 5) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 8) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 7) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 10) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 9) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        return Optional.of(new ImageTooltipComponent(list, WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, "left", 1)).getTexture(), this.getItemDyeType(stack, "left", 1), this.getItemDyeType(stack, "left", 1), this.getItemLightValue(stack, "left", 1), this.getItemMainColor(stack, "left", 1), this.getItemSecondaryColor(stack, "left", 1), WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, "left", 2)).getTexture(), this.getItemDyeType(stack, "left", 2), this.getItemDyeType(stack, "left", 2), this.getItemLightValue(stack, "left", 2), this.getItemMainColor(stack, "left", 2), this.getItemSecondaryColor(stack, "left", 2), WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, "right", 1)).getTexture(), this.getItemDyeType(stack, "right", 1), this.getItemDyeType(stack, "right", 1), this.getItemLightValue(stack, "right", 1), this.getItemMainColor(stack, "right", 1), this.getItemSecondaryColor(stack, "right", 1), WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, "right", 2)).getTexture(), this.getItemDyeType(stack, "right", 2), this.getItemDyeType(stack, "right", 2), this.getItemLightValue(stack, "right", 2), this.getItemMainColor(stack, "right", 2), this.getItemSecondaryColor(stack, "right", 2)));
    }

    public int getItemMainColor(ItemStack stack, String side, int part) {
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (side.equals("left")) {
            int blue;
            int green;
            int red;
            if (part == 1) {
                red = tag.getInt("colorPriRedLeftOne");
                green = tag.getInt("colorPriGreenLeftOne");
                blue = tag.getInt("colorPriBlueLeftOne");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (part == 2) {
                red = tag.getInt("colorPriRedLeftTwo");
                green = tag.getInt("colorPriGreenLeftTwo");
                blue = tag.getInt("colorPriBlueLeftTwo");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        } else if (side.equals("right")) {
            int blue;
            int green;
            int red;
            if (part == 1) {
                red = tag.getInt("colorPriRedRightOne");
                green = tag.getInt("colorPriGreenRightOne");
                blue = tag.getInt("colorPriBlueRightOne");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (part == 2) {
                red = tag.getInt("colorPriRedRightTwo");
                green = tag.getInt("colorPriGreenRightTwo");
                blue = tag.getInt("colorPriBlueRightTwo");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        }
        return color;
    }

    public int getItemSecondaryColor(ItemStack stack, String side, int part) {
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (side.equals("left")) {
            int blue;
            int green;
            int red;
            if (part == 1) {
                red = tag.getInt("colorSecRedLeftOne");
                green = tag.getInt("colorSecGreenLeftOne");
                blue = tag.getInt("colorSecBlueLeftOne");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (part == 2) {
                red = tag.getInt("colorSecRedLeftTwo");
                green = tag.getInt("colorSecGreenLeftTwo");
                blue = tag.getInt("colorSecBlueLeftTwo");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        } else if (side.equals("right")) {
            int blue;
            int green;
            int red;
            if (part == 1) {
                red = tag.getInt("colorSecRedRightOne");
                green = tag.getInt("colorSecGreenRightOne");
                blue = tag.getInt("colorSecBlueRightOne");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (part == 2) {
                red = tag.getInt("colorSecRedRightTwo");
                green = tag.getInt("colorSecGreenRightTwo");
                blue = tag.getInt("colorSecBlueRightTwo");
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            }
        }
        return color;
    }

    public String getItemDyeType(ItemStack stack, String side, int part) {
        String type = "default";
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (side.equals("left")) {
            if (part == 1) {
                type = tag.getString("dyeTypeLeftOne");
            }
            if (part == 2) {
                type = tag.getString("dyeTypeLeftTwo");
            }
        } else if (side.equals("right")) {
            if (part == 1) {
                type = tag.getString("dyeTypeRightOne");
            }
            if (part == 2) {
                type = tag.getString("dyeTypeRightTwo");
            }
        }
        return type;
    }

    public int getItemLightValue(ItemStack stack, String side, int part) {
        int light = 15;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (side.equals("left")) {
            if (part == 1) {
                light = tag.getInt("lightValueLeftOne");
            }
            if (part == 2) {
                light = tag.getInt("lightValueLeftTwo");
            }
        } else if (side.equals("right")) {
            if (part == 1) {
                light = tag.getInt("lightValueRightOne");
            }
            if (part == 2) {
                light = tag.getInt("lightValueRightTwo");
            }
        }
        return light;
    }

    public String getStensilType(ItemStack stack, String side) {
        String type = "default";
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (side.equals("left")) {
            type = tag.getString("stensilTypeLeft");
        } else if (side.equals("right")) {
            type = tag.getString("stensilTypeRight");
        }
        return type;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        CompoundTag stackdata = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag candidatedata = ((CustomData)repairCandidate.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int stackquality = stackdata.getInt("quality");
        int candidatequality = candidatedata.getInt("quality");
        return repairCandidate.is(WeaversParadiseItems.COTTON_CLOTH) && candidatequality >= stackquality;
    }
}

