/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;

public class PureDyeItem
extends Item {
    public PureDyeItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.COMMON).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag(){
            {
                this.putInt("red", 0);
                this.putInt("green", 0);
                this.putInt("blue", 0);
            }
        })));
    }

    public int getDyeColor(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return 0xFF000000 | tag.getInt("red") << 16 | tag.getInt("green") << 8 | tag.getInt("blue");
    }

    public int getRed(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.getInt("red");
    }

    public int getGreen(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.getInt("green");
    }

    public int getBlue(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.getInt("blue");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)Component.literal((String)("Red: " + this.getRed(stack))).withColor(ChatFormatting.GRAY.getColor().intValue()));
            tooltipComponents.add((Component)Component.literal((String)("Green: " + this.getGreen(stack))).withColor(ChatFormatting.GRAY.getColor().intValue()));
            tooltipComponents.add((Component)Component.literal((String)("Blue: " + this.getBlue(stack))).withColor(ChatFormatting.GRAY.getColor().intValue()));
        }
    }
}

