/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.items;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import xox.labvorty.weaversparadise.data.ShirtRenderer;
import xox.labvorty.weaversparadise.data.WeaversParadiseDyeIconHandler;
import xox.labvorty.weaversparadise.data.WeaversParadiseStatHandler;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.tooltips.ImageTooltipComponent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ShirtCotton
extends Item
implements ICurioItem {
    public ShirtCotton() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON).durability(1).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag(){
            {
                this.putInt("quality", 0);
                this.putString("dyeTypeOne", "default");
                this.putString("dyeTypeTwo", "default");
                this.putString("stensilType", "default");
                this.putInt("colorPriRedOne", 255);
                this.putInt("colorPriGreenOne", 255);
                this.putInt("colorPriBlueOne", 255);
                this.putInt("colorPriRedTwo", 255);
                this.putInt("colorPriGreenTwo", 255);
                this.putInt("colorPriBlueTwo", 255);
                this.putInt("colorSecRedOne", 255);
                this.putInt("colorSecGreenOne", 255);
                this.putInt("colorSecBlueOne", 255);
                this.putInt("colorSecRedTwo", 255);
                this.putInt("colorSecGreenTwo", 255);
                this.putInt("colorSecBlueTwo", 255);
                this.putInt("lightValueOne", 15);
                this.putInt("lightValueTwo", 15);
            }
        })));
    }

    public int getMaxDamage(ItemStack stack) {
        int quality = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("quality");
        int maxdamage = 100 + 20 * quality;
        return maxdamage;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        LivingEntity entity = slotContext.entity();
        Pair<String, Double> stat = WeaversParadiseStatHandler.calculateStaticType(entity);
        if (((String)stat.getFirst()).equals("cotton")) {
            modifiers.put((Object)Attributes.SWEEPING_DAMAGE_RATIO, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"shirt_cotton"), (Double)stat.getSecond() * 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            modifiers.put((Object)Attributes.BURNING_TIME, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"shirt_cotton"), (Double)stat.getSecond() * 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        return modifiers;
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ShirtRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
            }
        }, new Item[]{(Item)WeaversParadiseItems.SHIRT_COTTON.get()});
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        CompoundTag data = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (data.getInt("quality") >= 2) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 1) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 4) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 3) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 6) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 5) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 8) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 7) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        if (data.getInt("quality") >= 10) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_full.png"));
        } else if (data.getInt("quality") == 9) {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_half.png"));
        } else {
            list.add(ResourceLocation.parse((String)"weaversparadise:textures/tooltips/star_empty.png"));
        }
        return Optional.of(new ImageTooltipComponent(list, WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, 1)).getTexture(), this.getItemDyeType(stack, 1), this.getItemDyeType(stack, 1), this.getItemLightValue(stack, 1), this.getItemMainColor(stack, 1), this.getItemSecondaryColor(stack, 1), WeaversParadiseDyeIconHandler.getOrDefault(this.getItemDyeType(stack, 2)).getTexture(), this.getItemDyeType(stack, 2), this.getItemDyeType(stack, 2), this.getItemLightValue(stack, 2), this.getItemMainColor(stack, 2), this.getItemSecondaryColor(stack, 2), WeaversParadiseDyeIconHandler.getOrDefault("none").getTexture(), "", "none", 15, -1, -1, WeaversParadiseDyeIconHandler.getOrDefault("none").getTexture(), "", "none", 15, -1, -1));
    }

    public int getItemMainColor(ItemStack stack, int part) {
        int blue;
        int green;
        int red;
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (part == 1) {
            red = tag.getInt("colorPriRedOne");
            green = tag.getInt("colorPriGreenOne");
            blue = tag.getInt("colorPriBlueOne");
            color = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        if (part == 2) {
            red = tag.getInt("colorPriRedTwo");
            green = tag.getInt("colorPriGreenTwo");
            blue = tag.getInt("colorPriBlueTwo");
            color = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return color;
    }

    public int getItemSecondaryColor(ItemStack stack, int part) {
        int blue;
        int green;
        int red;
        int color = 0;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (part == 1) {
            red = tag.getInt("colorSecRedOne");
            green = tag.getInt("colorSecGreenOne");
            blue = tag.getInt("colorSecBlueOne");
            color = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        if (part == 2) {
            red = tag.getInt("colorSecRedTwo");
            green = tag.getInt("colorSecGreenTwo");
            blue = tag.getInt("colorSecBlueTwo");
            color = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return color;
    }

    public String getItemDyeType(ItemStack stack, int part) {
        String type = "default";
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (part == 1) {
            type = tag.getString("dyeTypeOne");
        }
        if (part == 2) {
            type = tag.getString("dyeTypeTwo");
        }
        return type;
    }

    public int getItemLightValue(ItemStack stack, int part) {
        int light = 15;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (part == 1) {
            light = tag.getInt("lightValueOne");
        }
        if (part == 2) {
            light = tag.getInt("lightValueTwo");
        }
        return light;
    }

    public String getStensilType(ItemStack stack) {
        String type = "default";
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        type = tag.getString("stensilType");
        return type;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        CompoundTag stackdata = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag candidatedata = ((CustomData)repairCandidate.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int stackquality = stackdata.getInt("quality");
        int candidatequality = candidatedata.getInt("quality");
        return repairCandidate.is(WeaversParadiseItems.COTTON_CLOTH) && candidatequality >= stackquality;
    }
}

