/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.mixins;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import xox.labvorty.weaversparadise.data.WeaversParadiseStatHandler;
import xox.labvorty.weaversparadise.items.ThighHighsSilk;

@Mixin(value={LivingEntity.class})
public class PlayerMixin {
    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanStandOnFluid(FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof Player) {
            Player player = (Player)playerMixin;
            Optional handler = CuriosApi.getCuriosInventory((LivingEntity)player);
            BlockPos bPos = BlockPos.containing((Position)player.position());
            BlockState bState = player.level().getBlockState(bPos);
            double fluidHeight = 0.0;
            Pair<String, Double> ability = WeaversParadiseStatHandler.calculateStaticType((LivingEntity)player);
            if (!bState.getFluidState().isEmpty()) {
                fluidHeight = player.getFluidTypeHeight(player.level().getFluidState(bPos).getFluidType());
            }
            if (handler.isPresent() && fluidHeight < 0.4 && ((String)ability.getFirst()).equals("silk") && (Double)ability.getSecond() > 0.0 && ((ICuriosItemHandler)handler.get()).isEquipped(stack -> {
                Item patt0$temp = stack.getItem();
                if (patt0$temp instanceof ThighHighsSilk) {
                    ThighHighsSilk thighHighsSilk = (ThighHighsSilk)patt0$temp;
                    return true;
                }
                return false;
            })) {
                cir.setReturnValue((Object)(!fluidState.is((Fluid)Fluids.LAVA) && !fluidState.is((Fluid)Fluids.FLOWING_LAVA) ? 1 : 0));
            }
        }
    }
}

