/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.renderers.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import xox.labvorty.weaversparadise.curios.WeaversParadiseMobLayers;
import xox.labvorty.weaversparadise.data.WeaversParadiseShirtTextureHandler;
import xox.labvorty.weaversparadise.init.WeaversParadiseItems;
import xox.labvorty.weaversparadise.items.ShirtSilk;
import xox.labvorty.weaversparadise.model.ModelUpperWear;
import xox.labvorty.weaversparadise.renderers.WeaversParadiseGlobalRendererDataHolder;
import xox.labvorty.weaversparadise.renderers.WeaversParadiseRenderTypes;

public class ShirtSilkRenderer
implements ICurioRenderer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"weaversparadise", (String)"textures/clothing/shirt_silk.png");
    public static ModelUpperWear model;

    public ShirtSilkRenderer() {
        model = new ModelUpperWear(Minecraft.getInstance().getEntityModels().bakeLayer(WeaversParadiseMobLayers.UPPER_WEAR));
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        Item item = stack.getItem();
        if (item instanceof ShirtSilk) {
            ShirtSilk shirtSilk = (ShirtSilk)item;
            if (!entity.getItemBySlot(EquipmentSlot.BODY).is(WeaversParadiseItems.ASTOLFO_ARMOR_CHESTPLATE)) {
                int finalBlue;
                int finalRed;
                int bluePulse;
                int finalColor;
                int finalBlue2;
                int finalGreen;
                int finalRed2;
                int blueTwo;
                int greenTwo;
                int redTwo;
                int blueOne;
                int greenOne;
                int redOne;
                int colorTwos;
                int colorOnes;
                int finalColor2;
                int finalBlue3;
                int finalGreen2;
                int finalRed3;
                int blueTwo2;
                int greenTwo2;
                int redTwo2;
                int blueOne2;
                int greenOne2;
                int redOne2;
                int colorTwos2;
                int colorOnes2;
                int height;
                int finalColor3;
                int finalBlue4;
                int finalGreen3;
                int finalRed4;
                int blueTwo3;
                int greenTwo3;
                int redTwo3;
                int blueOne3;
                int greenOne3;
                int redOne3;
                int colorTwos3;
                int colorOnes3;
                Vec3 vec3;
                int color;
                BlockPos bpos;
                Minecraft mc = Minecraft.getInstance();
                int ticks = (int)mc.level.getGameTime();
                int primaryColorOne = shirtSilk.getItemMainColor(stack, 1);
                int secondaryColorOne = shirtSilk.getItemSecondaryColor(stack, 1);
                int primaryColorTwo = shirtSilk.getItemMainColor(stack, 2);
                int secondaryColorTwo = shirtSilk.getItemSecondaryColor(stack, 2);
                String dyeTypeOne = shirtSilk.getItemDyeType(stack, 1);
                String dyeTypeTwo = shirtSilk.getItemDyeType(stack, 2);
                String stensilType = shirtSilk.getStensilType(stack);
                int lightValueOne = shirtSilk.getItemLightValue(stack, 1);
                int lightValueTwo = shirtSilk.getItemLightValue(stack, 2);
                String renderType = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getRenderType();
                ResourceLocation tex1 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getTextureOne();
                ResourceLocation tex2 = WeaversParadiseShirtTextureHandler.getByTypeAndMaterial(stensilType, "silk").getTextureTwo();
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                EntityModel playerModel = renderLayerParent.getModel();
                if (playerModel instanceof HumanoidModel) {
                    HumanoidModel humModel = (HumanoidModel)playerModel;
                    ShirtSilkRenderer.model.Body.copyFrom(humModel.body);
                    ShirtSilkRenderer.model.LeftArm.copyFrom(humModel.leftArm);
                    ShirtSilkRenderer.model.RightArm.copyFrom(humModel.rightArm);
                }
                int redPrimaryOne = primaryColorOne >> 16 & 0xFF;
                int greenPrimaryOne = primaryColorOne >> 8 & 0xFF;
                int bluePrimaryOne = primaryColorOne & 0xFF;
                int redSecondaryOne = secondaryColorOne >> 16 & 0xFF;
                int greenSecondaryOne = secondaryColorOne >> 8 & 0xFF;
                int blueSecondaryOne = secondaryColorOne & 0xFF;
                int redPrimaryTwo = primaryColorTwo >> 16 & 0xFF;
                int greenPrimaryTwo = primaryColorTwo >> 8 & 0xFF;
                int bluePrimaryTwo = primaryColorTwo & 0xFF;
                int redSecondaryTwo = secondaryColorTwo >> 16 & 0xFF;
                int greenSecondaryTwo = secondaryColorTwo >> 8 & 0xFF;
                int blueSecondaryTwo = secondaryColorTwo & 0xFF;
                int finalRedOne = redPrimaryOne;
                int finalGreenOne = greenPrimaryOne;
                int finalBlueOne = bluePrimaryOne;
                int finalRedTwo = redPrimaryTwo;
                int finalGreenTwo = greenPrimaryTwo;
                int finalBlueTwo = bluePrimaryTwo;
                int colorOne = 0xFF000000 | finalRedOne << 16 | finalGreenOne << 8 | finalBlueOne;
                int colorTwo = 0xFF000000 | finalRedTwo << 16 | finalGreenTwo << 8 | finalBlueTwo;
                int lightOne = light;
                int lightTwo = light;
                if (dyeTypeOne.equals("rainbow")) {
                    colorOne = this.getRainbowColor(ticks);
                }
                if (dyeTypeTwo.equals("rainbow")) {
                    colorTwo = this.getRainbowColor(ticks);
                }
                if (dyeTypeOne.equals("ender")) {
                    lightOne = 0;
                }
                if (dyeTypeTwo.equals("ender")) {
                    lightTwo = 0;
                }
                if (dyeTypeOne.equals("glowstone")) {
                    lightOne = 0xF000F0;
                }
                if (dyeTypeTwo.equals("glowstone")) {
                    lightTwo = 0xF000F0;
                }
                if (dyeTypeOne.equals("biome")) {
                    bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                    color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                    colorOne = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                }
                if (dyeTypeTwo.equals("biome")) {
                    bpos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
                    color = ((Biome)mc.level.getBiome(bpos).value()).getGrassColor(entity.getX(), entity.getZ());
                    colorTwo = color = 0xFF000000 | (color >> 16 & 0xFF) << 16 | (color >> 8 & 0xFF) << 8 | color & 0xFF;
                }
                if (dyeTypeOne.equals("speed")) {
                    vec3 = entity.getDeltaMovement();
                    double velocity = vec3.lengthSqr();
                    colorOnes3 = primaryColorOne;
                    colorTwos3 = secondaryColorOne;
                    redOne3 = colorOnes3 >> 16 & 0xFF;
                    greenOne3 = colorOnes3 >> 8 & 0xFF;
                    blueOne3 = colorOnes3 & 0xFF;
                    redTwo3 = colorTwos3 >> 16 & 0xFF;
                    greenTwo3 = colorTwos3 >> 8 & 0xFF;
                    blueTwo3 = colorTwos3 & 0xFF;
                    finalRed4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne3, (int)redTwo3);
                    finalGreen3 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne3, (int)greenTwo3);
                    finalBlue4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne3, (int)blueTwo3);
                    colorOne = finalColor3 = 0xFF000000 | finalRed4 << 16 | finalGreen3 << 8 | finalBlue4;
                }
                if (dyeTypeTwo.equals("speed")) {
                    vec3 = entity.getDeltaMovement();
                    double velocity = vec3.lengthSqr();
                    colorOnes3 = primaryColorTwo;
                    colorTwos3 = secondaryColorTwo;
                    redOne3 = colorOnes3 >> 16 & 0xFF;
                    greenOne3 = colorOnes3 >> 8 & 0xFF;
                    blueOne3 = colorOnes3 & 0xFF;
                    redTwo3 = colorTwos3 >> 16 & 0xFF;
                    greenTwo3 = colorTwos3 >> 8 & 0xFF;
                    blueTwo3 = colorTwos3 & 0xFF;
                    finalRed4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)redOne3, (int)redTwo3);
                    finalGreen3 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)greenOne3, (int)greenTwo3);
                    finalBlue4 = Mth.lerpInt((float)((float)Mth.clamp((double)(velocity / 0.029081503190380643), (double)0.0, (double)1.0)), (int)blueOne3, (int)blueTwo3);
                    colorTwo = finalColor3 = 0xFF000000 | finalRed4 << 16 | finalGreen3 << 8 | finalBlue4;
                }
                if (dyeTypeOne.equals("height_bedrock")) {
                    int absoluteMinimum = mc.level.getMinBuildHeight();
                    int absoluteMaximum = mc.level.getMaxBuildHeight();
                    height = (int)entity.getY();
                    float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                    colorOnes2 = primaryColorOne;
                    colorTwos2 = secondaryColorOne;
                    redOne2 = colorOnes2 >> 16 & 0xFF;
                    greenOne2 = colorOnes2 >> 8 & 0xFF;
                    blueOne2 = colorOnes2 & 0xFF;
                    redTwo2 = colorTwos2 >> 16 & 0xFF;
                    greenTwo2 = colorTwos2 >> 8 & 0xFF;
                    blueTwo2 = colorTwos2 & 0xFF;
                    finalRed3 = Mth.lerpInt((float)value, (int)redOne2, (int)redTwo2);
                    finalGreen2 = Mth.lerpInt((float)value, (int)greenOne2, (int)greenTwo2);
                    finalBlue3 = Mth.lerpInt((float)value, (int)blueOne2, (int)blueTwo2);
                    colorOne = finalColor2 = 0xFF000000 | finalRed3 << 16 | finalGreen2 << 8 | finalBlue3;
                }
                if (dyeTypeTwo.equals("height_bedrock")) {
                    int absoluteMinimum = mc.level.getMinBuildHeight();
                    int absoluteMaximum = mc.level.getMaxBuildHeight();
                    height = (int)entity.getY();
                    float value = Mth.clamp((float)(((float)height - (float)absoluteMinimum) / ((float)absoluteMaximum - (float)absoluteMinimum)), (float)0.0f, (float)1.0f);
                    colorOnes2 = primaryColorTwo;
                    colorTwos2 = secondaryColorTwo;
                    redOne2 = colorOnes2 >> 16 & 0xFF;
                    greenOne2 = colorOnes2 >> 8 & 0xFF;
                    blueOne2 = colorOnes2 & 0xFF;
                    redTwo2 = colorTwos2 >> 16 & 0xFF;
                    greenTwo2 = colorTwos2 >> 8 & 0xFF;
                    blueTwo2 = colorTwos2 & 0xFF;
                    finalRed3 = Mth.lerpInt((float)value, (int)redOne2, (int)redTwo2);
                    finalGreen2 = Mth.lerpInt((float)value, (int)greenOne2, (int)greenTwo2);
                    finalBlue3 = Mth.lerpInt((float)value, (int)blueOne2, (int)blueTwo2);
                    colorTwo = finalColor2 = 0xFF000000 | finalRed3 << 16 | finalGreen2 << 8 | finalBlue3;
                }
                if (dyeTypeOne.equals("height_sea")) {
                    double minY = mc.level.getMinBuildHeight();
                    double maxY = mc.level.getMaxBuildHeight();
                    double seaY = mc.level.getSeaLevel();
                    double playerY = entity.getY();
                    double distanceAbove = maxY - seaY;
                    double distanceBelow = seaY - minY;
                    double maxDistance = Math.max(distanceAbove, distanceBelow);
                    float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                    colorOnes = primaryColorOne;
                    colorTwos = secondaryColorOne;
                    redOne = colorOnes >> 16 & 0xFF;
                    greenOne = colorOnes >> 8 & 0xFF;
                    blueOne = colorOnes & 0xFF;
                    redTwo = colorTwos >> 16 & 0xFF;
                    greenTwo = colorTwos >> 8 & 0xFF;
                    blueTwo = colorTwos & 0xFF;
                    finalRed2 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    finalBlue2 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    colorOne = finalColor = 0xFF000000 | finalRed2 << 16 | finalGreen << 8 | finalBlue2;
                }
                if (dyeTypeTwo.equals("height_sea")) {
                    double minY = mc.level.getMinBuildHeight();
                    double maxY = mc.level.getMaxBuildHeight();
                    double seaY = mc.level.getSeaLevel();
                    double playerY = entity.getY();
                    double distanceAbove = maxY - seaY;
                    double distanceBelow = seaY - minY;
                    double maxDistance = Math.max(distanceAbove, distanceBelow);
                    float value = (float)Mth.clamp((double)(Math.abs(playerY - seaY) / maxDistance), (double)0.0, (double)1.0);
                    colorOnes = primaryColorTwo;
                    colorTwos = secondaryColorTwo;
                    redOne = colorOnes >> 16 & 0xFF;
                    greenOne = colorOnes >> 8 & 0xFF;
                    blueOne = colorOnes & 0xFF;
                    redTwo = colorTwos >> 16 & 0xFF;
                    greenTwo = colorTwos >> 8 & 0xFF;
                    blueTwo = colorTwos & 0xFF;
                    finalRed2 = Mth.lerpInt((float)value, (int)redOne, (int)redTwo);
                    finalGreen = Mth.lerpInt((float)value, (int)greenOne, (int)greenTwo);
                    finalBlue2 = Mth.lerpInt((float)value, (int)blueOne, (int)blueTwo);
                    colorTwo = finalColor = 0xFF000000 | finalRed2 << 16 | finalGreen << 8 | finalBlue2;
                }
                if (dyeTypeOne.equals("sculk")) {
                    int redMain = 5;
                    int greenMain = 38;
                    int blueMain = 43;
                    int redPulse = 0;
                    int greenPulse = 255;
                    bluePulse = 255;
                    int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                    finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                    int finalGreen4 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                    finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                    colorOne = 0xFF000000 | finalRed << 16 | finalGreen4 << 8 | finalBlue;
                }
                if (dyeTypeTwo.equals("sculk")) {
                    int redMain = 5;
                    int greenMain = 38;
                    int blueMain = 43;
                    int redPulse = 0;
                    int greenPulse = 255;
                    bluePulse = 255;
                    int sculkPulse = WeaversParadiseGlobalRendererDataHolder.getSculkPulse();
                    finalRed = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)redMain, (int)redPulse);
                    int finalGreen5 = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)greenMain, (int)greenPulse);
                    finalBlue = Mth.lerpInt((float)((float)sculkPulse / 60.0f), (int)blueMain, (int)bluePulse);
                    colorTwo = 0xFF000000 | finalRed << 16 | finalGreen5 << 8 | finalBlue;
                }
                if (dyeTypeOne.equals("lamp")) {
                    lightOne = lightValueOne << 20 | lightValueOne << 4;
                }
                if (dyeTypeTwo.equals("lamp")) {
                    lightTwo = lightValueTwo << 20 | lightValueTwo << 4;
                }
                VertexConsumer vertexConsumerOne = renderTypeBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex1));
                if (dyeTypeOne.equals("ender")) {
                    vertexConsumerOne = renderTypeBuffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex1, TheEndPortalRenderer.END_PORTAL_LOCATION));
                }
                model.renderToBuffer(matrixStack, vertexConsumerOne, lightOne, OverlayTexture.NO_OVERLAY, colorOne);
                if (renderType.equals("double")) {
                    VertexConsumer vertexConsumerTwo = renderTypeBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex2));
                    if (dyeTypeTwo.equals("ender")) {
                        vertexConsumerTwo = renderTypeBuffer.getBuffer(WeaversParadiseRenderTypes.getVoidArmor(TheEndPortalRenderer.END_SKY_LOCATION, tex2, TheEndPortalRenderer.END_PORTAL_LOCATION));
                    }
                    model.renderToBuffer(matrixStack, vertexConsumerTwo, lightTwo, OverlayTexture.NO_OVERLAY, colorTwo);
                }
            }
        }
    }

    public int getRainbowColor(int ticks) {
        float speed = 0.05f;
        float red = Mth.clamp((float)((float)(Math.sin((float)ticks * speed) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float green = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 2.0943951023931953) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        float blue = Mth.clamp((float)((float)(Math.sin((double)((float)ticks * speed) + 4.1887902047863905) * 0.5 + 0.5)), (float)0.0f, (float)1.0f);
        int truered = (int)(red * 255.0f);
        int truegreen = (int)(green * 255.0f);
        int trueblue = (int)(blue * 255.0f);
        return 0xFF000000 | truered << 16 | truegreen << 8 | trueblue;
    }
}

