/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class BiomeNamesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("stopwatchserverutils", "chatconfig");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("biomeconfig.json");

    public static void init() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject defaultConfig = BiomeNamesConfig.createDefaultConfig();
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)BiomeNamesConfig.createDefaultConfig()), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("minecraft:the_void", "The Void");
        config.addProperty("minecraft:plains", "Plains");
        config.addProperty("minecraft:sunflower_plains", "Sunflower Plains");
        config.addProperty("minecraft:snowy_plains", "Snowy Plains");
        config.addProperty("minecraft:ice_spikes", "Ice Spikes");
        config.addProperty("minecraft:desert", "Desert");
        config.addProperty("minecraft:swamp", "Swamp");
        config.addProperty("minecraft:mangrove_swamp", "Mangrove Swamp");
        config.addProperty("minecraft:forest", "Forest");
        config.addProperty("minecraft:flower_forest", "Flower Forest");
        config.addProperty("minecraft:birch_forest", "Birch Forest");
        config.addProperty("minecraft:dark_forest", "Dark Forest");
        config.addProperty("minecraft:old_growth_birch_forest", "Old Growth Birch Forest");
        config.addProperty("minecraft:old_growth_pine_taiga", "Old Growth Pine Taiga");
        config.addProperty("minecraft:old_growth_spruce_taiga", "Old Growth Spruce Taiga");
        config.addProperty("minecraft:taiga", "Taiga");
        config.addProperty("minecraft:snowy_taiga", "Snowy Taiga");
        config.addProperty("minecraft:savanna", "Savanna");
        config.addProperty("minecraft:savanna_plateau", "Savanna Plateau");
        config.addProperty("minecraft:windswept_hills", "Windswept Hills");
        config.addProperty("minecraft:windswept_gravelly_hills", "Windswept Gravelly Hills");
        config.addProperty("minecraft:windswept_forest", "Windswept Forest");
        config.addProperty("minecraft:windswept_savanna", "Windswept Savanna");
        config.addProperty("minecraft:jungle", "Jungle");
        config.addProperty("minecraft:sparse_jungle", "Sparse Jungle");
        config.addProperty("minecraft:bamboo_jungle", "Bamboo Jungle");
        config.addProperty("minecraft:badlands", "Badlands");
        config.addProperty("minecraft:eroded_badlands", "Eroded Badlands");
        config.addProperty("minecraft:wooded_badlands", "Wooded Badlands");
        config.addProperty("minecraft:meadow", "Meadow");
        config.addProperty("minecraft:cherry_grove", "Cherry Grove");
        config.addProperty("minecraft:grove", "Grove");
        config.addProperty("minecraft:snowy_slopes", "Snowy Slopes");
        config.addProperty("minecraft:frozen_peaks", "Frozen Peaks");
        config.addProperty("minecraft:ocean", "Ocean");
        config.addProperty("minecraft:deep_ocean", "Deep Ocean");
        config.addProperty("minecraft:frozen_ocean", "Frozen Ocean");
        config.addProperty("minecraft:deep_frozen_ocean", "Deep Frozen Ocean");
        config.addProperty("minecraft:cold_ocean", "Cold Ocean");
        config.addProperty("minecraft:deep_cold_ocean", "Deep Cold Ocean");
        config.addProperty("minecraft:lukewarm_ocean", "Lukewarm Ocean");
        config.addProperty("minecraft:deep_lukewarm_ocean", "Deep Lukewarm Ocean");
        config.addProperty("minecraft:warm_ocean", "Warm Ocean");
        config.addProperty("minecraft:mushroom_fields", "Mushroom Fields");
        config.addProperty("minecraft:dripstone_caves", "Dripstone Caves");
        config.addProperty("minecraft:lush_caves", "Lush Caves");
        config.addProperty("minecraft:deep_dark", "The Deep Dark");
        config.addProperty("minecraft:nether_wastes", "Nether Wastes");
        config.addProperty("minecraft:soul_sand_valley", "Soul Sand Valley");
        config.addProperty("minecraft:basalt_deltas", "Basalt Deltas");
        config.addProperty("minecraft:crimson_forest", "Crimson Forest");
        config.addProperty("minecraft:warped_forest", "Warped Forest");
        config.addProperty("minecraft:the_end", "The End");
        config.addProperty("minecraft:end_midlands", "End Midlands");
        config.addProperty("minecraft:end_highlands", "End Highlands");
        config.addProperty("minecraft:small_end_islands", "Small End Islands");
        config.addProperty("minecraft:end_barrens", "End Barrens");
        return config;
    }

    public static String handleNameFromNamespace(String namespace) {
        String returnVal = namespace;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            for (Map.Entry entry : config.entrySet()) {
                if (!((String)entry.getKey()).equals(namespace)) continue;
                returnVal = ((JsonElement)entry.getValue()).getAsString();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }
}

