/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChatConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("stopwatchserverutils", "chatconfig");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("chatconfig.json");

    public static void init() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject defaultConfig = ChatConfigHandler.createDefaultConfig();
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)ChatConfigHandler.createDefaultConfig()), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("unheardMessage", "No one received your message!");
        config.addProperty("noAccessMessage", "You do not have access to this chat!");
        JsonObject localChat = new JsonObject();
        localChat.addProperty("chatPrefix", "!!!does not require a prefix!!!");
        localChat.addProperty("messageFormat", "[L]{prefix} {name} {suffix}: {message}");
        localChat.addProperty("distance", (Number)48);
        JsonObject globalChat = new JsonObject();
        globalChat.addProperty("chatPrefix", "!");
        globalChat.addProperty("messageFormat", "[G]{prefix} {name} {suffix}: {message}");
        JsonObject adminChat = new JsonObject();
        adminChat.addProperty("chatPrefix", "YOUR PREFIX HERE");
        adminChat.addProperty("messageFormat", "[A]{prefix} {name} {suffix}: {message}");
        adminChat.addProperty("permissionName", "admin");
        adminChat.addProperty("vanillaPermissionLevel", (Number)4);
        adminChat.addProperty("useVanillaPermission", Boolean.valueOf(true));
        JsonObject customChats = new JsonObject();
        JsonObject exampleChat1 = new JsonObject();
        exampleChat1.addProperty("chatPrefix", "YOUR PREFIX HERE");
        exampleChat1.addProperty("messageFormat", "[C1]{prefix} {name} {suffix}: {message}");
        exampleChat1.addProperty("distance", (Number)48);
        exampleChat1.addProperty("permission", (Number)0);
        exampleChat1.addProperty("onlySameLevel", Boolean.valueOf(false));
        exampleChat1.addProperty("onlyNearDistance", Boolean.valueOf(false));
        exampleChat1.addProperty("onlyWithPermission", Boolean.valueOf(false));
        JsonObject exampleChat2 = new JsonObject();
        exampleChat2.addProperty("chatPrefix", "YOUR PREFIX HERE");
        exampleChat2.addProperty("messageFormat", "[C2]{prefix} {name} {suffix}: {message}");
        exampleChat2.addProperty("distance", (Number)48);
        exampleChat2.addProperty("permission", (Number)0);
        exampleChat2.addProperty("onlySameLevel", Boolean.valueOf(false));
        exampleChat2.addProperty("onlyNearDistance", Boolean.valueOf(false));
        exampleChat2.addProperty("onlyWithPermission", Boolean.valueOf(false));
        customChats.add("exampleChatOne", (JsonElement)exampleChat1);
        customChats.add("exampleChatTwo", (JsonElement)exampleChat2);
        config.add("localChat", (JsonElement)localChat);
        config.add("globalChat", (JsonElement)globalChat);
        config.add("adminChat", (JsonElement)adminChat);
        config.add("customChats", (JsonElement)customChats);
        return config;
    }

    public static String getUnheardMessage() {
        String message = "";
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            message = config.get("unheardMessage").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static String getNoaccessMessage() {
        String message = "";
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            message = config.get("noAccessMessage").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static Map<String, String> getCustomChats() {
        HashMap<String, String> customchats = new HashMap<String, String>();
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject customChats = config.getAsJsonObject("customChats");
            for (Map.Entry entry : customChats.entrySet()) {
                String name = (String)entry.getKey();
                JsonObject chatData = ((JsonElement)entry.getValue()).getAsJsonObject();
                String prefix = chatData.get("chatPrefix").getAsString();
                String format = chatData.get("messageFormat").getAsString();
                int distance = chatData.get("distance").getAsInt();
                customchats.put(name, prefix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return customchats;
    }

    public static boolean getAdminPermissionType() {
        boolean returnVal = false;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject adminChat = config.getAsJsonObject("adminChat");
            returnVal = adminChat.get("useVanillaPermission").getAsBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public static int getVanillaPermissionLevel() {
        int returnVal = 4;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject adminChat = config.getAsJsonObject("adminChat");
            returnVal = adminChat.get("vanillaPermissionLevel").getAsInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public static String getLuckyPermsPermission() {
        String returnVal = "admin";
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject adminChat = config.getAsJsonObject("adminChat");
            returnVal = adminChat.get("permissionName").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public static String getFormatter(String name) {
        String returnValue;
        block9: {
            returnValue = "";
            try {
                JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
                if (name.equals("local")) {
                    JsonObject local;
                    if (config.has("localChat") && (local = config.getAsJsonObject("localChat")).has("messageFormat")) {
                        returnValue = local.get("messageFormat").getAsString();
                    }
                    break block9;
                }
                if (name.equals("global")) {
                    JsonObject local;
                    if (config.has("globalChat") && (local = config.getAsJsonObject("globalChat")).has("messageFormat")) {
                        returnValue = local.get("messageFormat").getAsString();
                    }
                    break block9;
                }
                if (name.equals("admin")) {
                    JsonObject local;
                    if (config.has("adminChat") && (local = config.getAsJsonObject("adminChat")).has("messageFormat")) {
                        returnValue = local.get("messageFormat").getAsString();
                    }
                    break block9;
                }
                JsonObject customChats = config.getAsJsonObject("customChats");
                for (Map.Entry entry : customChats.entrySet()) {
                    if (!name.equals(entry.getKey())) continue;
                    returnValue = ((JsonElement)entry.getValue()).getAsJsonObject().get("messageFormat").getAsString();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static List<Boolean> getPermissionsData(String name) {
        ArrayList<Boolean> data = new ArrayList<Boolean>();
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject customChats = config.getAsJsonObject("customChats");
            for (Map.Entry entry : customChats.entrySet()) {
                if (!name.equals(entry.getKey())) continue;
                JsonObject chatData = ((JsonElement)entry.getValue()).getAsJsonObject();
                data.add(chatData.get("onlySameLevel").getAsBoolean());
                data.add(chatData.get("onlyNearDistance").getAsBoolean());
                data.add(chatData.get("onlyWithPermission").getAsBoolean());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (name.equals("local") || name.equals("global") || name.equals("admin")) {
            data.add(true);
            data.add(true);
            data.add(true);
        }
        return data;
    }

    public static int getDistance(String name) {
        int data = 16;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject customChats = config.getAsJsonObject("customChats");
            for (Map.Entry entry : customChats.entrySet()) {
                if (!name.equals(entry.getKey())) continue;
                JsonObject chatData = ((JsonElement)entry.getValue()).getAsJsonObject();
                data = chatData.get("distance").getAsInt();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static int getLocalChatDistance() {
        int data = 48;
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("localChat") && (local = config.getAsJsonObject("localChat")).has("distance")) {
                data = local.get("distance").getAsInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static int getPermission(String name) {
        int data = 0;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject customChats = config.getAsJsonObject("customChats");
            for (Map.Entry entry : customChats.entrySet()) {
                if (!name.equals(entry.getKey())) continue;
                JsonObject chatData = ((JsonElement)entry.getValue()).getAsJsonObject();
                data = chatData.get("permission").getAsInt();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static String getFormatLocal() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("localChat") && (local = config.getAsJsonObject("localChat")).has("messageFormat")) {
                returnValue = local.get("messageFormat").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String getFormatGlobal() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("globalChat") && (local = config.getAsJsonObject("globalChat")).has("messageFormat")) {
                returnValue = local.get("messageFormat").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String getFormatAdmin() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("adminChat") && (local = config.getAsJsonObject("adminChat")).has("messageFormat")) {
                returnValue = local.get("messageFormat").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String getPrefixLocal() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("localChat") && (local = config.getAsJsonObject("localChat")).has("chatPrefix")) {
                returnValue = local.get("chatPrefix").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String getPrefixGlobal() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("globalChat") && (local = config.getAsJsonObject("globalChat")).has("chatPrefix")) {
                returnValue = local.get("chatPrefix").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String getPrefixAdmin() {
        String returnValue = "";
        try {
            JsonObject local;
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            if (config.has("adminChat") && (local = config.getAsJsonObject("adminChat")).has("chatPrefix")) {
                returnValue = local.get("chatPrefix").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static Map<String, String> getFormats() {
        HashMap<String, String> formats = new HashMap<String, String>();
        formats.put("local", ChatConfigHandler.getFormatLocal());
        formats.put("global", ChatConfigHandler.getFormatGlobal());
        formats.put("admin", ChatConfigHandler.getFormatAdmin());
        return formats;
    }

    public static Map<String, String> getPrefixes() {
        HashMap<String, String> formats = new HashMap<String, String>();
        formats.put("local", ChatConfigHandler.getPrefixLocal());
        formats.put("global", ChatConfigHandler.getPrefixGlobal());
        formats.put("admin", ChatConfigHandler.getPrefixAdmin());
        Map<String, String> custom = ChatConfigHandler.getCustomChats();
        formats.putAll(custom);
        return formats;
    }
}

