/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import xox.labvorty.stopwatchserverutils.ChatConfigHandler;
import xox.labvorty.stopwatchserverutils.LuckPermsDataAccess;
import xox.labvorty.stopwatchserverutils.PlaceholderHandler;

public class ChatFormattingHandler {
    @SubscribeEvent
    public void playerSentChat(ServerChatEvent event) {
        ServerPlayer sender = event.getPlayer();
        String rawMessage = event.getRawText();
        MinecraftServer server = sender.getServer();
        PlayerList playerList = server.getPlayerList();
        String messageRaw = rawMessage;
        Map<String, String> parsers = ChatConfigHandler.getFormats();
        Map<String, String> prefixes = ChatConfigHandler.getPrefixes();
        String messageParsing = ChatConfigHandler.getFormatLocal();
        String messageType = "local";
        for (Map.Entry<String, String> entry : prefixes.entrySet()) {
            if (!rawMessage.startsWith(entry.getValue()) || entry.getKey().equals("local")) continue;
            messageRaw = messageRaw.replaceFirst(entry.getValue(), "");
            messageType = entry.getKey();
            messageParsing = ChatConfigHandler.getFormatter(messageType);
            break;
        }
        List<Boolean> customConfirmData = ChatConfigHandler.getPermissionsData(messageType);
        int distance = ChatConfigHandler.getDistance(messageType);
        int permission = Mth.clamp((int)ChatConfigHandler.getPermission(messageType), (int)0, (int)4);
        int localDistance = ChatConfigHandler.getLocalChatDistance();
        boolean useVanillaPermissionForAdmin = ChatConfigHandler.getAdminPermissionType();
        int permissionAdmin = Mth.clamp((int)ChatConfigHandler.getVanillaPermissionLevel(), (int)0, (int)4);
        String lppermission = ChatConfigHandler.getLuckyPermsPermission();
        if (sender.getServer().getProfilePermissions(sender.getGameProfile()) < permission && !messageType.equals("local") && !messageType.equals("admin") && !messageType.equals("global") || sender.getServer().getProfilePermissions(sender.getGameProfile()) < permissionAdmin && useVanillaPermissionForAdmin && messageType.equals("admin") || !LuckPermsDataAccess.doesPlayerHavePermission(sender, lppermission) && !useVanillaPermissionForAdmin && messageType.equals("admin")) {
            messageType = "local";
            messageParsing = ChatConfigHandler.getFormatLocal();
            sender.sendSystemMessage(PlaceholderHandler.parseGradient(ChatConfigHandler.getNoaccessMessage()));
        }
        event.setCanceled(true);
        List<ServerPlayer> nearbyPlayers = sender.serverLevel().players().stream().filter(player -> player != sender).filter(player -> player.level() == sender.level()).filter(player -> player.distanceTo((Entity)sender) <= (float)localDistance).toList();
        List<ServerPlayer> customPlayers = sender.serverLevel().players().stream().filter(player -> player != sender).filter(player -> ((Boolean)customConfirmData.get(0)).booleanValue() ? player.level() == sender.level() : true).filter(player -> ((Boolean)customConfirmData.get(1)).booleanValue() ? player.distanceTo((Entity)sender) <= (float)distance : true).filter(player -> (Boolean)customConfirmData.get(2) != false ? player.hasPermissions(permission) : true).toList();
        List<ServerPlayer> adminPlayers = sender.serverLevel().players().stream().filter(player -> player != sender).filter(player -> useVanillaPermissionForAdmin ? player.getServer().getProfilePermissions(player.getGameProfile()) >= permissionAdmin : LuckPermsDataAccess.doesPlayerHavePermission(player, lppermission)).toList();
        MutableComponent handledMessage = Component.empty();
        HashMap<String, String> messageParts = new HashMap<String, String>();
        messageParts.put("prefix", PlaceholderHandler.parsePlayerPlaceholders("%lpprefix%", sender));
        messageParts.put("suffix", PlaceholderHandler.parsePlayerPlaceholders("%lpsuffix%", sender));
        messageParts.put("name", PlaceholderHandler.parsePlayerPlaceholders("%name%", sender));
        messageParts.put("message", PlaceholderHandler.parseChatPlaceholders(messageRaw, sender));
        String unmodifiedMessage = messageParsing;
        for (Map.Entry entry : messageParts.entrySet()) {
            String placeholder = "{" + (String)entry.getKey() + "}";
            if (!unmodifiedMessage.contains(placeholder)) continue;
            unmodifiedMessage = unmodifiedMessage.replace(placeholder, (CharSequence)entry.getValue());
        }
        handledMessage.append(PlaceholderHandler.parseGradient(unmodifiedMessage));
        if (messageType.equals("local")) {
            for (ServerPlayer serverPlayer : nearbyPlayers) {
                serverPlayer.sendSystemMessage((Component)handledMessage);
            }
            if (nearbyPlayers.isEmpty()) {
                sender.sendSystemMessage(PlaceholderHandler.parseGradient(ChatConfigHandler.getUnheardMessage()));
            }
            sender.sendSystemMessage((Component)handledMessage);
        } else if (messageType.equals("global")) {
            playerList.broadcastSystemMessage((Component)handledMessage, false);
        } else if (messageType.equals("admin")) {
            for (ServerPlayer serverPlayer : adminPlayers) {
                serverPlayer.sendSystemMessage((Component)handledMessage);
            }
            if (adminPlayers.isEmpty()) {
                sender.sendSystemMessage(PlaceholderHandler.parseGradient(ChatConfigHandler.getUnheardMessage()));
            }
            sender.sendSystemMessage((Component)handledMessage);
        } else {
            for (Map.Entry<Object, Object> entry : prefixes.entrySet()) {
                if (!((String)entry.getKey()).equals(messageType)) continue;
                for (ServerPlayer player3 : customPlayers) {
                    player3.sendSystemMessage((Component)handledMessage);
                }
                if (nearbyPlayers.isEmpty()) {
                    sender.sendSystemMessage(PlaceholderHandler.parseGradient(ChatConfigHandler.getUnheardMessage()));
                }
                sender.sendSystemMessage((Component)handledMessage);
                break;
            }
        }
    }
}

