/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class DimensionNamesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("stopwatchserverutils", "chatconfig");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("dimensionconfig.json");

    public static void init() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject defaultConfig = DimensionNamesConfig.createDefaultConfig();
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)DimensionNamesConfig.createDefaultConfig()), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("minecraft:overworld", "Overworld");
        config.addProperty("minecraft:the_nether", "The Nether");
        config.addProperty("minecraft:the_end", "The End");
        return config;
    }

    public static String handleNameFromNamespace(String namespace) {
        String returnVal = namespace;
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            for (Map.Entry entry : config.entrySet()) {
                if (!((String)entry.getKey()).equals(namespace)) continue;
                returnVal = ((JsonElement)entry.getValue()).getAsString();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }
}

