/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;

public class PlaceholderHandler {
    private static Map<String, Function<ServerPlayer, String>> PLAYER_PLACEHOLDERS = new HashMap<String, Function<ServerPlayer, String>>();
    private static final Pattern MODDED_STAT_PATTERN = Pattern.compile("%stat:([a-z0-9_]+):([a-z0-9_/]+)%");
    private static final Pattern ZONE_PATTERN = Pattern.compile("%time-zone:([A-Z]{2,4})%");
    private static Map<String, Function<ServerPlayer, String>> CHAT_PLACEHOLDERS = new HashMap<String, Function<ServerPlayer, String>>();

    public static void registerPlayerPlaceholder(String key, Function<ServerPlayer, String> resolver) {
        PLAYER_PLACEHOLDERS.put(key.toLowerCase(), resolver);
    }

    public static void registerChatPlaceholder(String key, Function<ServerPlayer, String> resolver) {
        CHAT_PLACEHOLDERS.put(key.toLowerCase(), resolver);
    }

    public static void clearSetup() {
        PLAYER_PLACEHOLDERS.clear();
        CHAT_PLACEHOLDERS.clear();
    }

    public static String parseChatPlaceholders(String input, ServerPlayer player) {
        String result = input;
        for (Map.Entry<String, Function<ServerPlayer, String>> entry : CHAT_PLACEHOLDERS.entrySet()) {
            String placeholder = "[" + entry.getKey() + "]";
            if (!result.contains(placeholder)) continue;
            result = result.replace(placeholder, entry.getValue().apply(player));
        }
        return result;
    }

    public static String parsePlayerPlaceholders(String input, ServerPlayer player) {
        String result = input;
        for (Map.Entry<String, Function<ServerPlayer, String>> entry : PLAYER_PLACEHOLDERS.entrySet()) {
            String placeholder = "%" + entry.getKey() + "%";
            if (!result.contains(placeholder)) continue;
            result = result.replace(placeholder, entry.getValue().apply(player));
        }
        Matcher matcher = MODDED_STAT_PATTERN.matcher(result);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String modid = matcher.group(1);
            String statName = matcher.group(2);
            String fullKey = modid + ":" + statName;
            try {
                int value = 0;
                ResourceLocation locKey = ResourceLocation.fromNamespaceAndPath((String)modid, (String)statName);
                Registry registry = player.level().registryAccess().registryOrThrow(Registries.CUSTOM_STAT);
                ResourceLocation canonicalKey = (ResourceLocation)registry.get(locKey);
                if (canonicalKey != null) {
                    Stat stat = Stats.CUSTOM.get((Object)canonicalKey);
                    value = player.getStats().getValue(stat);
                }
                matcher.appendReplacement(output, String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        matcher.appendTail(output);
        result = output.toString();
        Matcher zonematcher = ZONE_PATTERN.matcher(result);
        StringBuffer output1 = new StringBuffer();
        while (zonematcher.find()) {
            String shortID = zonematcher.group(1);
            try {
                ZoneId zoneID = ZoneId.of(shortID, ZoneId.SHORT_IDS);
                ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneID);
                String formattedTime = zonedDateTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                zonematcher.appendReplacement(output1, formattedTime);
            }
            catch (Exception e) {
                zonematcher.appendReplacement(output1, "Invalid time zone: " + shortID);
            }
        }
        zonematcher.appendTail(output1);
        return output1.toString();
    }

    public static Component parseGradient(String input) {
        return PlaceholderHandler.parseGradient(input, Style.EMPTY);
    }

    public static Component parseGradient(String input, Style baseStyle) {
        MutableComponent result = Component.empty();
        Pattern pattern = Pattern.compile("<(#([A-Fa-f0-9]{6}))>|</#([A-Fa-f0-9]{6})>|<(bold|italic|underlined|strikethrough|obfuscated)>|</(bold|italic|underlined|strikethrough|obfuscated)>|<hoverevent:([^>]+)>|</(hoverevent)>|<clickevent:([^>]+)>|</(clickevent)>");
        Matcher matcher = pattern.matcher(input);
        int index = 0;
        ArrayDeque<String> formatStack = new ArrayDeque<String>();
        ArrayDeque<String> gradientColorStack = new ArrayDeque<String>();
        ArrayDeque<String> hoverTextStack = new ArrayDeque<String>();
        ArrayDeque<String> clickTextStack = new ArrayDeque<String>();
        Style currentStyle = baseStyle;
        String pendingGradientStart = null;
        StringBuilder pendingGradientText = new StringBuilder();
        while (matcher.find()) {
            String tag;
            String textBetween = input.substring(index, matcher.start());
            index = matcher.end();
            if (!textBetween.isEmpty()) {
                if (pendingGradientStart != null) {
                    pendingGradientText.append(textBetween);
                } else {
                    result = result.append((Component)Component.literal((String)textBetween).withStyle(currentStyle));
                }
            }
            if (matcher.group(1) != null) {
                gradientColorStack.push(matcher.group(2));
                if (pendingGradientStart != null) continue;
                pendingGradientStart = matcher.group(2);
                pendingGradientText.setLength(0);
                continue;
            }
            if (matcher.group(3) != null) {
                String endColor = matcher.group(3);
                if (gradientColorStack.isEmpty()) continue;
                String startColor = (String)gradientColorStack.pop();
                if (pendingGradientStart == null || pendingGradientText.length() <= 0) continue;
                result = result.append(PlaceholderHandler.applyTextWithCurrentStyle(pendingGradientText.toString(), currentStyle, pendingGradientStart, endColor));
                pendingGradientText.setLength(0);
                pendingGradientStart = null;
                continue;
            }
            if (matcher.group(4) != null) {
                tag = matcher.group(4);
                formatStack.push(tag);
                currentStyle = PlaceholderHandler.applyFormatting(currentStyle, tag, true);
                continue;
            }
            if (matcher.group(5) != null) {
                tag = matcher.group(5);
                if (formatStack.isEmpty() || !((String)formatStack.peek()).equals(tag)) continue;
                formatStack.pop();
                currentStyle = PlaceholderHandler.applyFormatting(currentStyle, tag, false);
                continue;
            }
            if (matcher.group(6) != null) {
                String hoverText = matcher.group(6);
                hoverTextStack.push(hoverText);
                currentStyle = currentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)hoverText)));
                continue;
            }
            if (matcher.group(7) != null) {
                if (!hoverTextStack.isEmpty()) {
                    hoverTextStack.pop();
                }
                currentStyle = currentStyle.withHoverEvent(null);
                continue;
            }
            if (matcher.group(8) != null) {
                String clickText = matcher.group(8);
                clickTextStack.push(clickText);
                currentStyle = currentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, clickText));
                continue;
            }
            if (matcher.group(9) == null) continue;
            if (!clickTextStack.isEmpty()) {
                clickTextStack.pop();
            }
            currentStyle = currentStyle.withClickEvent(null);
        }
        if (index < input.length()) {
            String remaining = input.substring(index);
            if (pendingGradientStart != null) {
                pendingGradientText.append(remaining);
            } else {
                result = result.append((Component)Component.literal((String)remaining).withStyle(currentStyle));
            }
        }
        if (pendingGradientStart != null && pendingGradientText.length() > 0) {
            result = result.append((Component)Component.literal((String)pendingGradientText.toString()).withStyle(currentStyle));
        }
        return result;
    }

    private static Component applyTextWithCurrentStyle(String text, Style style, String startHex, String endHex) {
        if (startHex != null && endHex != null && !text.isEmpty()) {
            int r1 = Integer.parseInt(startHex.substring(0, 2), 16);
            int g1 = Integer.parseInt(startHex.substring(2, 4), 16);
            int b1 = Integer.parseInt(startHex.substring(4, 6), 16);
            int r2 = Integer.parseInt(endHex.substring(0, 2), 16);
            int g2 = Integer.parseInt(endHex.substring(2, 4), 16);
            int b2 = Integer.parseInt(endHex.substring(4, 6), 16);
            MutableComponent gradientComponent = Component.empty();
            if (text.length() == 1) {
                int r = (r1 + r2) / 2;
                int g = (g1 + g2) / 2;
                int b = (b1 + b2) / 2;
                int rgb = r << 16 | g << 8 | b;
                return Component.literal((String)text).withStyle(style.withColor(TextColor.fromRgb((int)rgb)));
            }
            for (int i = 0; i < text.length(); ++i) {
                double t = (double)i / (double)(text.length() - 1);
                int r = (int)((double)r1 + (double)(r2 - r1) * t);
                int g = (int)((double)g1 + (double)(g2 - g1) * t);
                int b = (int)((double)b1 + (double)(b2 - b1) * t);
                int rgb = r << 16 | g << 8 | b;
                gradientComponent = gradientComponent.append((Component)Component.literal((String)String.valueOf(text.charAt(i))).withStyle(style.withColor(TextColor.fromRgb((int)rgb))));
            }
            return gradientComponent;
        }
        return Component.literal((String)text).withStyle(style);
    }

    private static Style applyFormatting(Style style, String tag, boolean enable) {
        return switch (tag) {
            case "bold" -> style.withBold(Boolean.valueOf(enable));
            case "italic" -> style.withItalic(Boolean.valueOf(enable));
            case "underlined" -> style.withUnderlined(Boolean.valueOf(enable));
            case "strikethrough" -> style.withStrikethrough(Boolean.valueOf(enable));
            case "obfuscated" -> style.withObfuscated(Boolean.valueOf(enable));
            default -> style;
        };
    }
}

