/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import xox.labvorty.stopwatchserverutils.BiomeNamesConfig;
import xox.labvorty.stopwatchserverutils.DimensionNamesConfig;
import xox.labvorty.stopwatchserverutils.LuckPermsDataAccess;
import xox.labvorty.stopwatchserverutils.PlaceholderHandler;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PlaceholderRegister {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PlaceholderHandler.clearSetup();
            PlaceholderHandler.registerPlayerPlaceholder("name", player -> player.getName().getString());
            PlaceholderHandler.registerPlayerPlaceholder("uuid", player -> player.getUUID().toString());
            PlaceholderHandler.registerPlayerPlaceholder("health", player -> String.valueOf(player.getHealth()));
            PlaceholderHandler.registerPlayerPlaceholder("mspt", player -> {
                MinecraftServer server = player.getServer();
                if (server == null) {
                    return "N/A";
                }
                double nanos = server.getAverageTickTimeNanos();
                if (nanos <= 0.0 || Double.isNaN(nanos) || Double.isInfinite(nanos)) {
                    return "0.0";
                }
                double mspt = nanos / 1000000.0;
                return String.format("%.2f", mspt);
            });
            PlaceholderHandler.registerPlayerPlaceholder("tps", player -> {
                MinecraftServer server = player.getServer();
                if (server == null) {
                    return "N/A";
                }
                double nanos = server.getAverageTickTimeNanos();
                if (nanos <= 0.0 || Double.isNaN(nanos) || Double.isInfinite(nanos)) {
                    return "20.0";
                }
                double millis = nanos / 1000000.0;
                double tps = Math.min(1000.0 / millis, 20.0);
                return String.format("%.1f", tps);
            });
            PlaceholderHandler.registerPlayerPlaceholder("lpprefix", player -> LuckPermsDataAccess.getPrefix(player));
            PlaceholderHandler.registerPlayerPlaceholder("lpsuffix", player -> LuckPermsDataAccess.getSuffix(player));
            PlaceholderHandler.registerPlayerPlaceholder("playtime", player -> {
                int ticks = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
                int totalSeconds = ticks / 20;
                int seconds = totalSeconds % 60;
                int minutes = totalSeconds % 3600 / 60;
                int hours = seconds / 3600;
                return String.format("%dh %dm %ds", hours, minutes, seconds);
            });
            PlaceholderHandler.registerPlayerPlaceholder("online", player -> String.valueOf(player.getServer().getPlayerCount()));
            PlaceholderHandler.registerPlayerPlaceholder("onlinewm", player -> {
                int playeramount = player.getServer().getPlayerCount();
                int maxplayeramount = player.getServer().getMaxPlayers();
                return playeramount + "/" + maxplayeramount;
            });
            PlaceholderHandler.registerChatPlaceholder("pos", player -> {
                double X = player.getX();
                double Y = player.getY();
                double Z = player.getZ();
                return String.format("%.1f %.1f %.1f", X, Y, Z);
            });
            PlaceholderHandler.registerPlayerPlaceholder("ping", player -> String.valueOf(player.connection.latency()));
            PlaceholderHandler.registerChatPlaceholder("dimension", player -> DimensionNamesConfig.handleNameFromNamespace(player.level().dimension().location().toString()));
            PlaceholderHandler.registerChatPlaceholder("biome", player -> {
                BlockPos bPos;
                ServerLevel level = player.serverLevel();
                Holder biomeHolder = level.getBiome(bPos = player.blockPosition());
                ResourceKey biomeKey = biomeHolder.unwrapKey().orElse(null);
                if (biomeKey != null) {
                    return BiomeNamesConfig.handleNameFromNamespace(biomeKey.location().toString());
                }
                return "null";
            });
        });
    }
}

