/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class TabConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("stopwatchserverutils", "tabconfig");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("tabconfig.json");

    public static void init() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject defaultConfig = TabConfigHandler.createDefaultConfig();
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((JsonElement)TabConfigHandler.createDefaultConfig()), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        JsonObject header = new JsonObject();
        JsonArray headerLines = new JsonArray();
        headerLines.add("ServerName");
        header.add("lines", (JsonElement)headerLines);
        JsonObject footer = new JsonObject();
        JsonArray footerLines = new JsonArray();
        footerLines.add("ServerStats");
        footer.add("lines", (JsonElement)footerLines);
        config.add("header", (JsonElement)header);
        config.add("footer", (JsonElement)footer);
        return config;
    }

    public static List<String> getHeaders() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject elementObj = config.getAsJsonObject("header");
            JsonArray linesArray = elementObj.getAsJsonArray("lines");
            for (JsonElement line : linesArray) {
                lines.add(line.getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static List<String> getFooters() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_FILE), JsonObject.class);
            JsonObject elementObj = config.getAsJsonObject("footer");
            JsonArray linesArray = elementObj.getAsJsonArray("lines");
            for (JsonElement line : linesArray) {
                lines.add(line.getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }
}

