/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.stopwatchserverutils;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import xox.labvorty.stopwatchserverutils.PlaceholderHandler;
import xox.labvorty.stopwatchserverutils.TabConfigHandler;

public class TabListUpdater {
    private static int tickCounter = 0;

    @SubscribeEvent
    public void tabUpdate(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (tickCounter > 20) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                int i;
                MutableComponent header = Component.empty();
                MutableComponent footer = Component.empty();
                List<String> headers = TabConfigHandler.getHeaders();
                List<String> footers = TabConfigHandler.getFooters();
                for (i = 0; i < headers.size(); ++i) {
                    if (i != 0) {
                        header.append((Component)Component.literal((String)"\n"));
                    }
                    header.append(PlaceholderHandler.parseGradient(PlaceholderHandler.parsePlayerPlaceholders(headers.get(i), player)));
                }
                for (i = 0; i < footers.size(); ++i) {
                    if (i != 0) {
                        footer.append((Component)Component.literal((String)"\n"));
                    }
                    footer.append(PlaceholderHandler.parseGradient(PlaceholderHandler.parsePlayerPlaceholders(footers.get(i), player)));
                }
                player.connection.send((Packet)new ClientboundTabListPacket((Component)header, (Component)footer));
                player.refreshTabListName();
            }
            tickCounter = 0;
        } else {
            ++tickCounter;
        }
    }

    @SubscribeEvent
    public void updateTabName(PlayerEvent.TabListNameFormat event) {
        Component prefix = PlaceholderHandler.parseGradient(PlaceholderHandler.parsePlayerPlaceholders("%lpprefix%", (ServerPlayer)event.getEntity()));
        Component suffix = PlaceholderHandler.parseGradient(PlaceholderHandler.parsePlayerPlaceholders("%lpsuffix%", (ServerPlayer)event.getEntity()));
        MutableComponent resultName = Component.empty();
        resultName.append(prefix);
        resultName.append(" ");
        resultName.append(event.getEntity().getName());
        resultName.append(" ");
        resultName.append(suffix);
        event.setDisplayName((Component)resultName);
    }
}

