/*
 * Decompiled with CFR 0.152.
 */
package minimap;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import minimap.MinimapConfig;
import minimap.Waypoint;
import minimap.WaypointManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_3675;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class MinimapRenderer
implements HudRenderCallback {
    private static boolean mapExpanded = false;
    private static float mapTransition = 0.0f;
    private static class_304 toggleMapKey;
    private static final int TEX_SIZE = 128;
    private static final int TERRAIN_REFRESH_TICKS = 5;
    private class_1043 terrainTexture;
    private class_2960 terrainTextureId;
    private int terrainTick = 0;
    private double lastPpb = -1.0;
    private static final int RADIUS_PX = 64;
    private static final int BORDER_PX = 2;
    private static final int REFRESH_TICKS = 5;
    private final List<class_1297> cached = new ArrayList<class_1297>();
    private int frame = 0;
    private static final class_2960 FRAME_TEXTURE;
    private static final int ZOOM_BADGE_RADIUS = 10;
    private static final double ZOOM_BADGE_ANGLE = 42.0;
    private static final int ZOOM_BADGE_FROM_RING = 3;
    private static final float ZOOM_TEXT_SCALE = 0.75f;
    private static final int ZOOM_TEXT_OFFSET_Y = -3;

    private static class_2960 iconFor(class_1297 e) {
        String ns = "roman-mod";
        class_1299 t = e.method_5864();
        if (t == class_1299.field_6077) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/villager.png");
        }
        if (t == class_1299.field_6097) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/player.png");
        }
        if (t == class_1299.field_6085) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/cow.png");
        }
        if (t == class_1299.field_6115) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/sheep.png");
        }
        if (t == class_1299.field_6093) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/pig.png");
        }
        if (t == class_1299.field_6132) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/chicken.png");
        }
        if (t == class_1299.field_6055) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/wolf.png");
        }
        if (t == class_1299.field_6139) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/horse.png");
        }
        if (t == class_1299.field_6079) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/spider.png");
        }
        if (t == class_1299.field_6046) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/creeper.png");
        }
        if (t == class_1299.field_6091) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/enderman.png");
        }
        if (t == class_1299.field_6145) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/witch.png");
        }
        if (t == class_1299.field_22281) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/piglin.png");
        }
        if (t == class_1299.field_6069) {
            return class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/slime.png");
        }
        return null;
    }

    public static void registerExpansionKey() {
        toggleMapKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.romanmod.togglemap", class_3675.class_307.field_1668, 78, "key.categories.minimap"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (toggleMapKey.method_1436()) {
                mapExpanded = !mapExpanded;
            }
            float speed = 0.1f;
            mapTransition = mapExpanded ? Math.min(1.0f, mapTransition + speed) : Math.max(0.0f, mapTransition - speed);
        });
    }

    public void onHudRender(class_332 ctx, class_9779 tickCounter) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        ctx.method_51448().method_22903();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float tickDelta = tickCounter.method_60637(true);
        class_243 playerCenter = mc.field_1724.method_30950(tickDelta);
        float yaw = mc.field_1724.method_5705(tickDelta);
        class_1041 win = mc.method_22683();
        int smallX = win.method_4486() - 8 - 64;
        int smallY = 72;
        int bigX = win.method_4486() / 2;
        int bigY = win.method_4502() / 2;
        int centerX = class_3532.method_48781((float)mapTransition, (int)smallX, (int)bigX);
        int centerY = class_3532.method_48781((float)mapTransition, (int)smallY, (int)bigY);
        double ppb = MinimapConfig.pixelsPerBlock;
        if (mapTransition > 0.0f) {
            ppb *= 1.0 + (double)mapTransition * 1.5;
        }
        if (ppb != this.lastPpb) {
            this.terrainTick = 0;
            this.lastPpb = ppb;
        }
        float iconScale = (float)class_3532.method_15350((double)(ppb / 2.0), (double)0.25, (double)2.25);
        if (this.terrainTick++ % 5 == 0) {
            this.updateTerrainTexture(mc, ppb, MinimapConfig.rotatePlayerUp, yaw, playerCenter.field_1352, playerCenter.field_1350, playerCenter.field_1351);
        }
        if (this.frame++ % 5 == 0) {
            this.cached.clear();
            class_638 world = mc.field_1687;
            class_746 player = mc.field_1724;
            class_243 p = player.method_19538();
            int range = MinimapConfig.rangeBlocks();
            class_238 box = new class_238(p.field_1352 - (double)range, p.field_1351 - 64.0, p.field_1350 - (double)range, p.field_1352 + (double)range, p.field_1351 + 64.0, p.field_1350 + (double)range);
            world.method_8390(class_1309.class, box, e -> {
                class_1657 pe;
                return e.method_5805() && !e.method_5756((class_1657)player) && (!(e instanceof class_1657) || !(pe = (class_1657)e).method_7325());
            }).forEach(this.cached::add);
        }
        if (mapTransition > 0.05f) {
            int alpha = (int)(mapTransition * 180.0f);
            ctx.method_25294(0, 0, win.method_4486(), win.method_4502(), alpha << 24);
        }
        this.drawTerrainBase(ctx, centerX, centerY);
        double sin = 0.0;
        double cos = 1.0;
        if (MinimapConfig.rotatePlayerUp) {
            double rad = Math.toRadians(-yaw);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
        }
        for (class_1297 e2 : this.cached) {
            int rim;
            int py;
            int dyp;
            int px;
            int dxp;
            if (!(e2 instanceof class_1309) || e2 == mc.field_1724) continue;
            double ex = e2.method_30950((float)tickDelta).field_1352;
            double ez = e2.method_30950((float)tickDelta).field_1350;
            double dx = ex - playerCenter.field_1352;
            double dz = ez - playerCenter.field_1350;
            double rx = dx;
            double rz = dz;
            if (MinimapConfig.rotatePlayerUp) {
                double rdx = dx * cos - dz * sin;
                double rdz = dx * sin + dz * cos;
                rx = rdx;
                rz = rdz;
            }
            if ((dxp = (px = centerX + (int)Math.round(-rx * ppb)) - centerX) * dxp + (dyp = (py = centerY + (int)Math.round(-rz * ppb)) - centerY) * dyp > (rim = 54) * rim) continue;
            class_2960 icon = MinimapRenderer.iconFor(e2);
            boolean useIcon = false;
            if (e2 instanceof class_1657 || e2 instanceof class_1646 || e2.method_5864() == class_1299.field_6085 || e2.method_5864() == class_1299.field_6115 || e2.method_5864() == class_1299.field_6093 || e2.method_5864() == class_1299.field_6132 || e2.method_5864() == class_1299.field_6055 || e2.method_5864() == class_1299.field_6139 || e2.method_5864() == class_1299.field_6079 || e2.method_5864() == class_1299.field_6046 || e2.method_5864() == class_1299.field_6091 || e2.method_5864() == class_1299.field_6145 || e2.method_5864() == class_1299.field_22281 || e2.method_5864() == class_1299.field_6069) {
                useIcon = true;
            }
            class_2960 dotTex = e2 instanceof class_1422 || e2.method_5864() == class_1299.field_6114 || e2.method_5864() == class_1299.field_28315 || e2.method_5864() == class_1299.field_6113 || e2.method_5864() == class_1299.field_6087 ? class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/bdot.png") : class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/icons/dot.png");
            int size = Math.max(1, Math.round(8.0f * iconScale));
            if (useIcon && icon != null) {
                ctx.method_25290(icon, px - size / 2, py - size / 2, 0.0f, 0.0f, size, size, size, size);
                continue;
            }
            ctx.method_25290(dotTex, px - size / 2, py - size / 2, 0.0f, 0.0f, size, size, size, size);
        }
        class_2960 playerIcon = MinimapRenderer.iconFor((class_1297)mc.field_1724);
        if (playerIcon != null) {
            int size = Math.max(1, Math.round(14.0f * iconScale));
            ctx.method_25290(playerIcon, centerX - size / 2, centerY - size / 2, 0.0f, 0.0f, size, size, size, size);
        } else {
            ctx.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)"P"), centerX - 3, centerY - 3, -1, false);
        }
        this.drawWaypoints(ctx, centerX, centerY, ppb, MinimapConfig.rotatePlayerUp, yaw, playerCenter.field_1352, playerCenter.field_1350);
        if (mapTransition > 0.0f) {
            ctx.method_51448().method_22903();
            float scale = 1.0f + mapTransition * 0.8f;
            ctx.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
            ctx.method_51448().method_22905(scale, scale, 1.0f);
            ctx.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
            this.drawRingOverlay(ctx, centerX, centerY);
            ctx.method_51448().method_22909();
        } else {
            this.drawRingOverlay(ctx, centerX, centerY);
        }
        this.drawCompass(ctx, centerX, centerY, yaw, MinimapConfig.rotatePlayerUp);
        this.drawZoomBadge(ctx, centerX, centerY);
        this.drawClockTime(ctx, centerX, centerY);
        this.drawRealWorldTime(ctx, centerX, centerY);
        this.drawPlayerCoords(ctx, centerX, centerY);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        ctx.method_51448().method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWaypoints(class_332 ctx, int centerX, int centerY, double ppb, boolean rotateUp, float yawDeg, double baseX, double baseZ) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        Class<WaypointManager> clazz = WaypointManager.class;
        synchronized (WaypointManager.class) {
            ArrayList<Waypoint> safeList = new ArrayList<Waypoint>(WaypointManager.getForCurrentWorld());
            // ** MonitorExit[var14_10] (shouldn't be in output)
            if (safeList.isEmpty()) {
                return;
            }
            double sin = 0.0;
            double cos = 1.0;
            if (rotateUp) {
                double rad = Math.toRadians(-yawDeg);
                sin = Math.sin(rad);
                cos = Math.cos(rad);
            }
            int RIM = 58;
            int DOT = 3;
            int LABEL_INSET = 10;
            int LABEL_COLOR = -1;
            class_327 tr = mc.field_1772;
            for (Waypoint w : safeList) {
                double vy;
                double vx;
                double len;
                if (!w.enabled) continue;
                double dx = (double)w.x + 0.5 - baseX;
                double dz = (double)w.z + 0.5 - baseZ;
                double rx = dx;
                double rz = dz;
                if (rotateUp) {
                    double rdx = dx * cos - dz * sin;
                    double rdz = dx * sin + dz * cos;
                    rx = rdx;
                    rz = rdz;
                }
                double scale = (len = Math.hypot(vx = -rx * ppb, vy = -rz * ppb)) < 1.0E-6 ? 0.0 : Math.min(len, 58.0) / len;
                int px = centerX + (int)Math.round(vx * scale);
                int py = centerY + (int)Math.round(vy * scale);
                ctx.method_25294(px - 3, py - 3, px + 3, py + 3, w.color | 0xFF000000);
                int dist = (int)Math.round(Math.hypot(dx, dz));
                String label = dist + "b";
                double ux = centerX - px;
                double uy = centerY - py;
                double ulen = Math.hypot(ux, uy);
                if (ulen < 1.0E-6) {
                    ux = 0.0;
                    uy = 1.0;
                    ulen = 1.0;
                }
                int lx = px + (int)Math.round((ux /= ulen) * 10.0);
                int ly = py + (int)Math.round((uy /= ulen) * 10.0);
                int tw = tr.method_1727(label);
                Objects.requireNonNull(tr);
                int th = 9;
                ctx.method_51433(tr, label, lx - tw / 2, ly - th / 2, -1, true);
            }
            return;
        }
    }

    private static int colorForState(class_1937 world, class_2338 pos, class_2680 state) {
        class_324 bc;
        int tint;
        class_3610 fluid = state.method_26227();
        if (!fluid.method_15769()) {
            if (fluid.method_15767(class_3486.field_15518) || state.method_27852(class_2246.field_10164)) {
                return -47872;
            }
            if (fluid.method_15767(class_3486.field_15517) || state.method_27852(class_2246.field_10382)) {
                int rgb = class_1163.method_4961((class_1920)world, (class_2338)pos);
                return 0xFF000000 | rgb;
            }
        } else {
            if (state.method_27852(class_2246.field_10164)) {
                return -47872;
            }
            if (state.method_27852(class_2246.field_10382)) {
                int rgb = class_1163.method_4961((class_1920)world, (class_2338)pos);
                return 0xFF000000 | rgb;
            }
        }
        if ((tint = (bc = class_310.method_1551().method_1505()).method_1697(state, (class_1920)world, pos, 0)) != -1) {
            return 0xFF000000 | tint;
        }
        class_3620 mcCol = state.method_26205((class_1922)world, pos);
        int rgb = mcCol != null ? mcCol.field_16011 : 0x7F7F7F;
        return 0xFF000000 | rgb;
    }

    private void ensureTerrainTexture(class_310 mc) {
        if (this.terrainTexture == null) {
            this.terrainTexture = new class_1043(128, 128, true);
            class_1060 tm = mc.method_1531();
            this.terrainTextureId = tm.method_4617("roman_minimap_terrain", this.terrainTexture);
        }
    }

    private void updateTerrainTexture(class_310 mc, double ppb, boolean rotateUp, float yawDeg, double baseX, double baseZ, double baseY) {
        this.ensureTerrainTexture(mc);
        class_1011 img = this.terrainTexture.method_4525();
        int radiusPx = 64;
        double half = 64.0;
        int LOCAL_UP = 8;
        int LOCAL_DOWN = 64;
        double sin = 0.0;
        double cos = 1.0;
        if (rotateUp) {
            double rad = Math.toRadians(-yawDeg);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
        }
        class_638 world = mc.field_1687;
        int playerY = class_3532.method_15357((double)baseY);
        for (int iy = 0; iy < 128; ++iy) {
            for (int ix = 0; ix < 128; ++ix) {
                int wz;
                int wx;
                int surfaceY;
                double dx_px = (double)ix - 64.0;
                double dz_px = (double)iy - 64.0;
                if (dx_px * dx_px + dz_px * dz_px > 4096.0) {
                    MinimapRenderer.setARGB(img, ix, iy, 0);
                    continue;
                }
                double rx = -dx_px / ppb;
                double rz = -dz_px / ppb;
                double dx = rx;
                double dz = rz;
                if (rotateUp) {
                    dx = rx * cos + rz * sin;
                    dz = -rx * sin + rz * cos;
                }
                boolean underground = playerY < (surfaceY = world.method_8624(class_2902.class_2903.field_13202, wx = class_3532.method_15357((double)(baseX + dx)), wz = class_3532.method_15357((double)(baseZ + dz)))) - 8;
                class_2680 found = null;
                int foundY = playerY;
                if (underground) {
                    int bandDown = Math.max(playerY - 12, world.method_31607());
                    for (int y = playerY + 1; y >= bandDown; --y) {
                        class_2338 p = new class_2338(wx, y, wz);
                        class_2680 bs = world.method_8320(p);
                        if (!MinimapRenderer.isRenderable(bs, (class_1922)world, p)) continue;
                        found = bs;
                        foundY = y;
                        break;
                    }
                    if (found == null) {
                        int bandUp;
                        for (int y = bandUp = Math.min(playerY + 10, world.method_31600()); y >= playerY + 2; --y) {
                            class_2338 p = new class_2338(wx, y, wz);
                            bs = world.method_8320(p);
                            if (!MinimapRenderer.isRenderable(bs, (class_1922)world, p)) continue;
                            found = bs;
                            foundY = y;
                            break;
                        }
                    }
                    if (found == null) {
                        int yStart = Math.min(playerY + 8, world.method_31600());
                        int yEnd = Math.max(playerY - 64, world.method_31607());
                        for (int y = yStart; y >= yEnd; --y) {
                            class_2338 p = new class_2338(wx, y, wz);
                            class_2680 bs = world.method_8320(p);
                            if (!MinimapRenderer.isRenderable(bs, (class_1922)world, p)) continue;
                            found = bs;
                            foundY = y;
                            break;
                        }
                    }
                } else {
                    int yStart = Math.min(surfaceY + 4, world.method_31600());
                    int yEnd = Math.max(surfaceY - 64, world.method_31607());
                    for (int y = yStart; y >= yEnd; --y) {
                        class_2338 p = new class_2338(wx, y, wz);
                        bs = world.method_8320(p);
                        if (!MinimapRenderer.isRenderable(bs, (class_1922)world, p)) continue;
                        found = bs;
                        foundY = y;
                        break;
                    }
                }
                if (found == null) {
                    MinimapRenderer.setARGB(img, ix, iy, 0);
                    continue;
                }
                int argb = MinimapRenderer.colorForState((class_1937)world, new class_2338(wx, foundY, wz), found);
                MinimapRenderer.setARGB(img, ix, iy, argb);
            }
        }
        this.terrainTexture.method_4524();
    }

    private static boolean isRenderable(class_2680 bs, class_1922 view, class_2338 pos) {
        if (bs.method_26215()) {
            return false;
        }
        if (!bs.method_26227().method_15769()) {
            return true;
        }
        if (!bs.method_26220(view, pos).method_1110()) {
            return true;
        }
        return bs.method_26216(view, pos);
    }

    private void drawTerrainBase(class_332 ctx, int centerX, int centerY) {
        if (this.terrainTextureId == null) {
            return;
        }
        int d = 128;
        ctx.method_25290(this.terrainTextureId, centerX - 64, centerY - 64, 0.0f, 0.0f, d, d, 128, 128);
    }

    private void drawCompass(class_332 ctx, int centerX, int centerY, float yawDeg, boolean rotatePlayerUp) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        int radius = 54;
        int color = -1;
        float scale = 0.7f;
        String[] dirs = new String[]{"N", "E", "S", "W"};
        double[] angles = new double[]{0.0, 90.0, 180.0, 270.0};
        double yawRad = Math.toRadians(rotatePlayerUp ? (double)(-yawDeg) : 0.0);
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        for (int i = 0; i < dirs.length; ++i) {
            double baseRad = Math.toRadians(angles[i]);
            double ang = baseRad + yawRad;
            int px = (int)Math.round(Math.sin(ang) * 54.0);
            int py = (int)Math.round(-Math.cos(ang) * 54.0);
            String letter = dirs[i];
            int w = tr.method_1727(letter);
            Objects.requireNonNull(tr);
            int h = 9;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)px - (float)w / 2.0f, (float)py - (float)h / 2.0f, 0.0f);
            ctx.method_51448().method_22905(0.7f, 0.7f, 1.0f);
            ctx.method_51433(tr, letter, 0, 0, -1, true);
            ctx.method_51448().method_22909();
        }
        ctx.method_51448().method_22909();
    }

    private void drawRingOverlay(class_332 ctx, int centerX, int centerY) {
        int d = 128;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ctx.method_25290(FRAME_TEXTURE, centerX - 64, centerY - 64, 0.0f, 0.0f, d, d, d, d);
        RenderSystem.disableBlend();
    }

    private void drawClockTime(class_332 ctx, int centerX, int centerY) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        long timeOfDay = mc.field_1687.method_8532() % 24000L;
        int hours24 = (int)((timeOfDay / 1000L + 6L) % 24L);
        int minutes = (int)(timeOfDay % 1000L * 60L / 1000L);
        boolean pm = hours24 >= 12;
        int hours12 = hours24 % 12;
        if (hours12 == 0) {
            hours12 = 12;
        }
        String timeText = String.format("%d:%02d %s", hours12, minutes, pm ? "PM" : "AM");
        int textX = centerX + 32 - tr.method_1727(timeText) / 2;
        Objects.requireNonNull(tr);
        int textY = centerY + 32 - 9 / 2 + 22;
        ctx.method_51433(tr, timeText, textX, textY, -1, true);
    }

    private void drawRealWorldTime(class_332 ctx, int centerX, int centerY) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        LocalTime now = LocalTime.now();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("h:mm a");
        String realTime = now.format(fmt);
        int textX = centerX - 32 - tr.method_1727(realTime) / 2;
        Objects.requireNonNull(tr);
        int textY = centerY + 32 - 9 / 2 + 22;
        ctx.method_51433(tr, realTime, textX, textY, -1, true);
    }

    private void drawPlayerCoords(class_332 ctx, int centerX, int centerY) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_327 tr = mc.field_1772;
        int x = (int)mc.field_1724.method_23317();
        int y = (int)mc.field_1724.method_23318();
        int z = (int)mc.field_1724.method_23321();
        String coords = String.format("%d, %d, %d", x, y, z);
        int textX = centerX - 32 - tr.method_1727(coords) / 2 + 7;
        Objects.requireNonNull(tr);
        int textY = centerY - 32 - 9 - 18;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)textX, (float)textY, 0.0f);
        ctx.method_51448().method_22905(0.6f, 0.6f, 1.0f);
        ctx.method_51433(tr, coords, 0, 0, -1, true);
        ctx.method_51448().method_22909();
    }

    private void drawZoomBadge(class_332 ctx, int centerX, int centerY) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        String txt = String.format("%.1fx", MinimapConfig.pixelsPerBlock);
        double ang = Math.toRadians(42.0);
        int ringR = 64;
        int cx = centerX + (int)Math.round(Math.cos(ang) * (double)(ringR + 3));
        int cy = centerY - (int)Math.round(Math.sin(ang) * (double)(ringR + 3));
        MinimapRenderer.drawFilledCircle(ctx, cx, cy, 10, 0, 0, 0, 180);
        MinimapRenderer.drawCircle(ctx, cx, cy, 10, 255, 255, 255, 220, 2);
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)cx, (float)(cy + -3), 0.0f);
        ctx.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        int tw = tr.method_1727(txt);
        Objects.requireNonNull(tr);
        int th = 9;
        ctx.method_51433(tr, txt, -tw / 2, -th / 2, -1, false);
        ctx.method_51448().method_22909();
    }

    private static void drawCircle(class_332 ctx, int cx, int cy, int r, int cr, int cg, int cb, int ca, int thickness) {
        MinimapRenderer.drawDisk(ctx, cx, cy, r, ca << 24 | cr << 16 | cg << 8 | cb, true, 64);
        MinimapRenderer.drawDisk(ctx, cx, cy, r - thickness, 0, true, 64);
    }

    private static void drawFilledCircle(class_332 ctx, int cx, int cy, int r, int cr, int cg, int cb, int ca) {
        if (r <= 0) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = ctx.method_51448().method_23760().method_23761();
        class_289 tess = class_289.method_1348();
        class_287 buffer = tess.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        float a = (float)ca / 255.0f;
        float rf = (float)cr / 255.0f;
        float gf = (float)cg / 255.0f;
        float bf = (float)cb / 255.0f;
        buffer.method_22918(matrix, (float)cx, (float)cy, 0.0f).method_22915(rf, gf, bf, a);
        for (int i = 0; i <= 32; ++i) {
            double ang = Math.PI * 2 * (double)i / 32.0;
            float x = (float)cx + (float)(Math.cos(ang) * (double)r);
            float y = (float)cy + (float)(Math.sin(ang) * (double)r);
            buffer.method_22918(matrix, x, y, 0.0f).method_22915(rf, gf, bf, a);
        }
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static void drawDisk(class_332 ctx, int cx, int cy, int radius, int argb, boolean blend, int segments) {
        if (radius <= 0) {
            return;
        }
        Matrix4f m = ctx.method_51448().method_23760().method_23761();
        if (blend) {
            RenderSystem.enableBlend();
        }
        class_287 bb = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        bb.method_22918(m, (float)cx, (float)cy, 0.0f).method_22915(r, g, b, a);
        for (int i = 0; i <= segments; ++i) {
            double ang = Math.PI * 2 * ((double)i / (double)segments);
            float x = (float)cx + (float)(Math.cos(ang) * (double)radius);
            float y = (float)cy + (float)(Math.sin(ang) * (double)radius);
            bb.method_22918(m, x, y, 0.0f).method_22915(r, g, b, a);
        }
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)bb.method_60800());
        if (blend) {
            RenderSystem.disableBlend();
        }
    }

    private static void setARGB(class_1011 img, int x, int y, int argb) {
        int abgr = argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
        img.method_4305(x, y, abgr);
    }

    static {
        FRAME_TEXTURE = class_2960.method_60655((String)"roman-mod", (String)"textures/minimap/ring-w-clock.png");
    }

    @Environment(value=EnvType.CLIENT)
    public class WaypointAutoLoader {
        private static class_5321<class_1937> lastWorld;

        public WaypointAutoLoader(MinimapRenderer this$0) {
        }

        public static void register() {
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1687 == null) {
                    return;
                }
                if (lastWorld != client.field_1687.method_27983()) {
                    WaypointManager.loadForWorld(client.field_1687);
                    lastWorld = client.field_1687.method_27983();
                }
            });
        }
    }
}

