/*
 * Decompiled with CFR 0.152.
 */
package minimap;

import java.util.Arrays;
import java.util.List;
import minimap.WaypointToast;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class TeleportHelper {
    private static String detectedCommand = null;
    private static boolean tested = false;
    private static boolean toastShown = false;
    private static long lastTeleportTime = 0L;
    private static final List<String> TELEPORT_VARIANTS = Arrays.asList("teleport @s", "teleport", "tp", "tpa", "tppos", "tpl", "tpx", "ftbessentials:teleport");

    public static void teleportTo(int x, int y, int z, String waypointName) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1724.field_3944 == null) {
            return;
        }
        if (!tested) {
            TeleportHelper.detectCommand();
        }
        String baseCmd = detectedCommand != null ? detectedCommand : "teleport";
        String cmd = TeleportHelper.buildCommand(baseCmd, mc.field_1724.method_5477().getString(), x, y, z);
        try {
            class_634 net = mc.field_1724.field_3944;
            net.method_45730(cmd);
            lastTeleportTime = System.currentTimeMillis();
            WaypointToast.show("Teleport", "Teleporting to " + waypointName);
            mc.field_1724.method_18800(0.0, 0.0, 0.0);
            mc.field_1724.field_3913.field_3905 = 0.0f;
            mc.field_1724.field_3913.field_3907 = 0.0f;
            mc.field_1724.field_3913.field_3904 = false;
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    mc.execute(() -> {
                        if (mc.field_1724 != null) {
                            mc.field_1724.method_18800(0.0, 0.0, 0.0);
                            mc.field_1724.field_3913.field_3905 = 0.0f;
                            mc.field_1724.field_3913.field_3907 = 0.0f;
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            WaypointToast.show("Teleport Error", "Failed to send teleport command");
        }
    }

    private static String buildCommand(String base, String playerName, int x, int y, int z) {
        String coords = x + " " + y + " " + z;
        if (base.contains("@s")) {
            return base.replace("@s", "@s " + coords);
        }
        if (base.contains("tpa") || base.contains("tppos")) {
            return base + " " + coords;
        }
        if (base.contains("tpl") || base.contains("tpx") || base.contains("ftbessentials")) {
            return base + " " + playerName + " " + coords;
        }
        return base + " " + playerName + " " + coords;
    }

    private static void detectCommand() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1724.field_3944 == null) {
            return;
        }
        class_634 net = mc.field_1724.field_3944;
        tested = true;
        for (String variant : TELEPORT_VARIANTS) {
            try {
                net.method_45730(variant + " ~ ~ ~");
                detectedCommand = variant;
                System.out.println("[Minimap] \u2705 Detected working teleport command: " + variant);
                if (toastShown) break;
                toastShown = true;
                WaypointToast.show("Teleport Ready", "Detected command: /" + variant);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (detectedCommand == null) {
            detectedCommand = "teleport";
            System.out.println("[Minimap] \u26a0 No teleport command detected, using fallback: teleport");
            if (!toastShown) {
                toastShown = true;
                WaypointToast.show("Teleport Fallback", "Using default: /teleport");
            }
        }
    }

    public static void onServerMessage(class_2561 message) {
        if (message == null) {
            return;
        }
        String msg = message.getString().toLowerCase();
        if (msg.contains("unknown command") || msg.contains("did you mean")) {
            System.out.println("[Minimap] Server rejected teleport syntax: " + detectedCommand);
            detectedCommand = null;
            tested = false;
            toastShown = false;
            WaypointToast.show("Teleport Auto-Fix", "Retrying with next teleport command...");
        }
        if (msg.contains("teleported") || msg.contains("successfully")) {
            long delay = System.currentTimeMillis() - lastTeleportTime;
            System.out.println("[Minimap] Teleport confirmed after " + delay + "ms");
        }
    }
}

