/*
 * Decompiled with CFR 0.152.
 */
package minimap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import minimap.Waypoint;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class WaypointIO {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void save(List<Waypoint> waypoints, Writer writer) throws IOException {
        JsonArray array = new JsonArray();
        for (Waypoint w : waypoints) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", w.name);
            obj.addProperty("x", (Number)w.x);
            obj.addProperty("y", (Number)w.y);
            obj.addProperty("z", (Number)w.z);
            obj.addProperty("color", (Number)w.color);
            obj.addProperty("enabled", Boolean.valueOf(w.enabled));
            String dim = w.dimension != null ? w.dimension : "minecraft:overworld";
            obj.addProperty("dimension", dim);
            array.add((JsonElement)obj);
        }
        GSON.toJson((JsonElement)array, (Appendable)writer);
    }

    public static List<Waypoint> load(Reader reader) throws IOException {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        JsonElement root = JsonParser.parseReader((Reader)reader);
        if (root == null || !root.isJsonArray()) {
            return waypoints;
        }
        for (JsonElement e : root.getAsJsonArray()) {
            class_5321 worldKey;
            if (!e.isJsonObject()) continue;
            JsonObject obj = e.getAsJsonObject();
            String name = obj.has("name") ? obj.get("name").getAsString() : "Unnamed";
            int x = obj.has("x") ? obj.get("x").getAsInt() : 0;
            int y = obj.has("y") ? obj.get("y").getAsInt() : 64;
            int z = obj.has("z") ? obj.get("z").getAsInt() : 0;
            int color = obj.has("color") ? obj.get("color").getAsInt() : 0xFFFFFF;
            boolean enabled = obj.has("enabled") && obj.get("enabled").getAsBoolean();
            String dim = obj.has("dimension") ? obj.get("dimension").getAsString() : "minecraft:overworld";
            try {
                worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dim));
            }
            catch (Exception ex) {
                worldKey = class_1937.field_25179;
            }
            Waypoint w = new Waypoint(name, x, y, z, color, (class_5321<class_1937>)worldKey);
            w.enabled = enabled;
            w.dimension = dim;
            waypoints.add(w);
        }
        return waypoints;
    }

    public static List<Waypoint> loadFromFile(File file) {
        List<Waypoint> list;
        if (!file.exists()) {
            return new ArrayList<Waypoint>();
        }
        FileReader reader = new FileReader(file);
        try {
            list = WaypointIO.load(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<Waypoint>();
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public static void saveToFile(File file, List<Waypoint> waypoints) {
        try (FileWriter writer = new FileWriter(file);){
            WaypointIO.save(waypoints, writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

