/*
 * Decompiled with CFR 0.152.
 */
package minimap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minimap.Waypoint;
import minimap.WaypointIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class WaypointManager {
    private static final Map<class_5321<class_1937>, List<Waypoint>> WORLD_WAYPOINTS = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Waypoint> getForCurrentWorld() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return List.of();
        }
        class_5321 key = mc.field_1687.method_27983();
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            List<Waypoint> list = WORLD_WAYPOINTS.get(key);
            if (list == null) {
                list = WaypointManager.loadForWorld(mc.field_1687);
                WORLD_WAYPOINTS.put((class_5321<class_1937>)key, list);
            }
            return new ArrayList<Waypoint>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Waypoint> loadForWorld(class_638 world) {
        if (world == null) {
            return List.of();
        }
        class_5321 key = world.method_27983();
        List<Waypoint> loaded = WaypointManager.loadFromDisk(world);
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            WORLD_WAYPOINTS.put((class_5321<class_1937>)key, new ArrayList<Waypoint>(loaded));
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(class_638 world) {
        if (world == null) {
            return;
        }
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            WaypointManager.saveToDisk(world);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Waypoint w) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || w == null) {
            return;
        }
        class_5321 key = mc.field_1687.method_27983();
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            WORLD_WAYPOINTS.computeIfAbsent((class_5321<class_1937>)key, k -> new ArrayList()).add(w);
            WaypointManager.save(mc.field_1687);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Waypoint w) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || w == null) {
            return;
        }
        class_5321 key = mc.field_1687.method_27983();
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            List<Waypoint> list = WORLD_WAYPOINTS.get(key);
            if (list != null) {
                list.removeIf(existing -> existing.x == w.x && existing.y == w.y && existing.z == w.z);
                WaypointManager.save(mc.field_1687);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(Waypoint target, String newName) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || target == null || newName == null) {
            return;
        }
        class_5321 key = mc.field_1687.method_27983();
        Map<class_5321<class_1937>, List<Waypoint>> map = WORLD_WAYPOINTS;
        synchronized (map) {
            List<Waypoint> list = WORLD_WAYPOINTS.get(key);
            if (list != null) {
                for (Waypoint w : list) {
                    if (w.x != target.x || w.y != target.y || w.z != target.z) continue;
                    w.name = newName;
                    break;
                }
                WaypointManager.save(mc.field_1687);
            }
        }
    }

    private static File getWorldSaveFile(class_638 world) {
        class_310 mc = class_310.method_1551();
        String identifier = mc.method_1496() && mc.method_1576() != null ? mc.method_1576().method_27728().method_150().replaceAll("[^a-zA-Z0-9_\\-]", "_") : (mc.method_1558() != null ? mc.method_1558().field_3761.replaceAll("[:/\\\\]", "_") : "unknown_world");
        String dimension = world.method_27983().method_29177().method_12832().replace("/", "_");
        File dir = new File(mc.field_1697, "waypoints/" + identifier);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, dimension + ".json");
    }

    private static List<Waypoint> loadFromDisk(class_638 world) {
        List<Waypoint> list;
        File file = WaypointManager.getWorldSaveFile(world);
        if (!file.exists()) {
            return new ArrayList<Waypoint>();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            list = WaypointIO.load(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<Waypoint>();
            }
        }
        reader.close();
        return list;
    }

    private static void saveToDisk(class_638 world) {
        File file = WaypointManager.getWorldSaveFile(world);
        List<Waypoint> list = WORLD_WAYPOINTS.get(world.method_27983());
        if (list == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));){
            WaypointIO.save(list, writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

