/*
 * Decompiled with CFR 0.152.
 */
package minimap;

import java.util.List;
import minimap.TeleportHelper;
import minimap.Waypoint;
import minimap.WaypointManager;
import minimap.WaypointToast;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6379;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class WaypointScreen
extends class_437 {
    private WaypointList list;
    private class_4185 doneButton;
    private class_4185 newButton;

    public WaypointScreen() {
        super((class_2561)class_2561.method_43470((String)"Waypoints"));
    }

    protected void method_25426() {
        int w = this.field_22789;
        int h = this.field_22790;
        this.list = new WaypointList(this.field_22787, w, h - 60, 20, this.field_22790 - 40);
        this.refreshList();
        this.method_25429((class_364)this.list);
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> this.method_25419()).method_46434(w / 2 - 50, h - 30, 100, 20).method_46431();
        this.method_37063((class_364)this.doneButton);
        this.newButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add @ Player"), b -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null && mc.field_1687 != null) {
                class_2338 p = mc.field_1724.method_24515();
                class_5321 dim = mc.field_1687.method_27983();
                String name = "WP " + p.method_10263() + "," + p.method_10260();
                int rgb = 53503;
                WaypointManager.add(new Waypoint(name, p.method_10263(), p.method_10264(), p.method_10260(), rgb, (class_5321<class_1937>)dim));
                this.refreshList();
            }
        }).method_46434(10, h - 30, 120, 20).method_46431();
        this.method_37063((class_364)this.newButton);
    }

    private void refreshList() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            WaypointManager.loadForWorld(mc.field_1687);
        }
        this.list.wipe();
        for (Waypoint w : WaypointManager.getForCurrentWorld()) {
            this.list.addRow(new Entry(w, this));
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        int winW = (int)((double)this.field_22789 * 0.5);
        int winH = (int)((double)this.field_22790 * 0.5);
        int winX = (this.field_22789 - winW) / 2;
        int winY = (this.field_22790 - winH) / 2;
        ctx.method_25294(winX, winY, winX + winW, winY + winH, -14671840);
        ctx.method_49601(winX, winY, winW, winH, -1);
        ctx.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, winY + 8, 0xFFFFFF);
        if (this.list != null) {
            int listTop = winY + 28;
            int listBottom = winY + winH - 28;
            int listLeft = winX;
            int listWidth = winW;
            int listHeight = listBottom - listTop;
            this.list.method_46421(listLeft);
            this.list.method_46419(listTop);
            this.list.method_25358(listWidth);
            this.list.method_53533(listHeight);
            ctx.method_25294(listLeft - 2, listTop - 2, listLeft + listWidth + 2, listTop + listHeight + 2, 0x66000000);
            if (this.list.method_25322() <= 0) {
                this.list.setDimensions(winW - 20, winH - 60, winY + 28, winY + winH - 50);
            }
            ctx.method_44379(listLeft, listTop, listLeft + listWidth, listTop + listHeight + 4);
            this.list.method_25394(ctx, mouseX, mouseY, delta);
            ctx.method_44380();
        }
        if (this.newButton != null) {
            this.newButton.method_46421(winX + 10);
            this.newButton.method_46419(winY + winH - 25);
            this.newButton.method_25394(ctx, mouseX, mouseY, delta);
        }
        if (this.doneButton != null) {
            this.doneButton.method_46421(winX + winW - 110);
            this.doneButton.method_46419(winY + winH - 25);
            this.doneButton.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(null);
    }

    @Environment(value=EnvType.CLIENT)
    static class WaypointList
    extends class_4280<Entry> {
        private final int ENTRY_HEIGHT;
        private final class_310 mc;
        private static boolean DEBUG_MODE = false;

        public WaypointList(class_310 mc, int width, int height, int top, int bottom) {
            super(mc, width, height, top, bottom);
            this.mc = mc;
            int guiScale = (Integer)mc.field_1690.method_42474().method_41753();
            int base = 26;
            try {
                String apiVer = ((ModContainer)FabricLoader.getInstance().getModContainer("fabric-api").get()).getMetadata().getVersion().getFriendlyString();
                if (apiVer.startsWith("0.116")) {
                    base = 34;
                }
                this.ENTRY_HEIGHT = (int)Math.ceil((float)base * ((float)guiScale / 2.0f));
                System.out.println("[WaypointList] Fabric API " + apiVer + " | GUI scale " + guiScale + " | ENTRY_HEIGHT " + this.ENTRY_HEIGHT);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setDimensions(width, height, top, bottom);
        }

        public void setDimensions(int width, int height, int top, int bottom) {
            this.method_46419(top);
            this.method_25358(width);
            this.method_53533(height);
            this.method_25307(0.0);
        }

        protected int getRowHeight() {
            return this.ENTRY_HEIGHT;
        }

        protected int method_25337(int index) {
            return this.method_46427() + index * this.getRowHeight();
        }

        protected int method_25319(int index) {
            return this.method_25337(index) + this.getRowHeight();
        }

        protected void method_25311(class_332 ctx, int mouseX, int mouseY, float delta) {
            int itemCount = this.method_25396().size();
            double scroll = this.method_25341();
            int rowLeft = this.method_46426();
            int rowWidth = this.method_25322();
            for (int i = 0; i < itemCount; ++i) {
                int rowHeight;
                int rowTop = this.method_25337(i) - (int)scroll;
                int rowBottom = rowTop + (rowHeight = this.getRowHeight());
                if (rowBottom < this.method_46427() || rowTop > this.method_55443()) continue;
                if (this.method_25334() == this.method_25396().get(i)) {
                    ctx.method_25294(rowLeft + 1, rowTop + 1, rowLeft + rowWidth - 1, rowBottom - 1, -2130706433);
                }
                ((Entry)((Object)this.method_25396().get(i))).method_25343(ctx, i, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY), delta);
            }
            this.renderScrollBar(ctx);
        }

        private void renderScrollBar(class_332 ctx) {
            if (this.method_25331() <= 0) {
                return;
            }
            int scrollbarX = this.getScrollbarPositionX();
            int scrollbarY = this.method_46427();
            int scrollbarHeight = this.method_55443() - this.method_46427();
            int thumbHeight = (int)((float)scrollbarHeight * ((float)scrollbarHeight / (float)this.method_25317()));
            thumbHeight = class_3532.method_15340((int)thumbHeight, (int)32, (int)(scrollbarHeight - 8));
            int thumbY = (int)this.method_25341() * (scrollbarHeight - thumbHeight) / this.method_25331();
            ctx.method_25294(scrollbarX, scrollbarY + thumbY, scrollbarX + 6, scrollbarY + thumbY + thumbHeight, -2130706433);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            Entry entry;
            if (button == 0 && class_437.method_25442()) {
                DEBUG_MODE = !DEBUG_MODE;
                class_310 mc = class_310.method_1551();
                mc.method_1566().method_1999((class_368)class_370.method_29047((class_310)mc, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"Waypoint Debug Mode"), (class_2561)class_2561.method_43470((String)(DEBUG_MODE ? "Enabled" : "Disabled"))));
                System.out.println("[WaypointList] DEBUG MODE = " + DEBUG_MODE);
                return true;
            }
            double relY = mouseY - (double)this.method_46427();
            int index = (int)((relY + this.method_25341()) / (double)this.getRowHeight());
            if (index >= 0 && index < this.method_25396().size() && (entry = (Entry)((Object)this.method_25396().get(index))).method_25402(mouseX, mouseY, button)) {
                this.method_25313((class_350.class_351)entry);
                this.method_25354(class_310.method_1551().method_1483());
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public int method_25322() {
            return this.field_22758 - 10;
        }

        protected int getScrollbarPositionX() {
            return this.method_46426() + this.field_22758 - 6;
        }

        public void wipe() {
            this.method_25339();
        }

        public void addRow(Entry e) {
            this.method_25321((class_350.class_351)e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Entry
    extends class_4280.class_4281<Entry> {
        private final Waypoint w;
        private final WaypointScreen screen;
        private final class_4286 enabled;
        private final class_4185 renameBtn;
        private final class_4185 deleteBtn;
        private long lastClickTime = 0L;

        Entry(Waypoint w, WaypointScreen screen) {
            this.w = w;
            this.screen = screen;
            this.enabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)screen.field_22793).method_54794(w.enabled).method_54791((cb, checked) -> {
                w.enabled = checked;
                if (class_310.method_1551().field_1687 != null) {
                    String msg = checked ? "Visible on Minimap" : "Hidden on Minimap";
                    WaypointToast.show("Waypoint Updated", w.name + " " + msg);
                    WaypointManager.save(class_310.method_1551().field_1687);
                }
            }).method_54788();
            this.renameBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u270e"), b -> this.openRename()).method_46434(0, 0, 20, 20).method_46431();
            this.deleteBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2716"), b -> {
                class_310 mc = class_310.method_1551();
                class_638 world = mc.field_1687;
                if (world == null) {
                    return;
                }
                Class<WaypointManager> clazz = WaypointManager.class;
                synchronized (WaypointManager.class) {
                    WaypointManager.remove(w);
                    WaypointManager.save(world);
                    WaypointManager.loadForWorld(world);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    screen.refreshList();
                    mc.method_1566().method_1999((class_368)class_370.method_29047((class_310)mc, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"Waypoint Deleted"), (class_2561)class_2561.method_43470((String)(w.name + " removed"))));
                    return;
                }
            }).method_46434(0, 0, 20, 20).method_46431();
        }

        private void openRename() {
            this.screen.field_22787.method_1507((class_437)new RenameScreen(this.screen, this.w));
        }

        public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 tr = this.screen.field_22793;
            int left = x;
            int right = x + entryWidth - 8;
            int textLeft = left + 22;
            int col = this.w.color | 0xFF000000;
            ctx.method_25294(left, y + 6, left + 14, y + 20, col);
            ctx.method_49601(left, y + 6, 14, 14, -16777216);
            String name = this.w.name;
            String coords = "(" + this.w.x + ", " + this.w.y + ", " + this.w.z + ")";
            ctx.method_51433(tr, name, textLeft, y + 6, 0xFFFFFF, false);
            ctx.method_51433(tr, coords, textLeft, y + 16, 0xAAAAAA, false);
            this.enabled.method_48229(left + 2, y + 2);
            this.enabled.method_25394(ctx, mouseX, mouseY, tickDelta);
            this.deleteBtn.method_48229(right - 20, y + 3);
            this.renameBtn.method_48229(right - 40, y + 3);
            this.deleteBtn.method_25394(ctx, mouseX, mouseY, tickDelta);
            this.renameBtn.method_25394(ctx, mouseX, mouseY, tickDelta);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_310 mc = class_310.method_1551();
            if (this.enabled.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.renameBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.deleteBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 300L && mc.field_1724 != null && mc.field_1687 != null) {
                boolean singleplayer = mc.method_1496();
                boolean creative = mc.field_1724.method_31549().field_7477;
                double tx = (double)this.w.x + 0.5;
                double ty = (double)this.w.y + 1.0;
                double tz = (double)this.w.z + 0.5;
                String wpName = this.w.name;
                mc.execute(() -> {
                    if (singleplayer || creative) {
                        if (mc.method_1496() && mc.method_1576() != null) {
                            class_3222 serverPlayer = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667());
                            if (serverPlayer != null) {
                                class_3218 serverWorld = (class_3218)serverPlayer.method_37908();
                                serverWorld.method_14178().method_12246((int)tx >> 4, (int)tz >> 4);
                                serverPlayer.method_14251(serverWorld, tx, ty, tz, serverPlayer.method_36454(), serverPlayer.method_36455());
                                WaypointToast.show("Teleported", "Arrived at " + wpName);
                                mc.method_1507(null);
                            }
                        } else {
                            mc.field_1724.method_30634(tx, ty, tz);
                            WaypointToast.show("Teleported", "Arrived at " + wpName);
                            mc.method_1507(null);
                        }
                    } else {
                        TeleportHelper.teleportTo((int)tx, (int)ty, (int)tz, wpName);
                    }
                });
            }
            this.lastClickTime = currentTime;
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            this.enabled.method_25406(mouseX, mouseY, button);
            this.renameBtn.method_25406(mouseX, mouseY, button);
            this.deleteBtn.method_25406(mouseX, mouseY, button);
            return false;
        }

        public List<? extends class_6379> getSelectableChildren() {
            return List.of(this.enabled, this.renameBtn, this.deleteBtn);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)("Waypoint " + this.w.name));
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class RenameScreen
    extends class_437 {
        private final WaypointScreen parent;
        private final Waypoint w;
        private class_342 field;
        private class_4185 ok;
        private class_4185 cancel;

        RenameScreen(WaypointScreen parent, Waypoint w) {
            super((class_2561)class_2561.method_43470((String)"Rename Waypoint"));
            this.parent = parent;
            this.w = w;
        }

        protected void method_25426() {
            int wWidth = 220;
            this.field = new class_342(this.field_22793, this.field_22789 / 2 - wWidth / 2, this.field_22790 / 2 - 30, wWidth, 20, (class_2561)class_2561.method_43470((String)""));
            this.field.method_1852(this.w.name);
            this.method_25429((class_364)this.field);
            this.method_48265((class_364)this.field);
            this.ok = class_4185.method_46430((class_2561)class_2561.method_43470((String)"OK"), b -> {
                String newName = this.field.method_1882().trim();
                if (newName.isEmpty()) {
                    return;
                }
                class_638 world = class_310.method_1551().field_1687;
                if (world != null) {
                    WaypointManager.rename(this.w, newName);
                    this.parent.refreshList();
                    class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"Waypoint Renamed"), (class_2561)class_2561.method_43470((String)("Renamed to " + newName))));
                }
                class_310.method_1551().execute(() -> this.field_22787.method_1507((class_437)this.parent));
            }).method_46434(this.field_22789 / 2 - 60, this.field_22790 / 2 + 2, 54, 20).method_46431();
            this.cancel = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507((class_437)this.parent)).method_46434(this.field_22789 / 2 + 6, this.field_22790 / 2 + 2, 54, 20).method_46431();
            this.method_37063((class_364)this.ok);
            this.method_37063((class_364)this.cancel);
            if (class_310.method_1551().field_1687 != null) {
                WaypointManager.loadForWorld(class_310.method_1551().field_1687);
            }
        }

        public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
            this.method_25420(ctx, mouseX, mouseY, delta);
            ctx.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, this.field_22790 / 2 - 60, 0xFFFFFF);
            super.method_25394(ctx, mouseX, mouseY, delta);
            this.field.method_25394(ctx, mouseX, mouseY, delta);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 || keyCode == 335) {
                this.ok.method_25306();
                return true;
            }
            if (keyCode == 256) {
                this.field_22787.method_1507((class_437)this.parent);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
    }
}

