/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.client;

import java.util.HashMap;
import java.util.Map;
import net.memeland.bsf.client.model.SnowyDirtBakedModel;
import net.memeland.bsf.client.model.SnowyFoliageBakedModel;
import net.memeland.bsf.client.model.SnowyGrassBakedModel;
import net.memeland.bsf.client.model.SnowyPlantBakedModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bsf", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    private static final ResourceLocation CUSTOM_SNOWY_GRASS_MODEL = new ResourceLocation("bsf", "block/snowy_grass_block");
    private static final ResourceLocation CUSTOM_SNOWY_DIRT_MODEL = new ResourceLocation("bsf", "block/snowy_dirt");
    private static final Map<String, ResourceLocation> SNOWY_FOLIAGE_MODELS = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> SNOWY_VINE_MODELS = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> SNOWY_PLANT_TEXTURE_MODELS = new HashMap<String, ResourceLocation>();
    private static final Map<String, Map<Integer, ResourceLocation>> SNOWY_PLANT_VARIANT_MODELS = new HashMap<String, Map<Integer, ResourceLocation>>();
    private static final Map<String, Map<String, ResourceLocation>> SNOWY_TALL_PLANT_TEXTURE_MODELS = new HashMap<String, Map<String, ResourceLocation>>();
    private static final Map<String, Map<String, Map<Integer, ResourceLocation>>> SNOWY_TALL_PLANT_VARIANT_MODELS = new HashMap<String, Map<String, Map<Integer, ResourceLocation>>>();

    private static void setupPlantModels(String plantName) {
        SNOWY_PLANT_TEXTURE_MODELS.put(plantName, new ResourceLocation("bsf", "block/snowy_" + plantName));
        HashMap<Integer, ResourceLocation> variants = new HashMap<Integer, ResourceLocation>();
        for (int i = 0; i < 11; ++i) {
            variants.put(i, new ResourceLocation("bsf", "block/" + plantName + "_with_snow_variant_" + i));
        }
        SNOWY_PLANT_VARIANT_MODELS.put(plantName, variants);
    }

    private static void setupTallPlantModels(String plantName) {
        HashMap<String, ResourceLocation> textureModels = new HashMap<String, ResourceLocation>();
        textureModels.put("upper", new ResourceLocation("bsf", "block/snowy_" + plantName + "_top"));
        textureModels.put("lower", new ResourceLocation("bsf", "block/snowy_" + plantName + "_bottom"));
        SNOWY_TALL_PLANT_TEXTURE_MODELS.put(plantName, textureModels);
        HashMap allVariants = new HashMap();
        for (String half : new String[]{"upper", "lower"}) {
            HashMap<Integer, ResourceLocation> variants = new HashMap<Integer, ResourceLocation>();
            for (int i = 0; i < 11; ++i) {
                variants.put(i, new ResourceLocation("bsf", "block/" + plantName + "_" + half + "_with_snow_variant_" + i));
            }
            allVariants.put(half, variants);
        }
        SNOWY_TALL_PLANT_VARIANT_MODELS.put(plantName, allVariants);
    }

    @SubscribeEvent
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        event.register(CUSTOM_SNOWY_GRASS_MODEL);
        event.register(CUSTOM_SNOWY_DIRT_MODEL);
        for (ResourceLocation resourceLocation : SNOWY_FOLIAGE_MODELS.values()) {
            event.register(resourceLocation);
        }
        for (ResourceLocation resourceLocation : SNOWY_VINE_MODELS.values()) {
            event.register(resourceLocation);
        }
        for (ResourceLocation resourceLocation : SNOWY_PLANT_TEXTURE_MODELS.values()) {
            event.register(resourceLocation);
        }
        for (Map map : SNOWY_PLANT_VARIANT_MODELS.values()) {
            for (ResourceLocation model : map.values()) {
                event.register(model);
            }
        }
        for (Map map : SNOWY_TALL_PLANT_TEXTURE_MODELS.values()) {
            for (ResourceLocation model : map.values()) {
                event.register(model);
            }
        }
        for (Map map : SNOWY_TALL_PLANT_VARIANT_MODELS.values()) {
            for (Map variants : map.values()) {
                for (ResourceLocation model : variants.values()) {
                    event.register(model);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ClientEventHandler.replaceGrassBlockModel(modelRegistry);
        ClientEventHandler.replaceDirtBlockModel(modelRegistry);
        ClientEventHandler.replaceFoliageModels(modelRegistry);
        ClientEventHandler.replaceVineModels(modelRegistry);
        ClientEventHandler.replacePlantModels(modelRegistry);
        ClientEventHandler.replaceTallPlantModels(modelRegistry);
    }

    private static void replaceGrassBlockModel(Map<ResourceLocation, BakedModel> modelRegistry) {
        ResourceLocation grassBlockId = new ResourceLocation("minecraft", "grass_block");
        ModelResourceLocation normalGrassModel = new ModelResourceLocation(grassBlockId, "snowy=false");
        BakedModel originalNormal = modelRegistry.get(normalGrassModel);
        BakedModel customSnowy = modelRegistry.get(CUSTOM_SNOWY_GRASS_MODEL);
        if (originalNormal != null && customSnowy != null) {
            SnowyGrassBakedModel customModel = new SnowyGrassBakedModel(originalNormal, customSnowy);
            modelRegistry.put((ResourceLocation)normalGrassModel, customModel);
        }
    }

    private static void replaceDirtBlockModel(Map<ResourceLocation, BakedModel> modelRegistry) {
        ResourceLocation dirtBlockId = new ResourceLocation("minecraft", "dirt");
        BakedModel customSnowy = modelRegistry.get(CUSTOM_SNOWY_DIRT_MODEL);
        if (customSnowy == null) {
            return;
        }
        for (Map.Entry<ResourceLocation, BakedModel> entry : modelRegistry.entrySet()) {
            ModelResourceLocation mrl;
            ResourceLocation key = entry.getKey();
            if (!(key instanceof ModelResourceLocation) || !(mrl = (ModelResourceLocation)key).m_135827_().equals("minecraft") || !mrl.m_135815_().equals("dirt")) continue;
            BakedModel originalModel = entry.getValue();
            SnowyDirtBakedModel customModel = new SnowyDirtBakedModel(originalModel, customSnowy);
            modelRegistry.put(key, customModel);
        }
    }

    private static void replaceFoliageModels(Map<ResourceLocation, BakedModel> modelRegistry) {
        for (Map.Entry<String, ResourceLocation> entry : SNOWY_FOLIAGE_MODELS.entrySet()) {
            String blockName = entry.getKey();
            ResourceLocation customModelLocation = entry.getValue();
            ClientEventHandler.replaceFoliageBlock(modelRegistry, blockName, customModelLocation);
        }
    }

    private static void replaceFoliageBlock(Map<ResourceLocation, BakedModel> modelRegistry, String blockName, ResourceLocation customModelLocation) {
        BakedModel customSnowy = modelRegistry.get(customModelLocation);
        if (customSnowy == null) {
            return;
        }
        for (Map.Entry<ResourceLocation, BakedModel> entry : modelRegistry.entrySet()) {
            ModelResourceLocation mrl;
            ResourceLocation key = entry.getKey();
            if (!(key instanceof ModelResourceLocation) || !(mrl = (ModelResourceLocation)key).m_135827_().equals("minecraft") || !mrl.m_135815_().equals(blockName)) continue;
            BakedModel originalModel = entry.getValue();
            SnowyFoliageBakedModel customModel = new SnowyFoliageBakedModel(originalModel, customSnowy);
            modelRegistry.put(key, customModel);
        }
    }

    private static void replaceVineModels(Map<ResourceLocation, BakedModel> modelRegistry) {
        HashMap<String, BakedModel> snowyVineModels = new HashMap<String, BakedModel>();
        for (Map.Entry<String, ResourceLocation> entry : SNOWY_VINE_MODELS.entrySet()) {
            BakedModel model = modelRegistry.get(entry.getValue());
            if (model == null) continue;
            snowyVineModels.put(entry.getKey(), model);
        }
        if (snowyVineModels.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ResourceLocation> entry : modelRegistry.entrySet()) {
            ModelResourceLocation mrl;
            ResourceLocation key = (ResourceLocation)entry.getKey();
            if (!(key instanceof ModelResourceLocation) || !(mrl = (ModelResourceLocation)key).m_135827_().equals("minecraft") || !mrl.m_135815_().equals("vine")) continue;
            String variant = mrl.m_119448_();
            BakedModel originalModel = (BakedModel)entry.getValue();
            BakedModel snowyModel = null;
            if (variant.contains("north=true")) {
                snowyModel = (BakedModel)snowyVineModels.get("north");
            } else if (variant.contains("south=true")) {
                snowyModel = (BakedModel)snowyVineModels.get("south");
            } else if (variant.contains("east=true")) {
                snowyModel = (BakedModel)snowyVineModels.get("east");
            } else if (variant.contains("west=true")) {
                snowyModel = (BakedModel)snowyVineModels.get("west");
            } else if (variant.contains("up=true")) {
                snowyModel = (BakedModel)snowyVineModels.get("up");
            }
            if (snowyModel == null) continue;
            SnowyFoliageBakedModel customModel = new SnowyFoliageBakedModel(originalModel, snowyModel);
            modelRegistry.put(key, customModel);
        }
    }

    private static void replacePlantModels(Map<ResourceLocation, BakedModel> modelRegistry) {
        for (String plantName : SNOWY_PLANT_TEXTURE_MODELS.keySet()) {
            ResourceLocation textureModelLoc = SNOWY_PLANT_TEXTURE_MODELS.get(plantName);
            Map<Integer, ResourceLocation> variantLocs = SNOWY_PLANT_VARIANT_MODELS.get(plantName);
            BakedModel snowyTextureModel = modelRegistry.get(textureModelLoc);
            if (snowyTextureModel == null) continue;
            HashMap<Integer, BakedModel> variantModels = new HashMap<Integer, BakedModel>();
            for (Map.Entry<Integer, ResourceLocation> entry : variantLocs.entrySet()) {
                BakedModel variantModel = modelRegistry.get(entry.getValue());
                if (variantModel == null) continue;
                variantModels.put(entry.getKey(), variantModel);
            }
            for (Map.Entry<Integer, ResourceLocation> entry : modelRegistry.entrySet()) {
                ModelResourceLocation mrl;
                ResourceLocation key = (ResourceLocation)entry.getKey();
                if (!(key instanceof ModelResourceLocation) || !(mrl = (ModelResourceLocation)key).m_135827_().equals("minecraft") || !mrl.m_135815_().equals(plantName)) continue;
                BakedModel originalModel = (BakedModel)entry.getValue();
                SnowyPlantBakedModel customModel = new SnowyPlantBakedModel(originalModel, snowyTextureModel, variantModels);
                modelRegistry.put(key, customModel);
            }
        }
    }

    private static void replaceTallPlantModels(Map<ResourceLocation, BakedModel> modelRegistry) {
        for (String blockName : SNOWY_TALL_PLANT_TEXTURE_MODELS.keySet()) {
            BakedModel model;
            Map<String, ResourceLocation> textureModelLocs = SNOWY_TALL_PLANT_TEXTURE_MODELS.get(blockName);
            Map<String, Map<Integer, ResourceLocation>> variantLocs = SNOWY_TALL_PLANT_VARIANT_MODELS.get(blockName);
            BakedModel upperTextureModel = modelRegistry.get(textureModelLocs.get("upper"));
            BakedModel lowerTextureModel = modelRegistry.get(textureModelLocs.get("lower"));
            if (upperTextureModel == null || lowerTextureModel == null) continue;
            HashMap<Integer, BakedModel> upperVariants = new HashMap<Integer, BakedModel>();
            HashMap<Integer, BakedModel> lowerVariants = new HashMap<Integer, BakedModel>();
            for (Map.Entry<Integer, ResourceLocation> entry : variantLocs.get("upper").entrySet()) {
                model = modelRegistry.get(entry.getValue());
                if (model == null) continue;
                upperVariants.put(entry.getKey(), model);
            }
            for (Map.Entry<Integer, ResourceLocation> entry : variantLocs.get("lower").entrySet()) {
                model = modelRegistry.get(entry.getValue());
                if (model == null) continue;
                lowerVariants.put(entry.getKey(), model);
            }
            for (Map.Entry<Integer, ResourceLocation> entry : modelRegistry.entrySet()) {
                SnowyPlantBakedModel customModel;
                ModelResourceLocation mrl;
                ResourceLocation key = (ResourceLocation)entry.getKey();
                if (!(key instanceof ModelResourceLocation) || !(mrl = (ModelResourceLocation)key).m_135827_().equals("minecraft") || !mrl.m_135815_().equals(blockName)) continue;
                String variant = mrl.m_119448_();
                BakedModel originalModel = (BakedModel)entry.getValue();
                if (variant.contains("half=upper")) {
                    customModel = new SnowyPlantBakedModel(originalModel, upperTextureModel, upperVariants);
                    modelRegistry.put(key, customModel);
                    continue;
                }
                if (!variant.contains("half=lower")) continue;
                customModel = new SnowyPlantBakedModel(originalModel, lowerTextureModel, lowerVariants);
                modelRegistry.put(key, customModel);
            }
        }
    }

    static {
        SNOWY_FOLIAGE_MODELS.put("spruce_leaves", new ResourceLocation("bsf", "block/snowy_spruce_leaves"));
        SNOWY_FOLIAGE_MODELS.put("oak_leaves", new ResourceLocation("bsf", "block/snowy_oak_leaves"));
        SNOWY_FOLIAGE_MODELS.put("birch_leaves", new ResourceLocation("bsf", "block/snowy_birch_leaves"));
        SNOWY_FOLIAGE_MODELS.put("jungle_leaves", new ResourceLocation("bsf", "block/snowy_jungle_leaves"));
        SNOWY_FOLIAGE_MODELS.put("acacia_leaves", new ResourceLocation("bsf", "block/snowy_acacia_leaves"));
        SNOWY_FOLIAGE_MODELS.put("dark_oak_leaves", new ResourceLocation("bsf", "block/snowy_dark_oak_leaves"));
        SNOWY_FOLIAGE_MODELS.put("mangrove_leaves", new ResourceLocation("bsf", "block/snowy_mangrove_leaves"));
        SNOWY_FOLIAGE_MODELS.put("cherry_leaves", new ResourceLocation("bsf", "block/snowy_cherry_leaves"));
        SNOWY_FOLIAGE_MODELS.put("azalea_leaves", new ResourceLocation("bsf", "block/snowy_azalea_leaves"));
        SNOWY_FOLIAGE_MODELS.put("flowering_azalea_leaves", new ResourceLocation("bsf", "block/snowy_flowering_azalea_leaves"));
        SNOWY_VINE_MODELS.put("north", new ResourceLocation("bsf", "block/snowy_vine"));
        SNOWY_VINE_MODELS.put("south", new ResourceLocation("bsf", "block/snowy_vine_n"));
        SNOWY_VINE_MODELS.put("east", new ResourceLocation("bsf", "block/snowy_vine_w"));
        SNOWY_VINE_MODELS.put("west", new ResourceLocation("bsf", "block/snowy_vine_e"));
        SNOWY_VINE_MODELS.put("up", new ResourceLocation("bsf", "block/snowy_vine_u"));
        ClientEventHandler.setupPlantModels("grass");
        ClientEventHandler.setupPlantModels("fern");
        ClientEventHandler.setupTallPlantModels("tall_grass");
        ClientEventHandler.setupTallPlantModels("large_fern");
    }
}

