/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.client.model;

import java.util.List;
import net.memeland.bsf.util.BiomeTemperatureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class SnowyDirtBakedModel
implements BakedModel {
    public static final ModelProperty<BlockAndTintGetter> LEVEL_PROPERTY = new ModelProperty();
    public static final ModelProperty<BlockPos> POS_PROPERTY = new ModelProperty();
    public static final ModelProperty<Boolean> IS_SNOW_BLOCK_BIOME_PROPERTY = new ModelProperty();
    public static final ModelProperty<Integer> ROTATION_PROPERTY = new ModelProperty();
    private final BakedModel normalModel;
    private final BakedModel snowyModel;

    public SnowyDirtBakedModel(BakedModel normalModel, BakedModel snowyModel) {
        this.normalModel = normalModel;
        this.snowyModel = snowyModel;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        return this.normalModel.m_213637_(state, direction, random);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData extraData, @Nullable RenderType renderType) {
        Boolean isSnowBlockBiome = (Boolean)extraData.get(IS_SNOW_BLOCK_BIOME_PROPERTY);
        Integer rotation = (Integer)extraData.get(ROTATION_PROPERTY);
        if (isSnowBlockBiome != null && isSnowBlockBiome.booleanValue()) {
            if (rotation != null && direction == Direction.UP) {
                RandomSource rotationRandom = RandomSource.m_216335_((long)rotation.intValue());
                return this.snowyModel.getQuads(state, direction, rotationRandom, extraData, renderType);
            }
            return this.snowyModel.getQuads(state, direction, random, extraData, renderType);
        }
        return this.normalModel.getQuads(state, direction, random, extraData, renderType);
    }

    public boolean m_7541_() {
        return this.normalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.normalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.normalModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.normalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.normalModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.normalModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.normalModel.m_7343_();
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        boolean isSnowBlockBiome = false;
        int rotation = 0;
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && pos != null) {
                isSnowBlockBiome = BiomeTemperatureHelper.isSnowBlockBiome((LevelReader)mc.f_91073_, pos);
                rotation = pos.m_123341_() * 3 + pos.m_123342_() * 5 + pos.m_123343_() * 7 & 0xFFFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelData.derive().with(LEVEL_PROPERTY, (Object)level).with(POS_PROPERTY, (Object)pos).with(IS_SNOW_BLOCK_BIOME_PROPERTY, (Object)isSnowBlockBiome).with(ROTATION_PROPERTY, (Object)rotation).build();
    }
}

