/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.client.model;

import java.util.List;
import java.util.Map;
import net.memeland.bsf.ModConfig;
import net.memeland.bsf.util.BiomeTemperatureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class SnowyPlantBakedModel
implements BakedModel {
    public static final ModelProperty<Integer> VARIANT_INDEX = new ModelProperty();
    private static final int REQUIRED_SNOW_NEIGHBORS = 2;
    private static final int NUM_VARIANTS = 11;
    private final BakedModel normalModel;
    private final BakedModel snowyTextureModel;
    private final Map<Integer, BakedModel> snowVariantModels;

    public SnowyPlantBakedModel(BakedModel normalModel, BakedModel snowyTextureModel, Map<Integer, BakedModel> snowVariantModels) {
        this.normalModel = normalModel;
        this.snowyTextureModel = snowyTextureModel;
        this.snowVariantModels = snowVariantModels;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        return this.normalModel.m_213637_(state, direction, random);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData extraData, @Nullable RenderType renderType) {
        Integer variantIndex = (Integer)extraData.get(VARIANT_INDEX);
        if (variantIndex != null && variantIndex >= 0 && this.snowVariantModels.containsKey(variantIndex)) {
            return this.snowVariantModels.get(variantIndex).getQuads(state, direction, random, extraData, renderType);
        }
        if (variantIndex != null && variantIndex == -1) {
            return this.snowyTextureModel.getQuads(state, direction, random, extraData, renderType);
        }
        return this.normalModel.getQuads(state, direction, random, extraData, renderType);
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        int variantIndex = -2;
        if (!((Boolean)ModConfig.ENABLE_SNOWY_PLANTS.get()).booleanValue()) {
            return modelData.derive().with(VARIANT_INDEX, (Object)variantIndex).build();
        }
        try {
            boolean isCold;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && pos != null && level != null && (isCold = BiomeTemperatureHelper.isColdAt((LevelReader)mc.f_91073_, pos))) {
                if (SnowyPlantBakedModel.hasEnoughSnowNeighbors(level, pos, state)) {
                    long seed = (long)pos.m_123341_() << 32 | (long)pos.m_123343_() & 0xFFFFFFFFL;
                    RandomSource random = RandomSource.m_216335_((long)seed);
                    variantIndex = random.m_188503_(11);
                } else {
                    variantIndex = -1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelData.derive().with(VARIANT_INDEX, (Object)variantIndex).build();
    }

    private static boolean hasEnoughSnowNeighbors(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        Direction[] directions;
        BlockPos checkPos = pos;
        if (state != null && state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            checkPos = pos.m_7495_();
        }
        int snowCount = 0;
        for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            if (!SnowyPlantBakedModel.hasSnowAdjacent(level, checkPos, direction) || ++snowCount < 2) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSnowAdjacent(BlockAndTintGetter level, BlockPos plantPos, Direction direction) {
        BlockPos checkPos = plantPos.m_121945_(direction);
        int plantChunkX = plantPos.m_123341_() >> 4;
        int plantChunkZ = plantPos.m_123343_() >> 4;
        int checkChunkX = checkPos.m_123341_() >> 4;
        int checkChunkZ = checkPos.m_123343_() >> 4;
        if (plantChunkX != checkChunkX || plantChunkZ != checkChunkZ) {
            return false;
        }
        if (!SnowyPlantBakedModel.isChunkLoaded(level, checkPos)) {
            return false;
        }
        try {
            BlockState checkState = level.m_8055_(checkPos);
            return checkState.m_204336_(BlockTags.f_144279_);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isChunkLoaded(BlockAndTintGetter level, BlockPos pos) {
        try {
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                ChunkAccess chunk = clientLevel.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
                return chunk != null;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean m_7541_() {
        return this.normalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.normalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.normalModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.normalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.normalModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.normalModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.normalModel.m_7343_();
    }
}

