/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.mixin;

import net.memeland.bsf.ModConfig;
import net.memeland.bsf.util.BiomeTemperatureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BushBlockOffsetMixin {
    @Shadow
    public abstract Block m_60734_();

    @Shadow
    public abstract BlockState m_7160_();

    @Inject(method={"getOffset"}, at={@At(value="HEAD")}, cancellable=true)
    public void bsf$disableOffsetForSnowyPlants(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Vec3> cir) {
        if (!(this.m_60734_() instanceof BushBlock)) {
            return;
        }
        if (!((Boolean)ModConfig.ENABLE_SNOWY_PLANTS.get()).booleanValue()) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && BiomeTemperatureHelper.isColdAt((LevelReader)mc.f_91073_, pos) && BushBlockOffsetMixin.hasEnoughSnowNeighbors(level, pos, this.m_7160_())) {
                cir.setReturnValue((Object)Vec3.f_82478_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasEnoughSnowNeighbors(BlockGetter level, BlockPos pos, BlockState state) {
        Direction[] directions;
        BlockPos checkPos = pos;
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            checkPos = pos.m_7495_();
        }
        int snowCount = 0;
        for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            BlockPos adjacentPos = checkPos.m_121945_(direction);
            try {
                BlockState adjacentState = level.m_8055_(adjacentPos);
                if (!adjacentState.m_204336_(BlockTags.f_144279_) || ++snowCount < 2) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

