/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.util;

import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import net.memeland.bsf.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;

public class BiomeTemperatureHelper {
    private static final Long2BooleanMap chunkCache = new Long2BooleanOpenHashMap();
    private static final Long2BooleanMap snowBlockChunkCache = new Long2BooleanOpenHashMap();
    private static final int MAX_CACHE_SIZE = 2048;

    public static boolean isColdAt(LevelReader level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        long chunkKey = BiomeTemperatureHelper.getChunkKey(pos);
        if (chunkCache.containsKey(chunkKey)) {
            return chunkCache.get(chunkKey);
        }
        Holder biomeHolder = level.m_204166_(pos);
        boolean isCold = biomeHolder.m_203656_(ModTags.Biomes.SNOWY_BIOMES);
        BiomeTemperatureHelper.cacheResult(chunkKey, isCold);
        return isCold;
    }

    public static boolean isSnowBlockBiome(LevelReader level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        Holder biomeHolder = level.m_204166_(pos);
        if (biomeHolder.m_203656_(ModTags.Biomes.SNOW_BLOCK_BIOMES)) {
            return true;
        }
        long chunkKey = BiomeTemperatureHelper.getChunkKey(pos);
        if (snowBlockChunkCache.containsKey(chunkKey)) {
            return snowBlockChunkCache.get(chunkKey);
        }
        boolean isSnowBlock = false;
        BiomeTemperatureHelper.cacheSnowBlockResult(chunkKey, isSnowBlock);
        return isSnowBlock;
    }

    public static float getTemperatureAt(LevelReader level, BlockPos pos) {
        if (level == null || pos == null) {
            return 1.0f;
        }
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        return biome.m_47554_();
    }

    private static long getChunkKey(BlockPos pos) {
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        return ((long)chunkX & 0xFFFFFFFFL) << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    private static void cacheResult(long chunkKey, boolean isCold) {
        if (chunkCache.size() >= 2048) {
            BiomeTemperatureHelper.clearCache();
        }
        chunkCache.put(chunkKey, isCold);
    }

    private static void cacheSnowBlockResult(long chunkKey, boolean isSnowBlock) {
        if (snowBlockChunkCache.size() >= 2048) {
            BiomeTemperatureHelper.clearSnowBlockCache();
        }
        snowBlockChunkCache.put(chunkKey, isSnowBlock);
    }

    public static void clearCache() {
        chunkCache.clear();
    }

    public static void clearSnowBlockCache() {
        snowBlockChunkCache.clear();
    }

    public static void clearCacheAt(BlockPos pos) {
        long chunkKey = BiomeTemperatureHelper.getChunkKey(pos);
        chunkCache.remove(chunkKey);
        snowBlockChunkCache.remove(chunkKey);
    }
}

