/*
 * Decompiled with CFR 0.152.
 */
package net.memeland.bsf.worldgen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.memeland.bsf.ModConfig;
import net.memeland.bsf.block.ModBlocks;
import net.memeland.bsf.util.BiomeTemperatureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bsf")
public class IcicleWorldgenDecorator {
    private static final String NBT_KEY = "bsf_icicles_decorated";
    private static final float ICICLE_CHANCE = 0.2f;
    private static final int MAX_ICICLES_PER_CHUNK = 8;
    private static final int SEARCH_DEPTH = 30;
    private static final int MIN_Y = 60;
    private static final Map<ChunkPos, Boolean> chunkDecorationStatus = new HashMap<ChunkPos, Boolean>();
    private static final Queue<ChunkPos> pendingChunks = new LinkedList<ChunkPos>();

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (!((Boolean)ModConfig.ENABLE_ICICLES.get()).booleanValue()) {
            return;
        }
        CompoundTag nbt = event.getData();
        ChunkPos chunkPos = event.getChunk().m_7697_();
        if (nbt.m_128441_(NBT_KEY)) {
            boolean decorated = nbt.m_128471_(NBT_KEY);
            chunkDecorationStatus.put(chunkPos, decorated);
        }
    }

    @SubscribeEvent
    public static void onChunkDataSave(ChunkDataEvent.Save event) {
        if (!((Boolean)ModConfig.ENABLE_ICICLES.get()).booleanValue()) {
            return;
        }
        ChunkPos chunkPos = event.getChunk().m_7697_();
        Boolean decorated = chunkDecorationStatus.get(chunkPos);
        if (decorated != null && decorated.booleanValue()) {
            CompoundTag nbt = event.getData();
            nbt.m_128379_(NBT_KEY, true);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!((Boolean)ModConfig.ENABLE_ICICLES.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        if (!chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
            return;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        Boolean decorated = chunkDecorationStatus.get(chunkPos);
        if (decorated != null && decorated.booleanValue()) {
            return;
        }
        if (!pendingChunks.contains(chunkPos)) {
            pendingChunks.add(chunkPos);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkPos chunkPos = event.getChunk().m_7697_();
        chunkDecorationStatus.remove(chunkPos);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        ChunkPos chunkPos;
        if (!((Boolean)ModConfig.ENABLE_ICICLES.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (pendingChunks.isEmpty()) {
            return;
        }
        int processed = 0;
        while (!pendingChunks.isEmpty() && processed < 5 && (chunkPos = pendingChunks.poll()) != null) {
            LevelChunk chunk;
            Boolean decorated = chunkDecorationStatus.get(chunkPos);
            if (decorated != null && decorated.booleanValue() || (chunk = (LevelChunk)serverLevel.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false)) == null) continue;
            BlockPos centerPos = new BlockPos(chunkPos.m_151390_(), 100, chunkPos.m_151393_());
            if (!BiomeTemperatureHelper.isColdAt((LevelReader)serverLevel, centerPos)) {
                chunkDecorationStatus.put(chunkPos, true);
                chunk.m_8092_(true);
                continue;
            }
            IcicleWorldgenDecorator.addIciclesToChunk(serverLevel, chunk);
            chunkDecorationStatus.put(chunkPos, true);
            chunk.m_8092_(true);
            ++processed;
        }
    }

    private static void addIciclesToChunk(ServerLevel level, LevelChunk chunk) {
        RandomSource random = level.m_213780_();
        ChunkPos chunkPos = chunk.m_7697_();
        int iciclesPlaced = 0;
        int minX = chunkPos.m_45604_();
        int minZ = chunkPos.m_45605_();
        int attempts = 64;
        block0: for (int attempt = 0; attempt < attempts && iciclesPlaced < 8; ++attempt) {
            int surfaceY;
            int xOffset = random.m_188503_(16);
            int zOffset = random.m_188503_(16);
            int x = minX + xOffset;
            int z = minZ + zOffset;
            for (int y = surfaceY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, xOffset, zOffset); y > Math.max(surfaceY - 15, 60); --y) {
                BlockPos belowPos;
                BlockState belowState;
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = chunk.m_8055_(pos);
                if (!state.m_204336_(BlockTags.f_13035_) || !(random.m_188501_() < 0.2f) || !(belowState = chunk.m_8055_(belowPos = pos.m_7495_())).m_60795_()) continue;
                level.m_7731_(belowPos, ((Block)ModBlocks.ICICLE.get()).m_49966_(), 3);
                ++iciclesPlaced;
                continue block0;
            }
        }
    }
}

