/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.item;

import hal.studios.hpm.entity.HandCannonProjectileEntity;
import hal.studios.hpm.procedures.CanUseCannonHandProcedure;
import hal.studios.hpm.procedures.HandCannonRangedItemUsedProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class HandCannonItem
extends Item {
    public HandCannonItem(Item.Properties properties) {
        super(properties.durability(59));
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 0.0f;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult.Fail ar = InteractionResult.FAIL;
        if (CanUseCannonHandProcedure.execute((Entity)entity) && (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY)) {
            ar = InteractionResult.SUCCESS;
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                HandCannonProjectileEntity projectile = HandCannonProjectileEntity.shoot(world, entity, world.getRandom());
                itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                HandCannonRangedItemUsedProcedure.execute((LevelAccessor)world, (Entity)entity);
            }
        }
        return super.releaseUsing(itemstack, world, entity, time);
    }

    private ItemStack findAmmo(Player player) {
        ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, e -> e.getItem() == HandCannonProjectileEntity.PROJECTILE_ITEM.getItem());
        if (stack == ItemStack.EMPTY) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack teststack = player.getInventory().getItem(i);
                if (teststack == null || teststack.getItem() != HandCannonProjectileEntity.PROJECTILE_ITEM.getItem()) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }
}

