/*
 * Decompiled with CFR 0.152.
 */
package trofers.fabric;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import trofers.Trofers;
import trofers.data.AdvancementDrops;
import trofers.data.EntityDrops;
import trofers.network.DataPackLoadedPacket;
import trofers.registry.ModRegistries;
import trofers.trophy.Trophy;

public class TrofersFabric
implements ModInitializer {
    public void onInitialize() {
        Trofers.init();
        this.registerRegistries();
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> NetworkManager.sendToPlayer((class_3222)player, (class_8710)new DataPackLoadedPacket()));
    }

    public void registerRegistries() {
        DynamicRegistries.registerSynced(ModRegistries.TROPHIES, TrofersFabric.matchConditionsOrDefault(Trophy.MAP_CODEC, Trophy.EMPTY), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(ModRegistries.ENTITY_DROPS, TrofersFabric.matchConditionsOrDefault(EntityDrops.MAP_CODEC, EntityDrops.NONE), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(ModRegistries.ADVANCEMENT_DROPS, TrofersFabric.matchConditionsOrDefault(AdvancementDrops.MAP_CODEC, AdvancementDrops.NONE), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
    }

    public static <T> Codec<T> matchConditionsOrDefault(MapCodec<T> codec, T otherwise) {
        return Codec.either((Codec)ResourceCondition.LIST_CODEC.xmap(conditions -> conditions.stream().allMatch(condition -> condition.test(null)), b -> List.of()).dispatch("fabric:load_conditions", trophy -> true, b -> b != false ? codec : MapCodec.unit((Object)otherwise)), (Codec)codec.codec()).xmap(either -> either.map(l -> l, r -> r), Either::left);
    }
}

