/*
 * Decompiled with CFR 0.152.
 */
package trofers.screen;

import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_811;
import net.minecraft.class_8710;
import trofers.block.entity.TrophyBlockEntity;
import trofers.network.SetTrophyPacket;
import trofers.trophy.Trophy;
import trofers.trophy.TrophySearchTreeManager;

public class TrophySelectionScreen
extends class_437 {
    private static final int HORIZONTAL_PADDING = 80;
    private static final int VERTICAL_PADDING = 16;
    private static final int TROPHY_BUTTON_SIZE = 40;
    private static final int BUTTON_SPACING = 8;
    private static final int CANCEL_BUTTON_WIDTH = 96;
    private static final int NAVIGATION_BUTTON_SIZE = 20;
    private static final int SEARCH_BAR_HEIGHT = 12;
    private static final int SEARCH_BAR_VERTICAL_SPACING = 8;
    private static final int MIN_ROW_COUNT = 2;
    private static final int MIN_COLUMN_COUNT = 2;
    private static final int MAX_COLUMN_COUNT = 16;
    private static final float ITEM_SCALE = 2.0f;
    private List<class_2960> trophies;
    private class_342 searchBox;
    private class_4185 previousButton;
    private class_4185 nextButton;
    private final Set<class_4185> trophyButtons = new HashSet<class_4185>();
    private int currentPage;
    private int rowCount;
    private int columnCount;
    private int rowStart;
    private int columnStart;
    private final class_2680 blockState;
    private final class_2338 blockPos;

    public TrophySelectionScreen(class_2680 blockState, class_2338 blockPos) {
        super((class_2561)class_2561.method_43473());
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.currentPage = -1;
        this.trophies = TrophySearchTreeManager.search("");
    }

    public static void open(class_2680 blockState, class_2338 pos) {
        class_310.method_1551().method_1507((class_437)new TrophySelectionScreen(blockState, pos));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean isInventoryKeyDown;
        boolean bl = isInventoryKeyDown = this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode);
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!this.searchBox.method_25370() && isInventoryKeyDown) {
            this.method_25419();
            return true;
        }
        return false;
    }

    protected void method_25426() {
        this.columnCount = (this.field_22789 - 160 - 40) / 48 + 1;
        this.columnCount = Math.max(this.columnCount, 2);
        this.columnCount = Math.min(this.columnCount, 16);
        this.columnStart = this.field_22789 / 2 - (40 * this.columnCount + 8 * (this.columnCount - 1)) / 2;
        this.rowStart = 64;
        this.rowCount = (this.field_22790 - this.rowStart - 16 - 40) / 48 + 1;
        this.rowCount = Math.max(this.rowCount, 2);
        this.createUpperButtons();
        this.method_48265((class_364)this.searchBox);
        if (this.currentPage == -1) {
            this.setCurrentPage(0);
        }
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        int previousRowCount = this.rowCount;
        int previousColumnCount = this.columnCount;
        String search = this.searchBox.method_1882();
        List<class_2960> trophies = this.trophies;
        super.method_25410(minecraft, width, height);
        this.searchBox.method_1852(search);
        this.trophies = trophies;
        if (this.columnCount == previousColumnCount && this.rowCount == previousRowCount) {
            this.setCurrentPage(this.currentPage);
        } else {
            this.setCurrentPage(0);
        }
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        boolean result = super.method_25402(pMouseX, pMouseY, pButton);
        if (this.method_25399() != this.searchBox) {
            this.searchBox.method_25365(false);
        }
        return result;
    }

    private void createUpperButtons() {
        int xPos = this.field_22789 / 2 - 48 - 8 - 20;
        this.previousButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), button -> this.setCurrentPage(this.currentPage - 1)).method_46433(xPos, 16).method_46432(20).method_46431();
        this.method_37063((class_364)this.previousButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46433(xPos += 28, 16).method_46432(96).method_46431();
        this.method_37063((class_364)cancelButton);
        this.nextButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), button -> this.setCurrentPage(this.currentPage + 1)).method_46433(xPos += 104, 16).method_46432(20).method_46431();
        this.method_37063((class_364)this.nextButton);
        int searchBoxX = this.field_22789 / 2 - 48 - 8 - 20;
        int searchBoxY = 44;
        int searchBoxWidth = 152;
        class_5250 searchBoxNarration = class_2561.method_43471((String)"itemGroup.search");
        this.searchBox = new class_342(this.field_22793, searchBoxX, searchBoxY, searchBoxWidth, 12, (class_2561)searchBoxNarration);
        this.searchBox.method_1858(true);
        this.searchBox.method_1863(this::onEditSearchBox);
        this.method_37063((class_364)this.searchBox);
    }

    public void onEditSearchBox(String text) {
        List<class_2960> searchResult = TrophySearchTreeManager.search(text);
        if (!searchResult.equals(this.trophies)) {
            this.trophies = searchResult;
            this.setCurrentPage(0);
        }
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.trophyButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.trophyButtons.clear();
        int index = currentPage * this.columnCount * this.rowCount;
        for (int row = 0; row < this.rowCount; ++row) {
            for (int column = 0; column < this.columnCount && index < this.trophies.size(); ++column) {
                class_2960 trophyId = this.trophies.get(index++);
                class_1799 stack = Trophy.createItem((class_1935)this.blockState.method_26204(), trophyId);
                int x = this.columnStart + column * 48;
                int y = this.rowStart + row * 48;
                TrophyButton trophyButton = new TrophyButton(x, y, 40, stack, trophyId);
                this.trophyButtons.add((class_4185)this.method_37063((class_364)trophyButton));
            }
        }
        this.nextButton.field_22763 = false;
        this.previousButton.field_22763 = false;
        if (index < this.trophies.size() - 1) {
            this.nextButton.field_22763 = true;
        }
        if (currentPage > 0) {
            this.previousButton.field_22763 = true;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private class TrophyButton
    extends class_4185 {
        private final class_1799 item;
        private final class_2960 trophyId;
        private final int x;
        private final int y;

        private TrophyButton(int xPos, int yPos, int size, class_1799 item, class_2960 trophyId) {
            super(xPos, yPos, size, size, (class_2561)class_2561.method_43473(), button -> {}, supplier -> item.method_7964().method_27661());
            this.method_47400(class_7919.method_47407((class_2561)item.method_7964()));
            this.trophyId = trophyId;
            this.item = item;
            this.x = xPos;
            this.y = yPos;
        }

        public void method_25348(double x, double y) {
            class_2586 class_25862;
            NetworkManager.sendToServer((class_8710)new SetTrophyPacket(this.trophyId, TrophySelectionScreen.this.blockPos));
            if (class_310.method_1551().field_1724 != null && (class_25862 = class_310.method_1551().field_1724.method_37908().method_8321(TrophySelectionScreen.this.blockPos)) instanceof TrophyBlockEntity) {
                TrophyBlockEntity blockEntity = (TrophyBlockEntity)class_25862;
                blockEntity.setTrophy(this.trophyId, null);
            }
            TrophySelectionScreen.this.method_25419();
        }

        public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
            this.tryRenderScaledGuiItem(guiGraphics, this.item, this.x + (int)((float)this.field_22758 - 32.0f) / 2, this.y + (int)((float)this.field_22759 - 32.0f) / 2, 2.0f);
        }

        private void tryRenderScaledGuiItem(class_332 graphics, class_1799 stack, int x, int y, float scale) {
            if (!stack.method_7960()) {
                class_1087 bakedModel = class_310.method_1551().method_1480().method_4019(stack, (class_1937)class_310.method_1551().field_1687, null, 0);
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)x + 8.0f * scale, (float)y + 8.0f * scale, 150.0f);
                try {
                    boolean bl;
                    graphics.method_51448().method_22905(16.0f * scale, -16.0f * scale, 16.0f * scale);
                    boolean bl2 = bl = !bakedModel.method_24304();
                    if (bl) {
                        class_308.method_24210();
                    }
                    class_310.method_1551().method_1480().method_23179(stack, class_811.field_4317, false, graphics.method_51448(), (class_4597)graphics.method_51450(), 0xF000F0, class_4608.field_21444, bakedModel);
                    graphics.method_51452();
                    if (bl) {
                        class_308.method_24211();
                    }
                }
                catch (Throwable var12) {
                    class_128 crashReport = class_128.method_560((Throwable)var12, (String)"Rendering item");
                    class_129 crashReportCategory = crashReport.method_562("Item being rendered");
                    crashReportCategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                    crashReportCategory.method_577("Item Components", () -> String.valueOf(stack.method_57353()));
                    crashReportCategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                    throw new class_148(crashReport);
                }
                graphics.method_51448().method_22909();
            }
        }
    }
}

