/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import trofers.trophy.builder.TrophyBuilder;
import trofers.trophy.components.EntityInfo;

public class EntityTrophyBuilder<T extends EntityTrophyBuilder<T>>
extends TrophyBuilder<T> {
    private final EntityInfo entityInfo;

    protected EntityTrophyBuilder(class_2960 entityId) {
        this.entityInfo = new EntityInfo(entityId, new class_2487());
    }

    public class_2960 getEntityId() {
        return this.entityInfo.id();
    }

    @Override
    protected class_1799 getDisplayItem() {
        return class_1799.field_8037;
    }

    @Override
    protected Optional<EntityInfo> getEntityInfo() {
        return Optional.of(this.entityInfo);
    }

    public T tag(Consumer<class_2487> tagConsumer) {
        tagConsumer.accept(this.entityInfo.tag());
        return (T)this;
    }

    public T tag(String name, Consumer<class_2487> tagConsumer) {
        if (!this.entityInfo.tag().method_10545(name)) {
            this.entityInfo.tag().method_10566(name, (class_2520)new class_2487());
        }
        tagConsumer.accept(this.entityInfo.tag().method_10562(name));
        return (T)this;
    }

    public T putTag(String name, class_2520 tag) {
        this.entityInfo.tag().method_10566(name, tag);
        return (T)this;
    }

    public T putByte(String name, byte b) {
        this.entityInfo.tag().method_10567(name, b);
        return (T)this;
    }

    public T putInt(String name, int i) {
        this.entityInfo.tag().method_10569(name, i);
        return (T)this;
    }

    public T putFloat(String name, float f) {
        this.entityInfo.tag().method_10548(name, f);
        return (T)this;
    }

    public T putBoolean(String name, boolean b) {
        this.entityInfo.tag().method_10556(name, b);
        return (T)this;
    }

    public T putString(String name, String s) {
        this.entityInfo.tag().method_10582(name, s);
        return (T)this;
    }

    public T putUUID(String name, UUID uuid) {
        this.entityInfo.tag().method_25927(name, uuid);
        return (T)this;
    }

    public T putCustomName(String customName) {
        return this.putString("CustomName", "\"%s\"".formatted(customName));
    }

    public T putItem(String tag, class_1799 stack) {
        return this.putTag(tag, EntityTrophyBuilder.itemStackToNbt(stack));
    }

    public T putItem(String tag, class_1792 item) {
        return this.putItem(tag, new class_1799((class_1935)item));
    }

    public T putEquipment(class_1304 slot, class_2520 item) {
        class_2499 slots;
        String tagName;
        String string = tagName = slot.method_5925() == class_1304.class_1305.field_6177 ? "HandItems" : "ArmorItems";
        if (!this.entityInfo.tag().method_10573(tagName, 9)) {
            slots = new class_2499();
            int size = slot.method_5925() == class_1304.class_1305.field_6177 ? 2 : 4;
            for (int i = 0; i < size; ++i) {
                slots.add((Object)new class_2487());
            }
            this.entityInfo.tag().method_10566(tagName, (class_2520)slots);
        }
        slots = this.entityInfo.tag().method_10554(tagName, 10);
        slots.method_10606(slot.method_5927(), item);
        return (T)this;
    }

    public T putEquipment(class_1304 slot, class_1799 itemStack) {
        return this.putEquipment(slot, EntityTrophyBuilder.itemStackToNbt(itemStack));
    }

    public T putEquipment(class_1304 slot, class_1792 item) {
        return this.putEquipment(slot, new class_1799((class_1935)item));
    }

    public T putHandItem(class_1792 item) {
        return this.putEquipment(class_1304.field_6173, item);
    }

    private static class_2520 itemStackToNbt(class_1799 stack) {
        return (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).getOrThrow();
    }
}

