/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;
import trofers.util.ConditionsHelper;

public abstract class TrophyBuilder<T extends TrophyBuilder<T>> {
    private Optional<class_2561> name = Optional.empty();
    private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
    private DisplayInfo displayInfo = DisplayInfo.NONE;
    private Animation animation = Animation.STATIC;
    private ColorInfo colorInfo = ColorInfo.NONE;
    private EffectInfo effectInfo = EffectInfo.NONE;
    private boolean isHidden = false;
    private final Set<String> requiredMods = new HashSet<String>();

    public Trophy build() {
        return new Trophy(this.name, this.tooltipLines, this.displayInfo, this.animation, this.getDisplayItem(), this.getEntityInfo(), this.colorInfo, this.effectInfo, this.isHidden);
    }

    protected abstract class_1799 getDisplayItem();

    protected abstract Optional<EntityInfo> getEntityInfo();

    public T requiresMod(String modId) {
        if (!modId.equals("trofers") && !modId.equals("minecraft")) {
            this.requiredMods.add(modId);
        }
        return (T)this;
    }

    public T name(@Nullable class_2561 name) {
        this.name = Optional.ofNullable(name);
        return (T)this;
    }

    public T addTooltipLine(class_2561 component) {
        this.tooltipLines.add(component);
        return (T)this;
    }

    public T offset(double xOffset, double yOffset, double zOffset) {
        this.displayInfo = new DisplayInfo(new class_243(xOffset, yOffset, zOffset), this.displayInfo.rotation(), this.displayInfo.scale());
        return (T)this;
    }

    public T rotate(double xRotation, double yRotation, double zRotation) {
        this.displayInfo = new DisplayInfo(this.displayInfo.offset(), new class_243(xRotation, yRotation, zRotation), this.displayInfo.scale());
        return (T)this;
    }

    public T scale(double scale) {
        this.displayInfo = new DisplayInfo(this.displayInfo.offset(), this.displayInfo.rotation(), scale);
        return (T)this;
    }

    public T animation(Animation.Type type, float speed) {
        this.animation = new Animation(type, speed);
        return (T)this;
    }

    public T animation(Animation.Type type) {
        return this.animation(type, 1.0f);
    }

    public T color(int baseColor, int accentColor) {
        this.colorInfo = new ColorInfo(baseColor, accentColor);
        return (T)this;
    }

    public T baseColor(int color) {
        return this.color(color, this.colorInfo.accent());
    }

    public T accentColor(int color) {
        return this.color(this.colorInfo.base(), color);
    }

    private T effectInfo(Optional<EffectInfo.SoundInfo> soundInfo, EffectInfo.RewardInfo rewardInfo) {
        this.effectInfo = new EffectInfo(soundInfo, rewardInfo);
        return (T)this;
    }

    public T sound(class_2960 sound, float volume, float pitch) {
        return this.effectInfo(Optional.of(new EffectInfo.SoundInfo(sound, volume, pitch)), this.effectInfo.rewards());
    }

    public T sound(class_2960 sound) {
        return this.sound(sound, 1.0f, 1.0f);
    }

    public T sound(class_3414 sound, float volume, float pitch) {
        return this.sound(sound.method_14833(), volume, pitch);
    }

    public T sound(class_3414 soundEvent) {
        return this.sound(soundEvent, 1.0f, 1.0f);
    }

    private T rewardInfo(Optional<class_5321<class_52>> lootTable, Optional<EffectInfo.MobEffectInfo> mobEffect, int cooldown) {
        return this.effectInfo(this.effectInfo.sound(), new EffectInfo.RewardInfo(lootTable, mobEffect, cooldown));
    }

    public T lootTable(Optional<class_5321<class_52>> lootTable) {
        return this.rewardInfo(lootTable, this.effectInfo.rewards().mobEffect(), this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(EffectInfo.MobEffectInfo mobEffect) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), Optional.of(mobEffect), this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(class_6880<class_1291> effect, int timeSeconds, int amplifier) {
        return this.mobEffect(new EffectInfo.MobEffectInfo((class_1291)effect.comp_349(), (byte)amplifier, timeSeconds * 20, false, true, true));
    }

    public T mobEffect(class_6880<class_1291> effect, int timeSeconds) {
        return this.mobEffect(effect, timeSeconds, 0);
    }

    public T cooldown(int timeSeconds) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), this.effectInfo.rewards().mobEffect(), timeSeconds * 20);
    }

    public T setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return (T)this;
    }

    public T setHidden() {
        return this.setHidden(true);
    }

    public JsonObject toJson() {
        JsonObject result = ((JsonElement)Trophy.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.build()).getOrThrow()).getAsJsonObject();
        ConditionsHelper.addModLoadedConditions(result, (String[])this.requiredMods.toArray(String[]::new));
        return result;
    }
}

