/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.manors_bounty.network;

import java.util.function.Supplier;
import net.mcreator.manors_bounty.ManorsBountyMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ManorsBountyModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ManorsBountyMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ManorsBountyMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.AdditionalDamageMultiplier = message.data.AdditionalDamageMultiplier;
                    variables.LurkingDangerSneakingTick = message.data.LurkingDangerSneakingTick;
                    variables.PoisonHealTick = message.data.PoisonHealTick;
                    variables.b_type_foods_effect_time_client = message.data.b_type_foods_effect_time_client;
                    variables.c_type_foods_effect_time_client = message.data.c_type_foods_effect_time_client;
                    variables.do_fruit_effect_enable_client = message.data.do_fruit_effect_enable_client;
                    variables.eat_tomato = message.data.eat_tomato;
                    variables.rare_b_type_foods_effect_time_client = message.data.rare_b_type_foods_effect_time_client;
                    variables.rare_c_type_foods_effect_time_client = message.data.rare_c_type_foods_effect_time_client;
                    variables.gift_pumpkin_get_cooldown = message.data.gift_pumpkin_get_cooldown;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double AdditionalDamageMultiplier = 1.0;
        public double LurkingDangerSneakingTick = 0.0;
        public double PoisonHealTick = 0.0;
        public double b_type_foods_effect_time_client = 0.0;
        public double c_type_foods_effect_time_client = 0.0;
        public boolean do_fruit_effect_enable_client = false;
        public boolean eat_tomato = false;
        public double rare_b_type_foods_effect_time_client = 0.0;
        public double rare_c_type_foods_effect_time_client = 0.0;
        public double gift_pumpkin_get_cooldown = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("AdditionalDamageMultiplier", this.AdditionalDamageMultiplier);
            nbt.m_128347_("LurkingDangerSneakingTick", this.LurkingDangerSneakingTick);
            nbt.m_128347_("PoisonHealTick", this.PoisonHealTick);
            nbt.m_128347_("b_type_foods_effect_time_client", this.b_type_foods_effect_time_client);
            nbt.m_128347_("c_type_foods_effect_time_client", this.c_type_foods_effect_time_client);
            nbt.m_128379_("do_fruit_effect_enable_client", this.do_fruit_effect_enable_client);
            nbt.m_128379_("eat_tomato", this.eat_tomato);
            nbt.m_128347_("rare_b_type_foods_effect_time_client", this.rare_b_type_foods_effect_time_client);
            nbt.m_128347_("rare_c_type_foods_effect_time_client", this.rare_c_type_foods_effect_time_client);
            nbt.m_128347_("gift_pumpkin_get_cooldown", this.gift_pumpkin_get_cooldown);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.AdditionalDamageMultiplier = nbt.m_128459_("AdditionalDamageMultiplier");
            this.LurkingDangerSneakingTick = nbt.m_128459_("LurkingDangerSneakingTick");
            this.PoisonHealTick = nbt.m_128459_("PoisonHealTick");
            this.b_type_foods_effect_time_client = nbt.m_128459_("b_type_foods_effect_time_client");
            this.c_type_foods_effect_time_client = nbt.m_128459_("c_type_foods_effect_time_client");
            this.do_fruit_effect_enable_client = nbt.m_128471_("do_fruit_effect_enable_client");
            this.eat_tomato = nbt.m_128471_("eat_tomato");
            this.rare_b_type_foods_effect_time_client = nbt.m_128459_("rare_b_type_foods_effect_time_client");
            this.rare_c_type_foods_effect_time_client = nbt.m_128459_("rare_c_type_foods_effect_time_client");
            this.gift_pumpkin_get_cooldown = nbt.m_128459_("gift_pumpkin_get_cooldown");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("manors_bounty", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "manors_bounty_mapvars";
        public boolean do_fruit_effect_enable = true;
        public double b_type_foods_effect_time = 0.0;
        public double c_type_foods_effect_time = 0.0;
        public double rutin_lemonene_max_level = 0.0;
        public double momentary_meteor_max_amount = 0.0;
        public double original_evolution_amount = 0.0;
        public double original_evolution_metamorphosis_amount = 0.0;
        public double fruit_tree_drop = 0.0;
        public double fruit_tree_blossom = 0.0;
        public double fruit_tree_fruit = 0.0;
        public double fruit_tree_leaves_fruit_chance = 0.0;
        public double rare_variant_chance = 0.0;
        public double black_dirt_grow_truffle_chance = 0.0;
        public double rare_b_type_foods_effect_time = 0.0;
        public double rare_c_type_foods_effect_time = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.do_fruit_effect_enable = nbt.m_128471_("do_fruit_effect_enable");
            this.b_type_foods_effect_time = nbt.m_128459_("b_type_foods_effect_time");
            this.c_type_foods_effect_time = nbt.m_128459_("c_type_foods_effect_time");
            this.rutin_lemonene_max_level = nbt.m_128459_("rutin_lemonene_max_level");
            this.momentary_meteor_max_amount = nbt.m_128459_("momentary_meteor_max_amount");
            this.original_evolution_amount = nbt.m_128459_("original_evolution_amount");
            this.original_evolution_metamorphosis_amount = nbt.m_128459_("original_evolution_metamorphosis_amount");
            this.fruit_tree_drop = nbt.m_128459_("fruit_tree_drop");
            this.fruit_tree_blossom = nbt.m_128459_("fruit_tree_blossom");
            this.fruit_tree_fruit = nbt.m_128459_("fruit_tree_fruit");
            this.fruit_tree_leaves_fruit_chance = nbt.m_128459_("fruit_tree_leaves_fruit_chance");
            this.rare_variant_chance = nbt.m_128459_("rare_variant_chance");
            this.black_dirt_grow_truffle_chance = nbt.m_128459_("black_dirt_grow_truffle_chance");
            this.rare_b_type_foods_effect_time = nbt.m_128459_("rare_b_type_foods_effect_time");
            this.rare_c_type_foods_effect_time = nbt.m_128459_("rare_c_type_foods_effect_time");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("do_fruit_effect_enable", this.do_fruit_effect_enable);
            nbt.m_128347_("b_type_foods_effect_time", this.b_type_foods_effect_time);
            nbt.m_128347_("c_type_foods_effect_time", this.c_type_foods_effect_time);
            nbt.m_128347_("rutin_lemonene_max_level", this.rutin_lemonene_max_level);
            nbt.m_128347_("momentary_meteor_max_amount", this.momentary_meteor_max_amount);
            nbt.m_128347_("original_evolution_amount", this.original_evolution_amount);
            nbt.m_128347_("original_evolution_metamorphosis_amount", this.original_evolution_metamorphosis_amount);
            nbt.m_128347_("fruit_tree_drop", this.fruit_tree_drop);
            nbt.m_128347_("fruit_tree_blossom", this.fruit_tree_blossom);
            nbt.m_128347_("fruit_tree_fruit", this.fruit_tree_fruit);
            nbt.m_128347_("fruit_tree_leaves_fruit_chance", this.fruit_tree_leaves_fruit_chance);
            nbt.m_128347_("rare_variant_chance", this.rare_variant_chance);
            nbt.m_128347_("black_dirt_grow_truffle_chance", this.black_dirt_grow_truffle_chance);
            nbt.m_128347_("rare_b_type_foods_effect_time", this.rare_b_type_foods_effect_time);
            nbt.m_128347_("rare_c_type_foods_effect_time", this.rare_c_type_foods_effect_time);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "manors_bounty_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.b_type_foods_effect_time_client = original.b_type_foods_effect_time_client;
            clone.c_type_foods_effect_time_client = original.c_type_foods_effect_time_client;
            clone.do_fruit_effect_enable_client = original.do_fruit_effect_enable_client;
            clone.eat_tomato = original.eat_tomato;
            clone.rare_b_type_foods_effect_time_client = original.rare_b_type_foods_effect_time_client;
            clone.rare_c_type_foods_effect_time_client = original.rare_c_type_foods_effect_time_client;
            clone.gift_pumpkin_get_cooldown = original.gift_pumpkin_get_cooldown;
            if (!event.isWasDeath()) {
                clone.AdditionalDamageMultiplier = original.AdditionalDamageMultiplier;
                clone.LurkingDangerSneakingTick = original.LurkingDangerSneakingTick;
                clone.PoisonHealTick = original.PoisonHealTick;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ManorsBountyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

