/*
 * Decompiled with CFR 0.152.
 */
package com.sohatuy.medieval_structures;

import com.sohatuy.medieval_structures.ModVillagers.VillagerInit;
import com.sohatuy.medieval_structures.init.BlockInit;
import com.sohatuy.medieval_structures.init.ItemInit;
import java.util.function.Predicate;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="medieval_structures")
public class MedievalStructuresMod {
    public static final String MODID = "medieval_structures";
    final Logger LOGGER = LogManager.getLogger();

    public MedievalStructuresMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BlockInit.BLOCKS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        VillagerInit.POI_TYPES.register(modEventBus);
        VillagerInit.VILLAGER_PROFESSIONS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            VillagerInit.registerPOIs();
            this.LOGGER.info("=== Medieval Structures Debug ===");
            if (VillagerInit.HERMIT.isPresent()) {
                this.LOGGER.info("\u2713 \u041f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430: {}", (Object)VillagerInit.HERMIT.getId());
                VillagerProfession profession = (VillagerProfession)VillagerInit.HERMIT.get();
                Predicate jobSiteHolder = profession.f_219628_();
                this.LOGGER.info("  - Job site predicate: {}", (Object)jobSiteHolder);
                this.LOGGER.info("  - POI Key: {}", (Object)VillagerInit.HERMIT_POI.getKey());
            }
            this.LOGGER.info("\u0412\u0441\u0435 POI \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435: {}", (Object)ForgeRegistries.POI_TYPES.getKeys());
            this.LOGGER.info("\u0412\u0441\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0438 \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435: {}", (Object)ForgeRegistries.VILLAGER_PROFESSIONS.getKeys());
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.LOGGER.info("=== \u0417\u0430\u043f\u0443\u0441\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 ===");
        this.LOGGER.info("HERMIT_MASTER \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u044f: {}", VillagerInit.HERMIT.get());
    }

    @Mod.EventBusSubscriber(modid="medieval_structures", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

