/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.effects;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.itzme1on.alcocraftplus.core.mixin.AttractTracked;
import me.itzme1on.alcocraftplus.core.registries.EffectsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AttractEffect
extends MobEffect {
    private static final long PARTICLE_INTERVAL_TICKS = 20L;
    private static final double PARTICLES_PER_BLOCK = 2.0;
    private static final DustParticleOptions DUST_COLOR = new DustParticleOptions(new Vector3f(0.6666667f, 0.05490196f, 0.003921569f), 0.5f);
    private static final double SEARCH_RADIUS_BLOCKS = 15.0;
    private static final double ATTRACT_RING_RADIUS_BLOCKS = 1.0;
    private static final double EPSILON = 1.0E-4;
    private static final double MAX_VERTICAL_DELTA = 0.35;
    private static MobEffect ATTRACT_EFFECT;

    public AttractEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    private static MobEffect attractEffect() {
        if (ATTRACT_EFFECT == null) {
            ATTRACT_EFFECT = (MobEffect)EffectsRegistry.ATTRACT.get();
        }
        return ATTRACT_EFFECT;
    }

    private static Set<ItemEntity> selectParticleSources(List<ItemEntity> nearbyItems, List<LivingEntity> attractEffectHolders, LivingEntity contextHolder) {
        HashMap<BlockPos, ItemEntity> bestItemByBlock = new HashMap<BlockPos, ItemEntity>();
        HashMap<BlockPos, Double> bestDist2ByBlock = new HashMap<BlockPos, Double>();
        if (attractEffectHolders.isEmpty()) {
            return Collections.emptySet();
        }
        for (ItemEntity item : nearbyItems) {
            LivingEntity nearest;
            if (!item.m_6084_() || item.f_19797_ < 20 || (nearest = AttractEffect.findNearest(attractEffectHolders, item)) == null || nearest.m_19879_() != contextHolder.m_19879_()) continue;
            double distanceToItem = AttractEffect.squaredDistanceFeetToItem(nearest, item);
            BlockPos key = item.m_20183_();
            Double best = (Double)bestDist2ByBlock.get(key);
            if (best != null && !(distanceToItem < best)) continue;
            bestDist2ByBlock.put(key, distanceToItem);
            bestItemByBlock.put(key, item);
        }
        return new HashSet<ItemEntity>(bestItemByBlock.values());
    }

    private static LivingEntity findNearest(List<LivingEntity> holders, ItemEntity item) {
        LivingEntity nearest = null;
        double bestDist2 = Double.MAX_VALUE;
        for (LivingEntity holder : holders) {
            double dist2 = AttractEffect.squaredDistanceFeetToItem(holder, item);
            if (!(dist2 < bestDist2)) continue;
            bestDist2 = dist2;
            nearest = holder;
        }
        return nearest;
    }

    private static Vec3 itemCenter(ItemEntity item) {
        return new Vec3(item.m_20185_(), item.m_20186_() + (double)item.m_20206_() * 0.5, item.m_20189_());
    }

    private static Vec3 entityFeet(LivingEntity entity) {
        return new Vec3(entity.m_20185_(), entity.m_20186_() + 0.05, entity.m_20189_());
    }

    private static Vec3 entityWaist(LivingEntity entity) {
        return new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_());
    }

    private static double squaredDistanceFeetToItem(LivingEntity entity, ItemEntity item) {
        Vec3 feet = AttractEffect.entityFeet(entity);
        Vec3 center = AttractEffect.itemCenter(item);
        double dx = feet.f_82479_ - center.f_82479_;
        double dy = feet.f_82480_ - center.f_82480_;
        double dz = feet.f_82481_ - center.f_82481_;
        return dx * dx + dy * dy + dz * dz;
    }

    private static Vec3 sphericalTargetAroundFeet(ItemEntity item, LivingEntity target) {
        Vec3 from = AttractEffect.itemCenter(item);
        Vec3 to = AttractEffect.entityFeet(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    private static Vec3 sphericalTargetAroundWaist(ItemEntity item, LivingEntity target) {
        Vec3 from = AttractEffect.itemCenter(item);
        Vec3 to = AttractEffect.entityWaist(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    @NotNull
    private static Vec3 computeRingPointTowardTarget(Vec3 from, Vec3 to) {
        Vec3 diff = to.m_82546_(from);
        double len = Math.max(diff.m_82553_(), 1.0E-4);
        Vec3 unit = diff.m_82490_(1.0 / len);
        return new Vec3(to.f_82479_ - unit.f_82479_ * 1.0, to.f_82480_ - unit.f_82480_ * 1.0, to.f_82481_ - unit.f_82481_ * 1.0);
    }

    private static void spawnDustLine(ServerLevel level, Vec3 from, Vec3 to) {
        double distance = from.m_82554_(to);
        int points = Mth.m_14045_((int)((int)Math.floor(distance * 2.0) + 1), (int)1, (int)200);
        if (points <= 1 || distance < 1.0E-6) {
            return;
        }
        double stepX = (to.f_82479_ - from.f_82479_) / (double)(points - 1);
        double stepY = (to.f_82480_ - from.f_82480_) / (double)(points - 1);
        double stepZ = (to.f_82481_ - from.f_82481_) / (double)(points - 1);
        double x = from.f_82479_;
        double y = from.f_82480_;
        double z = from.f_82481_;
        for (int i = 0; i < points; ++i) {
            level.m_8767_((ParticleOptions)DUST_COLOR, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            x += stepX;
            y += stepY;
            z += stepZ;
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        AABB searchBox = entity.m_20191_().m_82400_(15.0);
        List nearbyItems = level.m_45976_(ItemEntity.class, searchBox);
        List<LivingEntity> attractEffectHolders = level.m_45976_(LivingEntity.class, searchBox).stream().filter(e -> e.m_6084_() && e.m_21023_(AttractEffect.attractEffect())).toList();
        if (attractEffectHolders.isEmpty() || nearbyItems.isEmpty()) {
            return;
        }
        Set<ItemEntity> particleSources = AttractEffect.selectParticleSources(nearbyItems, attractEffectHolders, entity);
        HashMap<Integer, Integer> amplifierByHolderId = new HashMap<Integer, Integer>();
        for (LivingEntity holder : attractEffectHolders) {
            MobEffectInstance instance = holder.m_21124_(AttractEffect.attractEffect());
            amplifierByHolderId.put(holder.m_19879_(), instance == null ? 0 : instance.m_19564_());
        }
        for (ItemEntity item : nearbyItems) {
            Vec3 velocity;
            if (!item.m_6084_() || item.f_19797_ < 20) continue;
            LivingEntity nearestHolder = AttractEffect.findNearest(attractEffectHolders, item);
            if (item instanceof AttractTracked) {
                AttractTracked trackedId = (AttractTracked)item;
                trackedId.alcocraftplus$setAttractorId(nearestHolder != null ? nearestHolder.m_19879_() : 0);
            }
            if (nearestHolder == null || entity.m_19879_() != nearestHolder.m_19879_()) continue;
            Vec3 itemCenter = AttractEffect.itemCenter(item);
            Vec3 holderFeet = AttractEffect.entityFeet(nearestHolder);
            Vec3 toFeet = holderFeet.m_82546_(itemCenter);
            double distanceToFeet = Math.max(toFeet.m_82553_(), 1.0E-4);
            Vec3 updatedVelocity = velocity = item.m_20184_();
            if (distanceToFeet <= 1.0) {
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!particleSources.contains(item) || serverLevel.m_46467_() % 20L != 0L) continue;
                Vec3 waistTarget = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
                AttractEffect.spawnDustLine(serverLevel, itemCenter, waistTarget);
                continue;
            }
            Vec3 weightedDirectionSum = Vec3.f_82478_;
            double totalWeight = 0.0;
            for (LivingEntity holder : attractEffectHolders) {
                double feetDistance;
                Vec3 targetPoint = AttractEffect.sphericalTargetAroundFeet(item, holder);
                Vec3 toTarget = targetPoint.m_82546_(itemCenter);
                double toTargetLength = toTarget.m_82553_();
                if (toTargetLength <= 1.0E-6 || (feetDistance = Math.sqrt(AttractEffect.squaredDistanceFeetToItem(holder, item))) > 15.0) continue;
                double closenessNorm = (15.0 - Math.min(feetDistance, 15.0)) / 15.0;
                double weight = closenessNorm * closenessNorm;
                totalWeight += weight;
                weightedDirectionSum = weightedDirectionSum.m_82549_(toTarget.m_82490_(1.0 / toTargetLength * weight));
            }
            if (weightedDirectionSum.m_82556_() > 1.0E-6) {
                Vec3 direction = weightedDirectionSum.m_82541_();
                double weightFactor = Math.min(totalWeight, 1.0);
                int nearestAmplifier = amplifierByHolderId.getOrDefault(nearestHolder.m_19879_(), 0);
                double acceleration = 0.08 + 0.02 * (double)Math.max(0, nearestAmplifier);
                Vec3 deltaV = direction.m_82490_(weightFactor * acceleration);
                if (deltaV.f_82480_ > 0.35) {
                    deltaV = new Vec3(deltaV.f_82479_, 0.35, deltaV.f_82481_);
                }
                if (deltaV.f_82480_ < -0.35) {
                    deltaV = new Vec3(deltaV.f_82479_, -0.35, deltaV.f_82481_);
                }
                updatedVelocity = velocity.m_82549_(deltaV);
            }
            if (updatedVelocity.f_82480_ > 0.35) {
                updatedVelocity = new Vec3(updatedVelocity.f_82479_, 0.35, updatedVelocity.f_82481_);
            }
            if (updatedVelocity.f_82480_ < -0.35) {
                updatedVelocity = new Vec3(updatedVelocity.f_82479_, -0.35, updatedVelocity.f_82481_);
            }
            item.m_20256_(updatedVelocity);
            if (item instanceof AttractTracked) {
                AttractTracked tracked = (AttractTracked)item;
                Vec3 appliedAcceleration = updatedVelocity.m_82546_(velocity);
                tracked.alcocraftplus$setAttractAccel(appliedAcceleration);
                tracked.alcocraftplus$setAttractTtl(2);
            }
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!particleSources.contains(item) || serverLevel.m_46467_() % 20L != 0L) continue;
            Vec3 toWaist = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
            AttractEffect.spawnDustLine(serverLevel, itemCenter, toWaist);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

